/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IEnumSpectrum;
import fr.esrf.tangoatk.core.IEnumSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumSpectrum;
import java.io.Serializable;

public class EnumSpectrumHelper
implements Serializable {
    AAttribute enumSpectAtt;
    EventSupport propChanges;

    public EnumSpectrumHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        this.setAttribute(aAttribute);
        this.propChanges = aAttribute.getPropChanges();
    }

    public void setAttribute(AAttribute aAttribute) {
        this.enumSpectAtt = aAttribute;
    }

    public AAttribute getAttribute() {
        return this.enumSpectAtt;
    }

    private short getOneShortValueFromEnum(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = ((EnumSpectrum)this.enumSpectAtt).getEnumValues();
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        short s = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            s = (short)i;
            break;
        }
        if (s >= stringArray.length) {
            s = -1;
        }
        return s;
    }

    private String getOneEnumValueFromShort(short s) throws IllegalArgumentException {
        String[] stringArray = ((EnumSpectrum)this.enumSpectAtt).getEnumValues();
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        if (s < 0 || s >= stringArray.length) {
            throw new IllegalArgumentException();
        }
        return stringArray[s];
    }

    public short[] getShortValuesFromEnumValues(String[] stringArray) {
        short[] sArray = new short[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                sArray[i] = this.getOneShortValueFromEnum(stringArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return sArray;
    }

    public String[] getEnumValuesFromShort(short[] sArray) {
        String[] stringArray = new String[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            try {
                stringArray[i] = this.getOneEnumValueFromShort(sArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return stringArray;
    }

    void insert(String[] stringArray) throws DevFailed, AttributeSetException {
        DeviceAttribute deviceAttribute = this.enumSpectAtt.getAttribute();
        if (deviceAttribute == null) {
            throw new AttributeSetException("Cannot set enumeration value. DeviceAttribute is null.");
        }
        try {
            short[] sArray = this.getShortValuesFromEnumValues(stringArray);
            deviceAttribute.insert(sArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AttributeSetException("Invalid enumeration value");
        }
    }

    String[] getEnumSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed, AttributeReadException {
        short[] sArray = deviceAttribute.extractShortArray();
        int n = deviceAttribute.getNbRead();
        short[] sArray2 = new short[n];
        if (n < 1) {
            throw new AttributeReadException("Invalid shortArray");
        }
        System.arraycopy(sArray, 0, sArray2, 0, n);
        return this.getEnumValuesFromShort(sArray2);
    }

    String[] getEnumSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed, AttributeReadException {
        int n;
        short[] sArray = deviceAttribute.extractShortArray();
        int n2 = sArray.length - (n = deviceAttribute.getNbRead());
        if (n2 < 1) {
            return this.getEnumSpectrumValue(deviceAttribute);
        }
        short[] sArray2 = new short[n2];
        System.arraycopy(sArray, n, sArray2, 0, n2);
        return this.getEnumValuesFromShort(sArray2);
    }

    public void addEnumSpectrumListener(IEnumSpectrumListener iEnumSpectrumListener) {
        this.propChanges.addEnumSpectrumListener(iEnumSpectrumListener);
    }

    public void removeEnumSpectrumListener(IEnumSpectrumListener iEnumSpectrumListener) {
        this.propChanges.removeEnumSpectrumListener(iEnumSpectrumListener);
    }

    void fireEnumSpectrumValueChanged(String[] stringArray, long l) {
        this.propChanges.fireEnumSpectrumEvent((IEnumSpectrum)((Object)this.enumSpectAtt), stringArray, l);
    }

    public String getVersion() {
        return "$Id: EnumSpectrumHelper.java 27618 2015-03-09 16:54:35Z poncet $";
    }
}

