/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEnumSpectrum;
import fr.esrf.tangoatk.core.IEnumSpectrumListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringArrayProperty;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumSpectrumHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public class EnumSpectrum
extends AAttribute
implements IEnumSpectrum,
PropertyChangeListener {
    EnumSpectrumHelper enumSpecHelper = null;
    String[] spectrumValue = null;
    String[] spectrumSetPointValue = null;
    private String[] enumLabels = null;

    public EnumSpectrum(String[] stringArray) {
        this.enumLabels = stringArray;
    }

    @Override
    protected void init(Device device, String string, AttributeInfoEx attributeInfoEx, boolean bl) {
        super.init(device, string, attributeInfoEx, bl);
        Property property = null;
        property = this.getProperty("enum_label");
        if (property != null) {
            property.addPresentationListener(this);
        }
    }

    @Override
    public String getType() {
        return "EnumSpectrum";
    }

    public void setEnumSpectrumHelper(EnumSpectrumHelper enumSpectrumHelper) {
        this.enumSpecHelper = enumSpectrumHelper;
    }

    @Override
    public String[] getEnumSpectrumValue() {
        return this.spectrumValue;
    }

    @Override
    public void setEnumSpectrumValue(String[] stringArray) {
        try {
            this.enumSpecHelper.insert(stringArray);
            this.writeAtt();
        }
        catch (AttributeSetException attributeSetException) {
            this.setAttError("Couldn't set value", attributeSetException);
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    @Override
    public String[] getEnumSpectrumSetPoint() {
        return this.spectrumSetPointValue;
    }

    public String[] getEnumScalarSetPointFromDevice() {
        try {
            this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            this.spectrumSetPointValue = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            this.spectrumSetPointValue = null;
        }
        return this.spectrumSetPointValue;
    }

    @Override
    public void addEnumSpectrumListener(IEnumSpectrumListener iEnumSpectrumListener) {
        this.enumSpecHelper.addEnumSpectrumListener(iEnumSpectrumListener);
        this.addStateListener(iEnumSpectrumListener);
    }

    @Override
    public void removeEnumSpectrumListener(IEnumSpectrumListener iEnumSpectrumListener) {
        this.enumSpecHelper.removeEnumSpectrumListener(iEnumSpectrumListener);
        this.removeStateListener(iEnumSpectrumListener);
    }

    @Override
    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        ++this.refreshCount;
        this.trace(4, "EnumSpectrum.refresh() method called for " + this.getName(), l);
        try {
            try {
                this.attribute = deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(deviceAttribute);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("EnumSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute deviceAttribute) {
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(deviceAttribute);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("EnumSpectrum.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed devFailed) {
        this.spectrumValue = null;
        this.spectrumSetPointValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    public String[] getEnumValues() {
        return this.enumLabels;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        this.eventType = tangoPeriodicEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "EnumSpectrum.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("EnumSpectrum.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(deviceAttribute);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("EnumSpectrum.periodic.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("EnumSpectrum.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        this.eventType = tangoChangeEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "EnumSpectrum.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("EnumSpectrum.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("EnumSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(deviceAttribute);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attributeReadException) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attributeReadException);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("EnumSpectrum.change.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("EnumSpectrum.change.extractString()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public String getVersion() {
        return "$Id: EnumSpectrum.java 28694 2015-11-09 16:19:57Z poncet $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (property == null) {
            return;
        }
        if (property.getName().equalsIgnoreCase("enum_label") && property instanceof StringArrayProperty) {
            StringArrayProperty stringArrayProperty = (StringArrayProperty)property;
            String[] stringArray = stringArrayProperty.getStringArrayValue();
            this.updateEnumLabels(stringArray);
        }
    }

    private void updateEnumLabels(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.enumLabels = stringArray;
    }
}

