/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoAttConfigListener;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoAttConfigEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.PropertyStorage;
import fr.esrf.tangoatk.core.StringArrayProperty;
import fr.esrf.tangoatk.util.AtkTimer;
import java.io.IOException;
import java.util.Map;

public abstract class AAttribute
implements IAttribute,
ITangoPeriodicListener,
ITangoChangeListener,
ITangoAttConfigListener {
    static final String RAW_IMAGE_FORMAT = "RawImage";
    protected transient AttributeInfoEx config;
    protected PropertyStorage propertyStorage = null;
    protected EventSupport propChanges;
    protected Device device;
    protected DeviceAttribute attribute;
    protected String error;
    protected String nameSansDevice;
    protected String name;
    protected transient AtkTimer timer;
    protected String state = "OK";
    protected long timeStamp;
    @Deprecated
    protected boolean skippingRefresh = false;
    protected String alias;
    protected long refreshCount = 0L;
    protected long changeCount = 0L;
    protected long periodicCount = 0L;
    protected long configCount = 0L;
    protected int eventType = 0;
    protected DevFailed eventError = null;
    private boolean hasEvents = false;
    protected boolean attPropertiesLoaded = false;
    private boolean shouldDoEvent = true;
    private static String VERSION = "$Id: AAttribute.java 28694 2015-11-09 16:19:57Z poncet $";

    public String getVersion() {
        return VERSION;
    }

    protected AAttribute() {
        if (this.propChanges == null) {
            this.propChanges = new EventSupport();
        }
    }

    protected void serializeInit() throws IOException {
        System.out.print(this.name + "...");
        this.timer = AtkTimer.getInstance();
        try {
            AttributeInfoEx attributeInfoEx = this.getDevice().getAttributeInfo(this.name);
            this.init(this.device, this.nameSansDevice, attributeInfoEx, true);
            System.out.println("Done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    protected void init(Device device, String string, AttributeInfoEx attributeInfoEx, boolean bl) {
        AAttribute aAttribute = this;
        this.timer = aAttribute.timer.getInstance();
        this.propertyStorage = new PropertyStorage();
        this.setDevice(device);
        this.nameSansDevice = string;
        this.setName(this.device + "/" + string);
        this.shouldDoEvent = bl;
        this.setConfiguration(attributeInfoEx);
        if (bl && device.doesEvent()) {
            this.subscribeAttributeEvent();
        }
        if (!this.hasEvents) {
            try {
                this.readFirstValueFromNetwork();
            }
            catch (DevFailed devFailed) {
                this.readAttError("Couldn't read from network", new ConnectionException(devFailed));
            }
        }
    }

    protected void connectionlessInit(Device device, String string, boolean bl) {
        AAttribute aAttribute = this;
        this.timer = aAttribute.timer.getInstance();
        this.propertyStorage = new PropertyStorage();
        this.setDevice(device);
        this.nameSansDevice = string;
        this.setName(this.device + "/" + string);
        this.shouldDoEvent = bl;
    }

    protected void reconnectAtt() {
        this.getDevice().reconnect();
        if (!this.getDevice().isConnected()) {
            return;
        }
        try {
            AttributeInfoEx attributeInfoEx = this.getDevice().getAttributeInfo(this.getNameSansDevice());
            this.setConfiguration(attributeInfoEx);
        }
        catch (DevFailed devFailed) {
            return;
        }
        if (this.shouldDoEvent && this.getDevice().doesEvent()) {
            this.subscribeAttributeEvent();
        }
    }

    private void subscribeAttributeEvent() {
        TangoEventsAdapter tangoEventsAdapter = null;
        String[] stringArray = new String[]{};
        try {
            tangoEventsAdapter = new TangoEventsAdapter((DeviceProxy)this.getDevice());
        }
        catch (DevFailed devFailed) {
            this.hasEvents = false;
            return;
        }
        long l = System.currentTimeMillis();
        try {
            tangoEventsAdapter.addTangoChangeListener((ITangoChangeListener)this, this.nameSansDevice, stringArray);
            this.hasEvents = true;
            this.trace(2, "AAttribute.subscribeAttributeChangeEvent(" + this.name + ") ok:", l);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_EventPropertiesNotSet")) {
                try {
                    tangoEventsAdapter.addTangoPeriodicListener((ITangoPeriodicListener)this, this.nameSansDevice, stringArray);
                    this.hasEvents = true;
                    this.trace(2, "AAttribute.subscribeAttributePeriodicEvent(" + this.name + ") ok:", l);
                }
                catch (DevFailed devFailed2) {
                    this.hasEvents = false;
                    this.eventError = devFailed2;
                    this.trace(1, "AATtribute.subscribeAttributePeriodicEvent(" + this.name + ") failed:", l);
                }
            }
            this.hasEvents = false;
            this.eventError = devFailed;
            this.trace(1, "AAttribute.subscribeAttributeEvent(" + this.name + ") failed:", l);
        }
        try {
            tangoEventsAdapter.addTangoAttConfigListener((ITangoAttConfigListener)this, this.nameSansDevice, stringArray);
            this.trace(2, "AAttribute.subscribeAttributeConfigEvent(" + this.name + ") ok:", l);
            return;
        }
        catch (DevFailed devFailed) {
            this.trace(1, "AAttribute.subscribeAttributeConfigEvent(" + this.name + ") failed:", l);
            return;
        }
    }

    public void attConfig(TangoAttConfigEvent tangoAttConfigEvent) {
        ++this.configCount;
        AttributeInfoEx attributeInfoEx = null;
        long l = System.currentTimeMillis();
        this.trace(2048, "AAttribute.attConfig method called for " + this.getName(), l);
        try {
            attributeInfoEx = tangoAttConfigEvent.getValue();
            this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") success", l);
            if (attributeInfoEx != null) {
                this.updateConfiguration(attributeInfoEx);
            }
        }
        catch (DevFailed devFailed) {
            this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
            } else {
                this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, got other DevFailed error", l);
            }
        }
        catch (Exception exception) {
            this.trace(2048, "AAttribute.attConfigEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("AAttribute.attConfigEvt.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("AAttribute.attConfigEvt.getValue()------------------------------------------------");
        }
    }

    @Override
    public boolean hasEvents() {
        return this.hasEvents;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public long getChangeCount() {
        return this.changeCount;
    }

    public int getEventType() {
        return this.eventType;
    }

    public long getPeriodicCount() {
        return this.periodicCount;
    }

    public long getConfigCount() {
        return this.configCount;
    }

    public String getSubscriptionError() {
        if (!this.getDevice().doesEvent()) {
            return "ATK does not manage event for the parent device " + this.getDevice().getName() + " (IDL<3)";
        }
        if (this.eventError != null) {
            return this.eventError.errors[0].desc;
        }
        return "";
    }

    public DeviceAttribute getDeviceAttribute() {
        return this.attribute;
    }

    public String toString() {
        return this.name;
    }

    public EventSupport getPropChanges() {
        return this.propChanges;
    }

    @Override
    public String getType() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.config.data_type;
        switch (n) {
            case 2: {
                stringBuffer.append("Short");
                break;
            }
            case 6: {
                stringBuffer.append("UShort");
                break;
            }
            case 19: {
                stringBuffer.append("State");
                break;
            }
            case 1: {
                stringBuffer.append("Boolean");
                break;
            }
            case 5: {
                stringBuffer.append("Double");
                break;
            }
            case 3: {
                stringBuffer.append("Long");
                break;
            }
            case 7: {
                stringBuffer.append("ULong");
                break;
            }
            case 23: {
                stringBuffer.append("Long64");
                break;
            }
            case 24: {
                stringBuffer.append("ULong64");
                break;
            }
            case 8: {
                stringBuffer.append("String");
                break;
            }
            case 22: {
                stringBuffer.append("UChar");
                break;
            }
            case 4: {
                stringBuffer.append("Float");
                break;
            }
            case 29: {
                stringBuffer.append("Enum");
            }
        }
        AttrDataFormat attrDataFormat = this.config.data_format;
        switch (attrDataFormat.value()) {
            case 0: {
                stringBuffer.append("Scalar");
                break;
            }
            case 1: {
                stringBuffer.append("Spectrum");
                break;
            }
            case 2: {
                stringBuffer.append("Image");
            }
        }
        return stringBuffer.toString();
    }

    public int getTangoDataType() {
        int n = this.config.data_type;
        return n;
    }

    @Override
    public void storeConfig() {
        Property property;
        if (this.getProperty("unit").isSpecified()) {
            this.config.unit = this.getProperty("unit").getStringValue();
        }
        if (this.getProperty("standard_unit").isSpecified()) {
            this.config.standard_unit = this.getProperty("standard_unit").getStringValue();
        }
        if (this.getProperty("format").isSpecified()) {
            this.config.format = this.getProperty("format").getStringValue();
        }
        if (this.getProperty("data_type").isSpecified()) {
            this.config.data_type = this.getProperty("data_type").getIntValue();
        }
        if (this.getProperty("max_dim_x").isSpecified()) {
            this.config.max_dim_x = this.getProperty("max_dim_x").getIntValue();
        }
        if (this.getProperty("max_dim_y").isSpecified()) {
            this.config.max_dim_y = this.getProperty("max_dim_y").getIntValue();
        }
        if (this.getProperty("description").isSpecified()) {
            this.config.description = this.getProperty("description").getStringValue();
        }
        if (this.getProperty("label").isSpecified()) {
            this.config.label = this.getProperty("label").getStringValue();
        }
        if (this.getProperty("display_unit").isSpecified()) {
            this.config.display_unit = this.getProperty("display_unit").getStringValue();
        }
        if ((property = this.getProperty("min_value")) != null && property.isSpecified()) {
            this.config.min_value = property.getStringValue();
        }
        if ((property = this.getProperty("max_value")) != null && property.isSpecified()) {
            this.config.max_value = property.getStringValue();
        }
        if ((property = this.getProperty("min_alarm")) != null && property.isSpecified()) {
            if (this.config.alarms != null) {
                this.config.alarms.min_alarm = property.getStringValue();
            } else {
                this.config.min_alarm = property.getStringValue();
            }
        }
        if ((property = this.getProperty("max_alarm")) != null && property.isSpecified()) {
            if (this.config.alarms != null) {
                this.config.alarms.max_alarm = property.getStringValue();
            } else {
                this.config.max_alarm = property.getStringValue();
            }
        }
        if ((property = this.getProperty("min_warning")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.min_warning = property.getStringValue();
        }
        if ((property = this.getProperty("max_warning")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.max_warning = property.getStringValue();
        }
        if ((property = this.getProperty("delta_t")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.delta_t = property.getStringValue();
        }
        if ((property = this.getProperty("delta_val")) != null && property.isSpecified() && this.config.alarms != null) {
            this.config.alarms.delta_val = property.getStringValue();
        }
        if (this.config.data_type == 29 && (property = this.getProperty("enum_label")) != null && property.isSpecified() && property instanceof StringArrayProperty) {
            StringArrayProperty stringArrayProperty = (StringArrayProperty)property;
            this.config.enum_label = stringArrayProperty.getStringArrayValue();
        }
        try {
            this.device.storeInfo(this.config);
            this.setConfiguration(this.device.getAttributeInfo(this.getName()));
            this.getState();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't store config", new AttributeSetException(devFailed));
        }
    }

    @Override
    public String getFormat() {
        return this.getProperty("format").getStringValue();
    }

    @Override
    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    @Override
    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    @Override
    public void addSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.propChanges.addSetErrorListener(iSetErrorListener);
    }

    @Override
    public void removeSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.propChanges.removeSetErrorListener(iSetErrorListener);
    }

    @Override
    public void addStateListener(IAttributeStateListener iAttributeStateListener) {
        this.propChanges.addAttributeStateListener(iAttributeStateListener);
    }

    @Override
    public void removeStateListener(IAttributeStateListener iAttributeStateListener) {
        this.propChanges.removeAttributeStateListener(iAttributeStateListener);
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    protected void readAttError(String string, Throwable throwable) {
        this.propChanges.fireReadErrorEvent(this, throwable);
    }

    protected void setAttError(String string, Throwable throwable) {
        this.propChanges.fireSetErrorEvent(this, throwable);
    }

    @Override
    public String getUnit() {
        return this.getProperty("unit").getStringValue();
    }

    @Override
    public String getStandardUnit() {
        return this.getProperty("standard_unit").getStringValue();
    }

    @Override
    public double getStandardUnitFactor() {
        double d = (Double)this.getProperty("standard_unit").getValue();
        return d;
    }

    @Override
    public String getDisplayUnit() {
        return this.getProperty("display_unit").getStringValue();
    }

    @Override
    public double getDisplayUnitFactor() {
        double d = (Double)this.getProperty("display_unit").getValue();
        return d;
    }

    @Override
    public String getLabel() {
        return this.getProperty("label").getStringValue();
    }

    @Override
    public void setLabel(String string) {
        this.propertyStorage.setProperty((IEntity)this, "label", string, true);
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.propertyStorage.setProperty((IEntity)this, "name", string, false);
    }

    @Override
    public void setDescription(String string) {
        this.propertyStorage.setProperty((IEntity)this, "description", string, true);
    }

    @Override
    public String getDescription() {
        return this.propertyStorage.getProperty("description").getStringValue();
    }

    public int getLevel() {
        return this.propertyStorage.getProperty("level").getIntValue();
    }

    @Override
    public boolean isOperator() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isOperator();
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isExpert();
        }
        return false;
    }

    private void updateConfiguration(AttributeInfoEx attributeInfoEx) {
        this.setConfiguration(attributeInfoEx);
        this.propertyStorage.refreshProperties();
    }

    protected void setConfiguration(AttributeInfoEx attributeInfoEx) {
        double d;
        double d2;
        this.timer.startTimer(Thread.currentThread());
        this.config = attributeInfoEx;
        this.propertyStorage.setProperty((IEntity)this, "unit", this.config.unit, false);
        this.propertyStorage.setProperty((IAttribute)this, "data_format", this.config.data_format, false);
        this.propertyStorage.setProperty((IEntity)this, "format", this.config.format, true);
        this.propertyStorage.setProperty((IEntity)this, "data_type", new Integer(this.config.data_type), false);
        this.propertyStorage.setProperty((IEntity)this, "description", this.config.description, true);
        this.propertyStorage.setProperty((IEntity)this, "label", this.config.label, true);
        this.propertyStorage.setProperty((IAttribute)this, "writable", this.config.writable, false);
        this.propertyStorage.setProperty((IEntity)this, "writable_attr_name", this.config.writable_attr_name, false);
        if ("None".equals(this.config.writable_attr_name)) {
            this.propertyStorage.getProperty("writable_attr_name").setSpecified(false);
        }
        try {
            d2 = Double.parseDouble(this.config.display_unit);
            if (d2 <= 0.0) {
                d2 = 1.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 1.0;
        }
        this.propertyStorage.setProperty((IEntity)this, "display_unit", new Double(d2), false);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_x", new Integer(this.config.max_dim_x), false);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_y", new Integer(this.config.max_dim_y), false);
        this.propertyStorage.setProperty((IEntity)this, "level", this.config.level, false);
        try {
            d = Double.parseDouble(this.config.standard_unit);
            if (d <= 0.0) {
                d = 1.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d = 1.0;
        }
        this.setProperty("standard_unit", new Double(d), false);
        if (this.config.data_type == 29) {
            this.propertyStorage.setProperty((IEntity)this, "enum_label", this.config.enum_label, true);
        }
        this.timer.endTimer(Thread.currentThread());
    }

    public static String[] getPropertyNames() {
        String[] stringArray = new String[]{"name", "unit", "data_format", "data_type", "description", "label", "writable", "writable_attr_name", "display_unit", "max_dim_x", "max_dim_y", "level", "standard_unit", "min_value", "max_value", "min_alarm", "max_alarm", "min_warning", "max_warning", "delta_t", "delta_val"};
        return stringArray;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String string) {
        this.alias = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameSansDevice() {
        return this.nameSansDevice;
    }

    @Override
    public boolean isWritable() {
        AttrWriteType attrWriteType = (AttrWriteType)this.getProperty("writable").getValue();
        return attrWriteType == AttrWriteType.WRITE || attrWriteType == AttrWriteType.READ_WRITE;
    }

    private final void readFirstValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
    }

    protected final DeviceAttribute readValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttribute(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    protected final DeviceAttribute readDeviceValueFromNetwork() throws DevFailed {
        this.attribute = this.device.readAttributeFromDevice(this.nameSansDevice);
        this.timeStamp = this.attribute.getTimeValMillisSec();
        this.setState();
        return this.attribute;
    }

    public abstract void dispatch(DeviceAttribute var1);

    public abstract void dispatchError(DevFailed var1);

    protected void setState() throws DevFailed {
        AttrQuality attrQuality = this.attribute.getQuality();
        if (0 == attrQuality.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == attrQuality.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == attrQuality.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == attrQuality.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == attrQuality.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    protected void setState(DeviceAttribute deviceAttribute) throws DevFailed {
        AttrQuality attrQuality = deviceAttribute.getQuality();
        if (0 == attrQuality.value()) {
            this.setState("VALID");
            return;
        }
        if (1 == attrQuality.value()) {
            this.setState("INVALID");
            return;
        }
        if (2 == attrQuality.value()) {
            this.setState("ALARM");
            return;
        }
        if (4 == attrQuality.value()) {
            this.setState("WARNING");
            return;
        }
        if (3 == attrQuality.value()) {
            this.setState("CHANGING");
            return;
        }
        this.setState("UNKNOWN");
    }

    public DeviceAttribute getAttribute() {
        return this.attribute;
    }

    protected void setState(String string) {
        this.state = string;
        this.propChanges.fireAttributeStateEvent(this, string);
    }

    @Override
    public String getState() {
        try {
            this.readValueFromNetwork();
        }
        catch (DevFailed devFailed) {
            this.readAttError("Couldn't read from network", new ConnectionException(devFailed));
            return "UNKNOWN";
        }
        catch (Exception exception) {
            this.readAttError("Couldn't read from network", exception);
            return "UNKNOWN";
        }
        return this.state;
    }

    protected void writeAtt() throws DevFailed {
        this.device.writeAttribute(this.attribute);
    }

    @Override
    public int getMaxXDimension() {
        return this.getProperty("max_dim_x").getIntValue();
    }

    @Override
    public int getMaxYDimension() {
        return this.getProperty("max_dim_y").getIntValue();
    }

    @Override
    public int getYDimension() {
        try {
            return this.attribute.getDimY();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int getHeight() {
        return this.getYDimension();
    }

    @Override
    public int getXDimension() {
        try {
            return this.attribute.getDimX();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int getWidth() {
        return this.getYDimension();
    }

    @Override
    @Deprecated
    public void setSkippingRefresh(boolean bl) {
        this.skippingRefresh = bl;
    }

    @Override
    @Deprecated
    public boolean isSkippingRefresh() {
        return this.skippingRefresh;
    }

    protected void checkDimensions(Object[][] objectArray) {
        if (objectArray.length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (objectArray[0].length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(double[][] dArray) {
        if (dArray[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (dArray.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkDimensions(boolean[][] blArray) {
        if (blArray[0].length > this.getMaxXDimension()) {
            throw new IllegalArgumentException();
        }
        if (blArray.length > this.getMaxYDimension()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static String[] flatten(String[][] stringArray) {
        int n = stringArray.length * stringArray[0].length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            System.arraycopy(stringArray[i], 0, stringArray2, i * stringArray.length, stringArray.length);
        }
        return stringArray2;
    }

    protected final DeviceDataHistory[] readAttHistoryFromNetwork() throws DevFailed {
        return this.device.attribute_history(this.nameSansDevice);
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }

    public void freeInternalData() {
        this.attribute = null;
    }

    @Override
    public Property getProperty(String string) {
        return this.propertyStorage.getProperty(string);
    }

    @Override
    public Map getPropertyMap() {
        return this.propertyStorage.getPropertyMap();
    }

    @Override
    public void setProperty(String string, Number number) {
        this.propertyStorage.setProperty(string, number);
    }

    @Override
    public void setProperty(String string, Number number, boolean bl) {
        this.propertyStorage.setProperty((IEntity)this, string, number, bl);
    }

    public PropertyStorage getPropertyStorage() {
        return this.propertyStorage;
    }

    public void setPropertyStorage(PropertyStorage propertyStorage) {
        this.propertyStorage = propertyStorage;
    }

    @Override
    public boolean areAttPropertiesLoaded() {
        return this.attPropertiesLoaded;
    }

    @Override
    public void loadAttProperties() {
        this.attPropertiesLoaded = true;
    }
}

