/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.tangoatk.core.Device;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JOptionPane;

public class DeviceProperty {
    protected String name;
    protected String[] value;
    protected String[] oldValue;
    protected boolean editable;
    protected Device parent;
    protected boolean specified;
    protected PropertyChangeSupport propChanges;

    public DeviceProperty() {
        this.name = "";
        this.value = new String[0];
        this.oldValue = new String[0];
        this.editable = true;
        this.parent = null;
        this.propChanges = new PropertyChangeSupport(this);
        this.specified = true;
    }

    public DeviceProperty(Device device, String string, String[] stringArray) {
        this.propChanges = new PropertyChangeSupport(this);
        this.parent = device;
        this.setName(string);
        this.setValue(stringArray);
        this.editable = true;
        this.specified = true;
    }

    public DeviceProperty(Device device, String string, String[] stringArray, boolean bl) {
        this.propChanges = new PropertyChangeSupport(this);
        this.parent = device;
        this.setName(string);
        this.setValue(stringArray);
        this.editable = bl;
        this.specified = true;
    }

    public void addPresentationListener(PropertyChangeListener propertyChangeListener) {
        this.propChanges.addPropertyChangeListener("presentation", propertyChangeListener);
    }

    public void removePresentationListener(PropertyChangeListener propertyChangeListener) {
        this.propChanges.removePropertyChangeListener("presentation", propertyChangeListener);
    }

    public void refresh() {
        if (this.parent != null) {
            try {
                DbDatum dbDatum = this.parent.get_property(this.name);
                if (dbDatum == null) {
                    throw new DevFailed();
                }
                this.oldValue = this.value;
                this.value = dbDatum.extractStringArray();
                this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
            }
            catch (DevFailed devFailed) {
                JOptionPane.showMessageDialog(null, "Failed to update property " + this.name, "Error", 0);
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSpecified(boolean bl) {
        this.specified = bl;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(String[] stringArray) {
        this.setSpecified(true);
        this.oldValue = this.value;
        this.value = stringArray;
    }

    public void setValue(String string) {
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        while (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.setValue(string2.split("\n"));
    }

    public String getName() {
        return this.name;
    }

    public String[] getValue() {
        return this.value;
    }

    public String getStringValue() {
        String string = "";
        for (int i = 0; i < this.value.length; ++i) {
            string = string + this.value[i] + "\n";
        }
        if (!"".equals(string)) {
            string = string.substring(0, string.lastIndexOf("\n"));
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public void store() {
        this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
        this.parent.storeProperty(this.name);
    }

    public String getVersion() {
        return "$Id: DeviceProperty.java 12968 2009-01-26 17:54:56Z poncet $";
    }
}

