/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceItem;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class AttributeList
extends AEntityList {
    protected Vector<DeviceItem> deviceList = new Vector();
    protected boolean forceRefresh = true;
    protected DeviceAttribute[] att = null;
    protected DeviceItem devItem = null;
    protected Device dev = null;
    protected long currentTime;

    public AttributeList() {
        this.factory = AttributeFactory.getInstance();
    }

    public void addElement(Object object) {
        if (!(object instanceof AAttribute)) {
            System.out.println("Warning, AttributeList supports only IAttribute.");
            return;
        }
        AAttribute aAttribute = (AAttribute)object;
        super.addElement(aAttribute);
        if (!aAttribute.hasEvents()) {
            this.addEntity(aAttribute);
        }
    }

    private synchronized void addEntity(AAttribute aAttribute) {
        int n = 0;
        boolean bl = false;
        Device device = aAttribute.getDevice();
        while (n < this.deviceList.size() && !bl) {
            bl = this.deviceList.get(n).getDevice() == device;
            if (bl) continue;
            ++n;
        }
        if (bl) {
            this.deviceList.get(n).add(aAttribute);
        } else {
            DeviceItem deviceItem = new DeviceItem(device);
            deviceItem.add(aAttribute);
            this.deviceList.add(deviceItem);
        }
    }

    private synchronized void removeEntity(AAttribute aAttribute) {
        int n = 0;
        boolean bl = false;
        Device device = aAttribute.getDevice();
        while (n < this.deviceList.size() && !bl) {
            bl = this.deviceList.get(n).getDevice() == device;
            if (bl) continue;
            ++n;
        }
        if (bl) {
            this.deviceList.get(n).remove(aAttribute);
            if (this.deviceList.get(n).getEntityNumber() == 0) {
                this.deviceList.remove(n);
            }
        }
    }

    void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public Object remove(int n) {
        Object e = super.remove(n);
        if (e != null && e instanceof AAttribute) {
            this.removeEntity((AAttribute)e);
        }
        return e;
    }

    public boolean isForceRefresh() {
        return this.forceRefresh;
    }

    public void setForceRefresh(boolean bl) {
        this.forceRefresh = bl;
    }

    @Override
    public void removeAllElements() {
        for (int i = 0; i < this.size(); ++i) {
            this.remove(i);
        }
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.isForceRefresh()) {
            super.refresh();
        } else {
            for (int i = 0; i < this.deviceList.size(); ++i) {
                AttributeList attributeList = this;
                synchronized (attributeList) {
                    this.devItem = this.deviceList.get(i);
                    this.dev = this.devItem.getDevice();
                    this.currentTime = System.currentTimeMillis();
                    try {
                        this.att = this.dev.read_attribute(this.devItem.getNames());
                        this.trace(4, "Device.read_attribute(" + this.dev.getName() + ") " + this.devItem.getEntityNumber() + " attributes read : OK", this.currentTime);
                        for (int j = 0; j < this.devItem.getEntityNumber(); ++j) {
                            this.devItem.getEntity(j).dispatch(this.att[j]);
                        }
                        this.att = null;
                    }
                    catch (DevFailed devFailed) {
                        this.att = null;
                        this.trace(4, "Device.read_attribute(" + this.dev.getName() + ") " + this.devItem.getEntityNumber() + " attributes read : Failed", this.currentTime);
                        for (int j = 0; j < this.devItem.getEntityNumber(); ++j) {
                            this.devItem.getEntity(j).dispatchError(devFailed);
                        }
                    }
                    this.devItem = null;
                    this.dev = null;
                    continue;
                }
            }
            this.fireRefresherStepEvent();
        }
    }

    @Override
    public void startRefresher() {
        for (int i = 0; i < this.size(); ++i) {
            IAttribute iAttribute = (IAttribute)this.get(i);
            int n = iAttribute.getDevice().getIdlVersion();
            if (n >= 3) continue;
            System.out.println("Warning, " + iAttribute.getName() + " has an IDL<=2 and does not support multiple DevFailed, switching to classic refresh.");
            this.forceRefresh = true;
        }
        super.startRefresher();
    }

    @Override
    public String getVersion() {
        return "$Id: AttributeList.java 28022 2015-06-10 12:58:44Z jlpons $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading AttributeList ");
        objectInputStream.defaultReadObject();
        System.out.println("Starting refresher on list");
        this.startRefresher();
    }
}

