/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.Main;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

public class BooleanViewer
extends JCheckBox {
    private static final ImageIcon trueIcon = new ImageIcon(Main.class.getResource("ui/true.gif"));
    private static final ImageIcon falseIcon = new ImageIcon(Main.class.getResource("ui/false.gif"));
    private static final ImageIcon offIcon = new ImageIcon(Main.class.getResource("ui/double_off.gif"));

    public BooleanViewer(Boolean value) {
        super(value == null ? "No Data" : value.toString());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setIcon(falseIcon);
        this.setPressedIcon(offIcon);
        this.setSelectedIcon(trueIcon);
        this.setSelected(value);
        this.repaint();
    }

    public void setSelected(Boolean value) {
        if (value == null) {
            this.setSelected(false);
            this.setIcon(offIcon);
            this.repaint();
        } else {
            this.setIcon(falseIcon);
            this.setSelected((boolean)value);
            this.repaint();
        }
    }

    @Override
    public void setText(String text) {
        if ("true".equalsIgnoreCase(text.trim())) {
            super.setText("true");
            this.setSelected(new Boolean(true));
        } else if ("false".equalsIgnoreCase(text.trim())) {
            super.setText("false");
            this.setSelected(new Boolean(false));
        } else {
            super.setText("No Data");
            this.setSelected(null);
        }
    }
}

