/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.EntityTableModel;
import explorer.Main;
import explorer.ui.RunUI;
import explorer.ui.UIBit;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.widget.device.Tree;
import fr.esrf.tangoatk.widget.device.tree.MemberNode;
import fr.esrf.tangoatk.widget.dnd.AttributeNode;
import fr.esrf.tangoatk.widget.dnd.CommandNode;
import fr.esrf.tangoatk.widget.dnd.EntityNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class AdminMain
extends Main {
    protected JTree deviceTree;
    protected JSplitPane mainSplit;
    protected JPopupMenu devicePopup;

    public AdminMain(String[] args) {
        this.isAdmin = true;
        this.initComponents();
        UIBit refreshTreeBit = new UIBit("Refresh Tree...", "Refresh Tree...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        }, new ImageIcon(Main.class.getResource("ui/refreshTree.gif")));
        JMenuItem refreshTreeItem2 = new JMenuItem("Refresh Tree...");
        refreshTreeItem2.setIcon(new ImageIcon(Main.class.getResource("ui/refreshTree.gif")));
        refreshTreeItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        });
        this.menuBar.add2EditMenu(refreshTreeBit.getItem());
        this.menuBar.add2RefreshMenu(new JSeparator());
        this.menuBar.add2RefreshMenu(refreshTreeItem2);
        this.menuBar.repaint();
        this.refreshBar.add(refreshTreeBit.getButton());
        this.refreshBar.repaint();
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    public AdminMain() {
        this.runningFromShell = false;
        this.isAdmin = true;
        this.initComponents();
        UIBit refreshTreeBit = new UIBit("Refresh Tree...", "Refresh Tree...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        }, new ImageIcon(Main.class.getResource("ui/refreshTree.gif")));
        JMenuItem refreshTreeItem2 = new JMenuItem("Refresh Tree...");
        refreshTreeItem2.setIcon(new ImageIcon(Main.class.getResource("ui/refreshTree.gif")));
        refreshTreeItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        });
        this.menuBar.add2EditMenu(refreshTreeBit.getItem());
        this.menuBar.add2RefreshMenu(new JSeparator());
        this.menuBar.add2RefreshMenu(refreshTreeItem2);
        this.menuBar.repaint();
        this.refreshBar.add(refreshTreeBit.getButton());
        this.refreshBar.repaint();
        this.viewSplit.setLastDividerLocation(this.tableSplitHeight / 3);
        this.mainFrame.pack();
        this.viewSplit.setDividerLocation(1.0);
        this.mainFrame.setVisible(true);
    }

    @Override
    protected void specificSetup(GridBagConstraints constraints) {
        TitledBorder tb;
        this.deviceTree = this.initTree();
        if (this.splash.isVisible()) {
            this.splash.setMessage("Adding tree...");
        }
        JScrollPane treePane = new JScrollPane(this.deviceTree);
        Font font = new Font("Arial", 0, 10);
        Color color = Color.BLACK;
        String title = "Device Browsing Panel";
        TitledBorder border = tb = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, color), title, 2, 2, font, color);
        treePane.setBorder(border);
        treePane.setBackground(Color.WHITE);
        treePane.setPreferredSize(new Dimension(300, 600));
        this.mainSplit = new JSplitPane(1, treePane, this.viewSplit);
        this.mainSplit.setDividerSize(9);
        this.mainSplit.setOneTouchExpandable(true);
        this.mainSplit.setDividerLocation(this.mainSplitDividerLocation);
        this.mainFrame.getContentPane().add((Component)this.mainSplit, constraints);
        if (this.splash.isVisible()) {
            this.splash.setMessage("Adding tree..." + done);
        }
    }

    @Override
    public void newFile() {
        this.attributeTableModel.clear();
        this.commandTableModel.clear();
    }

    @Override
    public void open(File file) {
        super.open(file);
        this.mainSplit.setDividerLocation(this.mainSplitDividerLocation);
    }

    @Override
    public void save(File file) {
        String name = file.getAbsolutePath();
        this.mainFrame.setTitle(VERSION + " - " + name);
        this.progress.setIndeterminate(true);
        this.status.setText("Saving to " + file.getAbsolutePath());
        try {
            this.storePreferences();
            this.fileManager.setAttributes((AttributePolledList)this.attributeTableModel.getList());
            this.fileManager.setCommands((CommandList)this.commandTableModel.getList());
            this.fileManager.save(file);
            this.status.setText("Saving ok");
        }
        catch (Exception e) {
            AdminMain.status(this.mainFrame, "Could not save " + file, e);
        }
        this.progress.setValue(this.progress.getMinimum());
        this.progress.setIndeterminate(false);
    }

    protected JTree initTree() {
        String message = "Initializing device tree...";
        if (this.splash.isVisible()) {
            this.splash.setMessage(message);
        }
        Tree tree = (Tree)this.treeInitialization();
        message = message + "done";
        if (this.splash.isVisible()) {
            this.splash.setMessage(message);
        }
        return tree;
    }

    protected JTree treeInitialization() {
        Tree tree = new Tree();
        MouseListener[] liste = tree.getMouseListeners();
        if (liste.length > 0) {
            tree.removeMouseListener(liste[liste.length - 1]);
        }
        tree.addErrorListener((IErrorListener)this.errorHistory);
        tree.importFromDb();
        this.treePopup = new JPopupMenu();
        this.devicePopup = new JPopupMenu();
        tree.setShowEntities(true);
        this.entityPopup = new JPopupMenu();
        JMenuItem atkPanelItem = new JMenuItem("Run atkpanel");
        JMenuItem refreshItem = new JMenuItem("Refresh Tree...");
        JMenuItem addItem = new JMenuItem("Add to table");
        atkPanelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminMain.this.runAtk();
            }
        });
        addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminMain.this.add2Table();
            }
        });
        refreshItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        });
        this.treePopup.add(refreshItem);
        this.entityPopup.add(addItem);
        this.devicePopup.add(atkPanelItem);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AdminMain.this.treePressed(evt);
                AdminMain.this.treeClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AdminMain.this.treeClicked(evt);
            }
        });
        tree.setDragEnabled(true);
        return tree;
    }

    protected void runAtk() {
        Object node = this.deviceTree.getLastSelectedPathComponent();
        if (node == null && !(node instanceof DefaultMutableTreeNode)) {
            return;
        }
        if (node instanceof MemberNode) {
            try {
                Device d = DeviceFactory.getInstance().getDevice(((MemberNode)node).getName());
                RunUI.runAtkPanel((IDevice)d);
            }
            catch (ConnectionException e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Failed to connect to" + ((MemberNode)node).getName(), "Error", 0);
            }
            return;
        }
    }

    public void refreshTree() {
        this.status.setText("Refreshing Tree...");
        Container c = this.deviceTree.getParent();
        c.remove(this.deviceTree);
        ((Tree)this.deviceTree).removeListeners();
        this.deviceTree = null;
        this.deviceTree = this.treeInitialization();
        c.add(this.deviceTree);
        this.status.setText("Tree Refreshed");
    }

    protected void treePressed(MouseEvent evt) {
        TreePath path = this.deviceTree.getPathForLocation(evt.getX(), evt.getY());
        if (this.isNotEntityPath(path)) {
            this.deviceTree.clearSelection();
            this.deviceTree.setSelectionPath(this.deviceTree.getPathForLocation(evt.getX(), evt.getY()));
        }
    }

    protected boolean isNotEntityPath(TreePath path) {
        return path != null && path.getPathCount() < 6;
    }

    public void treeClicked(MouseEvent evt) {
        int selectedRow = this.deviceTree.getRowForLocation(evt.getX(), evt.getY());
        if (selectedRow != -1 && evt.isPopupTrigger()) {
            int i;
            int[] rows = this.deviceTree.getSelectionRows();
            if (rows == null) {
                rows = new int[]{};
            }
            if (evt.isControlDown()) {
                this.deviceTree.addSelectionInterval(selectedRow, selectedRow);
                rows = this.deviceTree.getSelectionRows();
            } else if (evt.isShiftDown()) {
                int min = rows[0];
                for (i = 0; i < rows.length; ++i) {
                    if (rows[i] >= min) continue;
                    min = rows[i];
                }
                this.deviceTree.addSelectionInterval(min, selectedRow);
                rows = this.deviceTree.getSelectionRows();
            } else {
                boolean isInSelection = false;
                for (i = 0; i < rows.length; ++i) {
                    if (rows[i] != selectedRow) continue;
                    isInSelection = true;
                    break;
                }
                if (!isInSelection) {
                    this.deviceTree.setSelectionInterval(selectedRow, selectedRow);
                }
            }
            Object n = this.deviceTree.getLastSelectedPathComponent();
            if (n == null && !(n instanceof DefaultMutableTreeNode)) {
                return;
            }
            Object node = ((DefaultMutableTreeNode)n).getUserObject();
            if (node instanceof EntityNode) {
                this.entityPopup.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
            if (n instanceof MemberNode) {
                this.devicePopup.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
            if (selectedRow == 0) {
                this.treePopup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    public void add2Table() {
        TreePath[] paths = this.deviceTree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            Object n = paths[i].getLastPathComponent();
            if (n == null && !(n instanceof DefaultMutableTreeNode)) continue;
            Object node = ((DefaultMutableTreeNode)n).getUserObject();
            if (node instanceof AttributeNode) {
                try {
                    this.attributeTableModel.load(((AttributeNode)node).getFQName());
                    AttributePolledList attrList = new AttributePolledList();
                    IAttribute attr = (IAttribute)attrList.add(((AttributeNode)node).getFQName());
                    if (this.globalTrend.getModel() != null && this.globalTrend.getModel().contains((Object)attr)) {
                        this.attributeTableModel.removeFromRefresher(attr);
                    }
                    attrList.removeAllElements();
                    attrList = null;
                }
                catch (ConnectionException e) {
                    Main.status(this.mainFrame, "Error loading attribute ", (Exception)((Object)e));
                }
                continue;
            }
            if (!(node instanceof CommandNode)) continue;
            try {
                this.commandTableModel.load(((CommandNode)node).getFQName());
                continue;
            }
            catch (ConnectionException e) {
                Main.status(this.mainFrame, "Error loading command ", (Exception)((Object)e));
            }
        }
    }

    public void storePreferences() {
        this.attributeTable.storePreferences();
        this.commandTable.storePreferences();
        this.preferences.putInt("MAIN_WINDOW_WIDTH", this.mainFrame.getWidth());
        this.preferences.putInt("MAIN_WINDOW_HEIGHT", this.mainFrame.getHeight());
        this.preferences.putInt("MAIN_WINDOW_X", this.mainFrame.getX());
        this.preferences.putInt("MAIN_WINDOW_Y", this.mainFrame.getY());
        this.preferences.putInt("TABLE_SPLIT_DIVIDER_LOCATION", this.tableSplit.getDividerLocation());
        this.preferences.putInt("MAIN_SPLIT_DIVIDER_LOCATION", this.mainSplit.getDividerLocation());
        this.preferences.putDouble("VIEW_SPLIT_DIVIDER_LOCATION", this.viewSplit.getDividerLocation());
        this.preferences.putInt("TABLE_SPLIT_WIDTH", this.tableSplit.getWidth());
        this.preferences.putInt("TABLE_SPLIT_HEIGHT", this.tableSplit.getHeight());
        this.fileManager.setPreferences(this.preferences);
        EntityTableModel model = (EntityTableModel)this.attributeTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            IEntity att = model.getEntityAt(i);
            if (!(att instanceof INumberSpectrum)) continue;
            String keyname = att.getName() + ".GraphSettings";
            this.preferences.putString(keyname, this.attributePanel.getSpectrumGraphSettings(att));
        }
    }

    @Override
    public void quit() {
        this.storePreferences();
        if (this.file != null && this.fileRecordable && JOptionPane.showConfirmDialog(this.mainFrame, "Save before exit ?", "Alert", 0) == 0) {
            this.save(this.file);
        }
        super.quit();
    }
}

