/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.PopupText;
import admin.astor.tools.WideSearchDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WideSearchTree
extends JTree
implements TangoConst {
    private DefaultMutableTreeNode root;
    private WideSearchTreePopupMenu menu;
    private JDialog parent;
    private static final Color background = new Color(240, 240, 240);
    private static final int DISPLAY_INFO = 0;
    private static final int HOST_PANEL = 1;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Display Info", "Host Panel"};

    public WideSearchTree(JDialog parent, String wildcard) throws DevFailed {
        this.parent = parent;
        this.setBackground(background);
        this.buildTree(wildcard);
        this.menu = new WideSearchTreePopupMenu(this);
        this.expandChildren(this.root);
        this.setSelectionPath(null);
    }

    private void buildTree(String wildcard) throws DevFailed {
        this.root = new DefaultMutableTreeNode("Objects found for  " + wildcard);
        this.createCollectionClassNodes(wildcard);
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WideSearchTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if (!(evt.getClickCount() == 2 && (mask & 0x10) != 0 || (mask & 4) == 0 || o instanceof TangoClass)) {
            this.menu.showMenu(evt, (LeafClass)o);
        }
    }

    private ArrayList<CollectionClass> initGlobalObject(String wildcard) throws DevFailed {
        String[] servers;
        ArrayList<CollectionClass> collec = new ArrayList<CollectionClass>();
        Database db = ApiUtil.get_db_obj();
        String[] classes = db.get_class_list(wildcard);
        if (classes.length > 0) {
            CollectionClass cc = new CollectionClass("Classes");
            for (String name : classes) {
                cc.add(new TangoClass(name));
            }
            collec.add(cc);
        }
        if ((servers = db.get_server_list(wildcard)).length > 0) {
            CollectionClass cc = new CollectionClass("Servers");
            for (String name : servers) {
                cc.add(new TangoServer(name));
            }
            collec.add(cc);
        }
        try {
            String[] devices = db.get_device_list(wildcard);
            if (devices.length > 0) {
                CollectionClass cc = new CollectionClass("Devices");
                for (String name : devices) {
                    cc.add(new TangoDevice(name));
                }
                collec.add(cc);
            }
        }
        catch (NoSuchMethodError e) {
            ((WideSearchDialog)this.parent).setWarning();
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                ((WideSearchDialog)this.parent).setWarning();
            }
            throw e;
        }
        String[] aliases = db.get_device_alias_list(wildcard);
        if (aliases.length > 0) {
            CollectionClass cc = new CollectionClass("Aliases");
            for (String name : aliases) {
                cc.add(new TangoAlias(name));
            }
            collec.add(cc);
        }
        return collec;
    }

    private void createCollectionClassNodes(String wildcard) throws DevFailed {
        ArrayList<CollectionClass> collec = this.initGlobalObject(wildcard);
        if (collec.size() == 0) {
            this.root.setUserObject("No Object Found for  " + wildcard);
        } else {
            for (CollectionClass aCollec : collec) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(aCollec);
                this.root.add(node);
                for (Object obj : aCollec) {
                    node.add(new DefaultMutableTreeNode(obj));
                }
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (level_done) continue;
                this.expandNode(child);
                level_done = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> v = new ArrayList<DefaultMutableTreeNode>();
        v.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            v.add(0, node);
        }
        Object[] tn = new DefaultMutableTreeNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            tn[i] = (TreeNode)v.get(i);
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private DeviceInfo getDevInfo(String devname) throws DevFailed {
        DbDevice dev = new DbDevice(devname);
        return dev.get_info();
    }

    private String getAliasInfo(TangoAlias alias) throws DevFailed {
        StringBuilder sb = new StringBuilder("------------ ");
        sb.append(alias.name).append(" Info ------------\n\n");
        String deviceName = ApiUtil.get_db_obj().get_device_from_alias(alias.name);
        sb.append("Alias for device :   ").append(deviceName).append("\n\n");
        sb.append(this.getDeviceInfo(deviceName));
        return sb.toString();
    }

    private String getDeviceInfo(TangoDevice device) throws DevFailed {
        return this.getDeviceInfo(device.name);
    }

    private String getDeviceInfo(String devname) throws DevFailed {
        StringBuilder sb = new StringBuilder("------------ ");
        sb.append(devname).append("  Info ------------\n\n");
        DeviceInfo info = this.getDevInfo(devname);
        sb.append(info);
        return sb.toString();
    }

    private String getServerInfo(TangoServer server) throws DevFailed {
        StringBuilder sb = new StringBuilder("------------ ");
        sb.append(server.name).append("  Info ------------\n\n");
        DeviceInfo info = this.getDevInfo("dserver/" + server.name);
        sb.append(info);
        DbServer db_serv = new DbServer(server.name);
        String[] class_list = db_serv.get_class_list();
        sb.append("\n\n----------- Device(s) Served -----------\n\n");
        for (String cl : class_list) {
            String[] devnames;
            sb.append("\n").append(cl).append(":\n");
            for (String devname : devnames = db_serv.get_device_name(cl)) {
                sb.append("   ").append(devname).append("\n");
            }
        }
        return sb.toString();
    }

    private void displayInfo() {
        try {
            Object obj = this.getSelectedObject();
            if (obj instanceof TangoServer) {
                new PopupText(this.parent, true).show(this.getServerInfo((TangoServer)obj));
            } else if (obj instanceof TangoDevice) {
                new PopupText(this.parent, true).show(this.getDeviceInfo((TangoDevice)obj));
            } else if (obj instanceof TangoAlias) {
                new PopupText(this.parent, true).show(this.getAliasInfo((TangoAlias)obj));
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"", (DevFailed)e);
        }
    }

    private void displayHostPanel() {
        try {
            Object obj = this.getSelectedObject();
            String deviceName = obj instanceof TangoServer ? "dserver/" + ((TangoServer)obj).name : (obj instanceof TangoAlias ? ApiUtil.get_db_obj().get_device_from_alias(((TangoAlias)obj).name) : ((TangoDevice)obj).name);
            DeviceInfo info = this.getDevInfo(deviceName);
            String hostname = info.hostname;
            ((WideSearchDialog)this.parent).displayHostPanel(hostname);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"", (DevFailed)e);
        }
    }

    private class WideSearchTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private WideSearchTreePopupMenu(JTree tree) {
            this.tree = tree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        WideSearchTreePopupMenu.this.hostActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt, LeafClass leaf) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(leaf.toString());
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void hostActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                cmdidx = i;
            }
            switch (cmdidx) {
                case 0: {
                    WideSearchTree.this.displayInfo();
                    break;
                }
                case 1: {
                    WideSearchTree.this.displayHostPanel();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts = new Font[3];
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int LEAF = 2;

        public TangoRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof CollectionClass) {
                    this.setFont(this.fonts[1]);
                } else {
                    this.setFont(this.fonts[2]);
                }
            }
            return this;
        }
    }

    private class CollectionClass
    extends ArrayList<LeafClass> {
        String name;

        private CollectionClass(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class TangoAlias
    extends LeafClass {
        private TangoAlias(String name) {
            super(name);
        }
    }

    private class TangoDevice
    extends LeafClass {
        private TangoDevice(String name) {
            super(name);
        }
    }

    private class TangoServer
    extends LeafClass {
        private TangoServer(String name) {
            super(name);
        }
    }

    private class TangoClass
    extends LeafClass {
        private TangoClass(String name) {
            super(name);
        }
    }

    private class LeafClass
    extends ArrayList {
        String name;

        private LeafClass(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

