/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.TangoServer;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PoolThreadsTree
extends JTree
implements TangoConst {
    static ImageIcon tango_icon;
    static ImageIcon class_icon;
    static ImageIcon cmd_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private JDialog parent;
    private PoolThreadsInfo threadsInfo;
    private TangoRenderer renderer;
    private TangoServer server;
    private static final Color background;
    private static final String[] propertyNames;
    private static final int NB_THREADS = 0;
    private static final int THREADS_CONFIG = 1;
    private static final int LINE_MAX_LENGTH = 256;
    private DefaultMutableTreeNode dragged_node = null;

    public PoolThreadsTree(JDialog parent, TangoServer server) throws DevFailed {
        this.parent = parent;
        this.server = server;
        this.setBackground(background);
        this.threadsInfo = new PoolThreadsInfo(server);
        this.buildTree();
        this.expandChildren(this.root);
        this.setSelectionPath(null);
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler("Text"));
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(this.server);
        this.createThreadsNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.renderer = new TangoRenderer();
        this.setCellRenderer(this.renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PoolThreadsTree.this.treeMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PoolThreadsTree.this.treeMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                PoolThreadsTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0 || (mask & 4) != 0) {
            // empty if block
        }
    }

    private void createThreadsNodes() {
        for (int i = 0; i < this.threadsInfo.size(); ++i) {
            PollThread thread = this.threadsInfo.threadAt(i);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(thread);
            this.root.add(node);
            for (Object obj : thread) {
                node.add(new DefaultMutableTreeNode(obj));
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    boolean selectedObjectIsThread() {
        return this.getSelectedObject() instanceof PollThread;
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (level_done) continue;
                this.expandNode(child);
                level_done = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> v = new ArrayList<DefaultMutableTreeNode>();
        v.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            v.add(0, node);
        }
        Object[] tn = new DefaultMutableTreeNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            tn[i] = (TreeNode)v.get(i);
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private DefaultMutableTreeNode getFutureSelectedNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent_node;
        DefaultMutableTreeNode ret_node = parent_node = (DefaultMutableTreeNode)node.getParent();
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            DefaultMutableTreeNode child_node = (DefaultMutableTreeNode)parent_node.getChildAt(i);
            if (child_node != node) continue;
            if (i == parent_node.getChildCount() - 1) {
                if (i <= 0) continue;
                ret_node = (DefaultMutableTreeNode)parent_node.getChildAt(i - 1);
                continue;
            }
            ret_node = (DefaultMutableTreeNode)parent_node.getChildAt(i + 1);
        }
        return ret_node;
    }

    void removeThread() {
        Object obj;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null && (obj = node.getUserObject()) instanceof PollThread) {
            if (node.getChildCount() == 0) {
                DefaultMutableTreeNode next_node = this.getFutureSelectedNode(node);
                this.treeModel.removeNodeFromParent(node);
                PollThread pt = (PollThread)obj;
                this.threadsInfo.remove(pt);
                Object[] tree_node = next_node.getPath();
                TreePath path = new TreePath(tree_node);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
            } else {
                Utils.popupError(this.parent, "Cannot remove a not empty thread !");
            }
        }
    }

    DefaultMutableTreeNode addThreadNode() {
        PollThread new_thread = new PollThread(this.getNextThreadNum());
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new_thread);
        this.treeModel.insertNodeInto(node, this.root, this.root.getChildCount());
        return node;
    }

    private int getNextThreadNum() {
        int num = 0;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode th_node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            num = ((PollThread)th_node.getUserObject()).num;
        }
        return ++num;
    }

    private ArrayList<String> manageMaxLength(ArrayList<String> lines) {
        ArrayList<String> list = new ArrayList<String>();
        for (String line : lines) {
            while (line.length() > 256) {
                list.add(line.substring(0, 255) + '\\');
                line = line.substring(255);
            }
            list.add(line);
        }
        return list;
    }

    void putPoolThreadInfo() {
        int nbThreads = this.root.getChildCount();
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode threadNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            int deviceNumber = threadNode.getChildCount();
            if (deviceNumber <= 0) continue;
            String s = "";
            for (int j = 0; j < deviceNumber; ++j) {
                s = s + threadNode.getChildAt(j).toString();
                if (j >= deviceNumber - 1) continue;
                s = s + ",";
            }
            lines.add(s);
        }
        lines = this.manageMaxLength(lines);
        String[] config = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            config[i] = lines.get(i);
        }
        try {
            DbDatum[] argin = new DbDatum[]{new DbDatum(propertyNames[0], nbThreads), new DbDatum(propertyNames[1], config)};
            this.server.put_property(argin);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    private TreePath getUpperPath(int x, int y) {
        TreePath selectedPath = null;
        while (selectedPath == null && y > 10) {
            selectedPath = this.getPathForLocation(x, y);
            y -= 10;
        }
        return selectedPath;
    }

    private void treeMouseReleased(MouseEvent evt) {
        int mask = evt.getModifiers();
        if ((mask & 0x10) != 0) {
            if (this.dragged_node == null) {
                return;
            }
            TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null && (selectedPath = this.getUpperPath(evt.getX(), evt.getY())) == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
            Object o = node.getUserObject();
            int pos = 0;
            if (o instanceof String) {
                DefaultMutableTreeNode p_node = (DefaultMutableTreeNode)node.getParent();
                pos = p_node.getIndex(node);
                node = p_node;
            }
            this.moveLeaf(node, this.dragged_node, pos);
            this.dragged_node = null;
            Cursor cursor = new Cursor(0);
            this.parent.setCursor(cursor);
        }
    }

    private void treeMousePressed(MouseEvent evt) {
        int mask = evt.getModifiers();
        if ((mask & 0x10) != 0) {
            TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
            Object o = node.getUserObject();
            if (o instanceof String) {
                TransferHandler transfer = this.getTransferHandler();
                transfer.exportAsDrag(this, evt, 1);
                this.dragged_node = node;
                this.parent.setCursor(this.renderer.getNodeCursor(node));
            }
        }
    }

    private void moveLeaf(DefaultMutableTreeNode collec_node, DefaultMutableTreeNode leaf_node, int pos) {
        Object obj = collec_node.getUserObject();
        if (obj instanceof PollThread) {
            this.treeModel.removeNodeFromParent(leaf_node);
            if (pos < 0) {
                this.treeModel.insertNodeInto(leaf_node, collec_node, collec_node.getChildCount());
            } else {
                this.treeModel.insertNodeInto(leaf_node, collec_node, pos);
            }
            this.expandNode(leaf_node);
        }
    }

    PoolThreadsTree(String serverName) throws DevFailed {
        this.server = new TangoServer(serverName);
        this.threadsInfo = new PoolThreadsInfo(new TangoServer(serverName));
    }

    public int getNbThreads() throws DevFailed {
        return this.threadsInfo.size();
    }

    static {
        background = Color.WHITE;
        propertyNames = new String[]{"polling_threads_pool_size", "polling_threads_pool_conf"};
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int THREAD = 1;
        private final int DEVICE = 2;
        private Cursor dd_cursor;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("TangoClass.gif", 0.33);
            class_icon = utils.getIcon("class.gif");
            cmd_icon = utils.getIcon("attleaf.gif");
            this.dd_cursor = utils.getCursor("drg-drp.gif");
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        Cursor getNodeCursor(DefaultMutableTreeNode node) {
            Object o = node.getUserObject();
            if (o instanceof String) {
                return this.dd_cursor;
            }
            return new Cursor(0);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof PollThread) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(class_icon);
                } else {
                    this.setFont(this.fonts[2]);
                    this.setIcon(cmd_icon);
                }
            }
            return this;
        }
    }

    private class PoolThreadsInfo
    extends ArrayList<PollThread> {
        private PoolThreadsInfo(TangoServer server) throws DevFailed {
            DbDatum[] data = server.get_property(propertyNames);
            String[] config = new String[]{};
            int threadsNumber = 1;
            if (data[0].is_empty() && data[1].is_empty()) {
                String[] s = server.queryDeviceFromDb();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < s.length; ++i) {
                    sb.append(s[i]);
                    if (i >= s.length - 1) continue;
                    sb.append(',');
                }
                config = new String[]{sb.toString()};
            }
            if (!data[0].is_empty()) {
                threadsNumber = data[0].extractLong();
            }
            if (!data[1].is_empty()) {
                config = data[1].extractStringArray();
            }
            this.buildConfig(config, threadsNumber);
        }

        private ArrayList<String> rebuildLines(String[] config) {
            ArrayList<String> lines = new ArrayList<String>();
            String line = config[0];
            for (int i = 1; i < config.length; ++i) {
                if (line.endsWith("\\")) {
                    line = line.substring(0, line.indexOf(92)) + config[i];
                    continue;
                }
                lines.add(line);
                line = config[i];
            }
            lines.add(line);
            return lines;
        }

        private void buildConfig(String[] config, int threadsNumber) {
            if (config.length == 0) {
                return;
            }
            ArrayList<String> lines = this.rebuildLines(config);
            int threadCounter = 0;
            for (String line : lines) {
                StringTokenizer stk = new StringTokenizer(line, ",");
                PollThread thread = new PollThread(threadCounter++);
                while (stk.hasMoreTokens()) {
                    thread.add(stk.nextToken());
                }
                this.add(thread);
            }
            for (int i = threadCounter; i < threadsNumber; ++i) {
                this.add(new PollThread(i));
            }
        }

        private PollThread threadAt(int i) {
            return (PollThread)this.get(i);
        }
    }

    private class PollThread
    extends ArrayList<String> {
        String name;
        int num;

        private PollThread(int num) {
            this.num = num;
            this.name = "Thread " + (num + 1);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

