/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListDialog
extends JDialog {
    private String selection = null;
    private JList<String> jList;
    private JScrollPane scrollPane;
    private JLabel titleLabel;

    public ListDialog(JFrame parent, String title, String[] items) {
        super((Frame)parent, true);
        this.initComponents();
        this.jList.setListData((String[])items);
        int length = 0;
        for (String item : items) {
            if (item.length() <= length) continue;
            length = item.length();
        }
        length *= 8;
        int height = items.length * 10;
        if (height > 600) {
            height = 600;
        }
        this.scrollPane.setPreferredSize(new Dimension(length, height));
        if (title != null) {
            this.titleLabel.setText(title);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.scrollPane = new JScrollPane();
        this.jList = new JList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ListDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("List Selection");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ListDialog.this.jListMouseClicked(evt);
            }
        });
        this.scrollPane.setViewportView(this.jList);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String object = this.jList.getSelectedValue();
        if (object != null) {
            this.selection = object.toString();
        }
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void jListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.jList.getSelectedValue() != null) {
            this.selection = this.jList.getSelectedValue().toString();
            this.doClose();
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String showDialog() {
        this.setVisible(true);
        return this.selection;
    }

    public static void main(String[] args) {
        try {
            String[] servers = ApiUtil.get_db_obj().get_server_name_list();
            ListDialog dialog = new ListDialog(null, "Servers", servers);
            String serverName = dialog.showDialog();
            if (serverName != null) {
                System.out.println(serverName);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
        }
    }
}

