/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LastBranchesListDialog
extends JDialog {
    private JFrame parent;
    private ArrayList<String> branches;
    private int returnValue = 0;
    private JList<String> branchList;
    private JButton downBtn;
    private JButton removeBtn;
    private JButton upBtn;

    public LastBranchesListDialog(JFrame parent, ArrayList<String> branches, String[] lastBranches) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.branches = branches;
        this.initComponents();
        this.branchList.removeAll();
        this.branchList.setListData((String[])lastBranches);
        this.removeBtn.setEnabled(false);
        this.upBtn.setEnabled(false);
        this.downBtn.setEnabled(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.branchList = new JList();
        JPanel eastPanel = new JPanel();
        this.removeBtn = new JButton();
        JButton addBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LastBranchesListDialog.this.closeDialog(evt);
            }
        });
        titleLabel.setFont(new Font("Dialog", 1, 14));
        titleLabel.setText("Branch(es) to be displayed at bottom");
        titleLabel.setToolTipText("");
        topPanel.add(titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LastBranchesListDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LastBranchesListDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.branchList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LastBranchesListDialog.this.branchListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(this.branchList);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        eastPanel.setLayout(new GridBagLayout());
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LastBranchesListDialog.this.removeBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        eastPanel.add((Component)this.removeBtn, gridBagConstraints);
        addBtn.setText("Add");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LastBranchesListDialog.this.addBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        eastPanel.add((Component)addBtn, gridBagConstraints);
        this.upBtn.setText("Up");
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LastBranchesListDialog.this.upBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        eastPanel.add((Component)this.upBtn, gridBagConstraints);
        this.downBtn.setText("Down");
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LastBranchesListDialog.this.downBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        eastPanel.add((Component)this.downBtn, gridBagConstraints);
        this.getContentPane().add((Component)eastPanel, "East");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        String selection = this.branchList.getSelectedValue();
        ListModel<String> model = this.branchList.getModel();
        Vector<String> stringVector = new Vector<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            String s = model.getElementAt(i);
            if (s.equals(selection)) continue;
            stringVector.add(s);
        }
        this.branchList.setListData(stringVector);
        this.removeBtn.setEnabled(false);
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        Vector<String> lastBranches = new Vector<String>();
        ListModel<String> model = this.branchList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String s = model.getElementAt(i);
            lastBranches.add(s);
        }
        ArrayList<String> availableBranches = new ArrayList<String>();
        for (String branch : this.branches) {
            if (branch.equals("Tango Database")) continue;
            boolean found = false;
            for (String lastBranch : lastBranches) {
                if (!branch.equals(lastBranch)) continue;
                found = true;
            }
            if (found) continue;
            availableBranches.add(branch);
        }
        if (availableBranches.size() == 0) {
            Utils.popupError(this.parent, "No branch available !");
            return;
        }
        Object[] array = new String[availableBranches.size()];
        for (int i = 0; i < availableBranches.size(); ++i) {
            array[i] = (String)availableBranches.get(i);
        }
        String branchName = (String)JOptionPane.showInputDialog(this, "Add branch", "", 1, null, array, array[0]);
        if (branchName != null) {
            lastBranches.add(branchName);
            this.branchList.setListData(lastBranches);
        }
    }

    private void branchListValueChanged(ListSelectionEvent evt) {
        this.removeBtn.setEnabled(true);
        this.upBtn.setEnabled(true);
        this.downBtn.setEnabled(true);
    }

    private void upBtnActionPerformed(ActionEvent evt) {
        String selection = this.branchList.getSelectedValue();
        Vector<String> lastBranches = new Vector<String>();
        ListModel<String> model = this.branchList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String s = model.getElementAt(i);
            if (s.equals(selection)) {
                if (i == 0) {
                    return;
                }
                lastBranches.add(i - 1, s);
                continue;
            }
            lastBranches.add(s);
        }
        this.branchList.setListData(lastBranches);
        this.branchList.setSelectedValue(selection, true);
    }

    private void downBtnActionPerformed(ActionEvent evt) {
        int i;
        String selection = this.branchList.getSelectedValue();
        Vector<String> lastBranches = new Vector<String>();
        ListModel<String> model = this.branchList.getModel();
        for (i = 0; i < model.getSize(); ++i) {
            String s = model.getElementAt(i);
            lastBranches.add(s);
        }
        for (i = 0; i < lastBranches.size(); ++i) {
            if (!((String)lastBranches.get(i)).equals(selection)) continue;
            if (i >= lastBranches.size() - 1) {
                return;
            }
            lastBranches.remove(i);
            lastBranches.add(i + 1, selection);
            ++i;
        }
        this.branchList.setListData(lastBranches);
        this.branchList.setSelectedValue(selection, true);
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public String[] getLastBranches() {
        ListModel<String> model = this.branchList.getModel();
        String[] array = new String[model.getSize()];
        for (int i = 0; i < model.getSize(); ++i) {
            array[i] = model.getElementAt(i);
        }
        return array;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    public static void main(String[] args) {
        try {
            String[] last = new String[]{"Miscellaneous", "Insertion Devices"};
            ArrayList<String> branches = new ArrayList<String>();
            branches.add("AAAA");
            branches.add("In Test");
            branches.add("Miscellaneous");
            branches.add("Insertion Devices");
            branches.add("Development");
            new LastBranchesListDialog(null, branches, last).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }
}

