/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.DbServerArchitecture;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DevPropertyDialog
extends JDialog {
    private JDialog parent;
    private DbDevice dev;
    private DbServerArchitecture.TangoAtt att;
    private JTextField[] txt;
    private JButton[] btn;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public DevPropertyDialog(JDialog parent, DbDevice dev, DbServerArchitecture.TangoAtt att) {
        super((Dialog)parent, true);
        this.parent = parent;
        this.dev = dev;
        this.att = att;
        this.initComponents();
        this.initOwnComponents();
        this.titleLabel.setText(dev.name() + "/" + att.name + "  Properties");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.txt = new JTextField[this.att.prop.length];
        this.btn = new JButton[this.att.prop.length];
        for (int i = 0; i < this.att.prop.length; ++i) {
            int x = 0;
            gbc.gridx = x++;
            gbc.gridy = i;
            gbc.fill = 2;
            panel.add((Component)new JLabel(this.att.prop[i].name + " :   "), gbc);
            gbc.gridx = x++;
            gbc.gridy = i;
            this.txt[i] = new JTextField();
            this.txt[i].setColumns(25);
            this.txt[i].setText(this.att.prop[i].strval);
            panel.add((Component)this.txt[i], gbc);
            gbc.gridx = x++;
            gbc.gridy = i;
            panel.add((Component)new JLabel("   "), gbc);
            gbc.gridx = x;
            gbc.gridy = i;
            this.btn[i] = new JButton("Histo");
            this.btn[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DevPropertyDialog.this.histoActionPerformed(evt);
                }
            });
            panel.add((Component)this.btn[i], gbc);
        }
        this.getContentPane().add((Component)panel, "Center");
        this.okBtn.setText("Apply");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DevPropertyDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevPropertyDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevPropertyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < this.txt.length; ++i) {
            String strval = this.txt[i].getText();
            if (strval.equals(this.att.prop[i].strval)) continue;
            try {
                DbAttribute att1 = new DbAttribute(this.att.name);
                DbDatum datum = new DbDatum(this.att.prop[i].name);
                datum.insert(strval);
                att1.add((Object)datum);
                this.dev.put_attribute_property(att1);
                v.add(this.att.prop[i].name + ":    " + this.att.prop[i].strval + " --> " + strval);
                this.att.prop[i].strval = strval;
                continue;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, (String)"att.prop[i]", (DevFailed)e);
            }
        }
        String message = "";
        if (v.size() > 0) {
            for (String s : v) {
                message = message + s;
            }
        } else {
            message = "Nothing changed !";
        }
        Utils.popupMessage(this, message);
        this.doClose();
    }

    private void histoActionPerformed(ActionEvent evt) {
        JButton b = (JButton)evt.getSource();
        int idx = -1;
        for (int i = 0; i < this.btn.length; ++i) {
            if (b != this.btn[i]) continue;
            idx = i;
        }
        if (idx < 0) {
            Utils.popupError(this, "Cannot retreive Device, attribute...");
            return;
        }
        try {
            String propname = this.att.prop[idx].name;
            Database db = ApiUtil.get_db_obj();
            DbHistory[] histo = db.get_device_attribute_property_history(this.dev.name(), this.att.name, propname);
            Object[] strhisto = new String[histo.length];
            int nb = histo.length;
            if (nb == 0) {
                Utils.popupError(this, "No history found !");
                return;
            }
            for (int i = 0; i < histo.length; ++i) {
                strhisto[nb - i - 1] = histo[i].getDate() + ":      " + histo[i].getValue();
            }
            String choice = (String)JOptionPane.showInputDialog(this.parent, this.dev.name() + "/" + this.att.name + "-" + propname + " :", "", 1, null, strhisto, strhisto[0]);
            if (choice != null) {
                int start = choice.indexOf(":   ") + 1;
                this.txt[idx].setText(choice.substring(start).trim());
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Attribute Property History", (DevFailed)e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

