/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.LogRecord;
import admin.astor.statistics.ServerRecord;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;

public class ServerStat
extends ArrayList<ServerRecord> {
    public String name;
    public StarterStat starterStat;
    public int nbFailures = 0;
    public long failedDuration = 0L;
    public long runDuration = 0L;
    public long oldestTime = 0L;
    private ArrayList<LogRecord> logs = new ArrayList();
    public static final String className = "ServerStat";
    private static final String nameStr = "server";
    private static final String nbFailStr = "nbFailures";
    private static final String tFailStr = "failedDuration";
    private static final String tRunStr = "runDuration";
    private static final String resetStr = "reset";
    private static final String description = "<ServerStat server=\"SERVER\" nbFailures=\"NB_FAILURES\" failedDuration=\"FAILED_DURATION\" runDuration=\"RUN_DURATION\"reset=\"RESET\">";
    private static final String tab = "\t\t\t";

    public ServerStat(ArrayList<String> lines) throws DevFailed {
        this.parseXmlStatistics(lines);
    }

    private void parseXmlStatistics(ArrayList<String> lines) throws DevFailed {
        if (lines.size() >= 0) {
            this.parseXmlProperties(lines.get(0));
            for (int i = 1; i < lines.size(); ++i) {
                this.add(new ServerRecord(lines.get(i)));
            }
        }
    }

    private void parseXmlProperties(String line) throws DevFailed {
        this.name = Utils.parseXmlProperty(line, nameStr);
        try {
            this.nbFailures = Integer.parseInt(Utils.parseXmlProperty(line, nbFailStr));
            this.failedDuration = Long.parseLong(Utils.parseXmlProperty(line, tFailStr));
            this.runDuration = Long.parseLong(Utils.parseXmlProperty(line, tRunStr));
            this.oldestTime = Long.parseLong(Utils.parseXmlProperty(line, resetStr));
        }
        catch (NumberFormatException e) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)e.toString(), (String)"ServerStat.parseLine()");
        }
    }

    public ServerStat(String name) {
        this.name = name;
    }

    public ServerStat(String name, StarterStat starterStat) {
        this.name = name;
        this.starterStat = starterStat;
    }

    public void addLog(LogRecord log) {
        this.logs.add(log);
    }

    public void computeStatistics() {
        this.nbFailures = 0;
        this.failedDuration = 0L;
        this.runDuration = 0L;
        this.oldestTime = System.currentTimeMillis();
        ArrayList<ServerRecord> serverRecords = new ArrayList<ServerRecord>();
        for (int i = this.logs.size() - 1; i >= 0; --i) {
            int idx;
            long t0;
            LogRecord log = this.logs.get(i);
            DevState state = log.newState;
            long t1 = 0L;
            if (state == DevState.FAULT) {
                ++this.nbFailures;
                t0 = log.failedTime;
                if (i == 0) {
                    t1 = System.currentTimeMillis();
                } else {
                    idx = this.getNextRestartIndex(i);
                    if (idx >= 0) {
                        t1 = this.logs.get((int)idx).startedTime;
                        i = idx + 1;
                    } else {
                        idx = this.getNextFailureIndex(i);
                        if (idx >= 0) {
                            t1 = this.logs.get((int)idx).failedTime;
                            i = idx + 1;
                        }
                    }
                }
                this.failedDuration += t1 - t0;
            } else {
                t0 = log.startedTime;
                if (i == 0) {
                    t1 = System.currentTimeMillis();
                } else {
                    idx = this.getNextFailureIndex(i);
                    if (idx >= 0) {
                        t1 = this.logs.get((int)idx).failedTime;
                        i = idx + 1;
                    } else {
                        idx = this.getNextRestartIndex(i);
                        if (idx >= 0) {
                            t1 = this.logs.get((int)idx).startedTime;
                            i = idx + 1;
                        }
                    }
                }
                this.runDuration += t1 - t0;
            }
            ServerRecord serverRecord = new ServerRecord(log.newState, t0, t1, log.autoRestart);
            serverRecords.add(serverRecord);
            if (this.oldestTime <= t0) continue;
            this.oldestTime = t0;
        }
        for (ServerRecord rec : serverRecords) {
            this.add(0, rec);
        }
    }

    private int getNextRestartIndex(int i) {
        --i;
        while (i >= 0) {
            LogRecord rec = this.logs.get(i);
            if (rec.newState == DevState.ON) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private int getNextFailureIndex(int i) {
        --i;
        while (i >= 0) {
            LogRecord rec = this.logs.get(i);
            if (rec.newState == DevState.FAULT) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public String recordsToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name).append(":\n");
        for (ServerRecord rec : this) {
            sb.append(rec).append("\n");
        }
        return sb.toString();
    }

    public double getAvailability() {
        return (double)this.runDuration / (double)(this.runDuration + this.failedDuration);
    }

    public long getLastFailure() {
        for (ServerRecord rec : this) {
            if (rec.state != DevState.FAULT || rec.startTime <= 0L) continue;
            return rec.startTime;
        }
        return 0L;
    }

    private String toXmlLine() {
        String str = description;
        str = Utils.strReplace(str, "SERVER", this.name);
        str = Utils.strReplace(str, "NB_FAILURES", Integer.toString(this.nbFailures));
        str = Utils.strReplace(str, "FAILED_DURATION", Long.toString(this.failedDuration));
        str = Utils.strReplace(str, "RUN_DURATION", Long.toString(this.runDuration));
        str = Utils.strReplace(str, "RESET", Long.toString(this.oldestTime));
        return str;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append(tab).append("").append(this.toXmlLine()).append(">\n");
        for (ServerRecord record : this) {
            sb.append(record.toXml()).append("\n");
        }
        sb.append(tab).append("</ServerStat>");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name).append(":\thas run ").append(Utils.formatDuration(this.runDuration));
        if (this.nbFailures > 0) {
            sb.append("   has failed ").append(this.nbFailures).append(" times  (total time: ").append(Utils.formatDuration(this.failedDuration)).append(") - ").append(this.size()).append(" records");
        }
        return sb.toString();
    }
}

