/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.AstorUtil;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ResetStatistics {
    private int nbHosts = 0;
    private int done = 0;
    private JFrame parent;

    public ResetStatistics(JFrame parent) {
        this.parent = parent;
        ArrayList<String> hosts = Utils.getHostControlledList(true, false);
        StringBuffer failed = new StringBuffer();
        if (this.getConfirm(hosts)) {
            this.nbHosts = hosts.size();
            if (parent != null) {
                AstorUtil.startSplash("Statistics ");
            }
            for (String host : hosts) {
                if (parent != null) {
                    int ratio = 100 / this.nbHosts;
                    if (ratio < 1) {
                        ratio = 1;
                    }
                    AstorUtil.increaseSplashProgress(ratio, "Resetting " + host);
                }
                try {
                    String devName = host;
                    if (host.indexOf(47) < 0) {
                        devName = AstorUtil.getStarterDeviceHeader() + host;
                    }
                    System.out.println("Resetting " + host);
                    DeviceProxy dev = new DeviceProxy(devName);
                    dev.command_inout("ResetStatistics");
                    ++this.done;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                    }
                }
                catch (DevFailed e) {
                    failed.append(host).append(":    ").append(e.errors[0].desc).append("\n");
                }
            }
        }
        if (parent != null) {
            AstorUtil.stopSplash();
        }
        if (failed.length() > 0) {
            if (parent == null) {
                System.err.println(failed);
            } else {
                JOptionPane.showMessageDialog(parent, failed.toString(), "error", 0);
            }
        }
        if (parent != null) {
            JOptionPane.showMessageDialog(parent, this, "Command done", 1);
        } else {
            System.out.println(this);
        }
    }

    private boolean getConfirm(ArrayList<String> hosts) {
        if (this.parent != null) {
            return JOptionPane.showConfirmDialog(this.parent, "Reset Statistics on " + hosts.size() + " hosts ?", "Confirm Dialog", 0) == 0;
        }
        try {
            System.out.println("OK to reset statistics on " + hosts.size() + " (y/n) ?");
            byte[] b = new byte[100];
            if (System.in.read(b) > 0 && b[0] == 121) {
                return true;
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return false;
    }

    public String toString() {
        return "ResetStatistics done for " + this.done + " hosts / " + this.nbHosts;
    }

    public static void main(String[] args) {
        new ResetStatistics(null);
    }
}

