/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.UserGroup;
import admin.astor.access.UsersTree;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditDialog
extends JDialog {
    private int retVal = 0;
    static final int CHECK_ACCESS = 0;
    static final int EDIT_USER = 1;
    static final int CLONE_USER = 2;
    private int mode = 1;
    private static String[] titles;
    private static final String[] check_titles;
    private static final String[] edit_titles;
    private static final String[] clone_titles;
    static final int USER = 0;
    static final int ADDRESS = 1;
    static final int DEVICE = 2;
    private AccessProxy accessProxy;
    private JTextField[] textFields;
    private JLabel checkResultLabel;
    private JLabel[] labels;
    private JComboBox<UserGroup> groupBox;
    private JPanel centerPanel;
    private JButton okBtn;

    public EditDialog(JFrame parent, String user, String address, ArrayList<UserGroup> groups, UserGroup defaultGroup) {
        super((Frame)parent, true);
        this.mode = address == null ? 2 : 1;
        titles = address == null ? clone_titles : edit_titles;
        this.initComponents();
        this.initOwnComponents(titles);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        this.groupBox = new JComboBox();
        for (UserGroup group : groups) {
            this.groupBox.addItem(group);
        }
        this.groupBox.setEditable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.centerPanel.add(this.groupBox, gbc);
        gbc.gridx = 0;
        this.centerPanel.add((Component)new JLabel("Group:"), gbc);
        if (defaultGroup != null) {
            this.groupBox.setSelectedItem(defaultGroup);
        } else {
            this.groupBox.setSelectedItem("");
        }
        if (this.mode != 2) {
            this.labels[2].setVisible(false);
            this.textFields[2].setVisible(false);
            this.textFields[0].setText(user);
            this.textFields[1].setText(address);
        }
        this.centerDialog(parent);
        this.textFields[0].requestFocus();
    }

    public EditDialog(JFrame parent, AccessProxy accessProxy) {
        super((Frame)parent, true);
        this.mode = 0;
        titles = check_titles;
        this.accessProxy = accessProxy;
        this.initComponents();
        this.initOwnComponents(titles);
        this.centerDialog(parent);
    }

    private void centerDialog(JFrame parent) {
        this.pack();
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - this.getWidth()) / 2;
        p.y += (parent.getHeight() - this.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        this.setLocation(p);
    }

    private void initOwnComponents(String[] titles) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.textFields = new JTextField[titles.length];
        this.labels = new JLabel[titles.length];
        for (int i = 0; i < titles.length; ++i) {
            this.labels[i] = new JLabel(titles[i] + ":  ");
            gbc.gridx = 0;
            gbc.gridy = i + 1;
            gbc.fill = 2;
            this.centerPanel.add((Component)this.labels[i], gbc);
            this.textFields[i] = new JTextField();
            this.textFields[i].setColumns(20);
            this.textFields[i].addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    EditDialog.this.textKeyPressed(evt);
                }
            });
            gbc.gridx = 1;
            gbc.gridy = i + 1;
            gbc.fill = 2;
            this.centerPanel.add((Component)this.textFields[i], gbc);
        }
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        this.okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.centerPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.pack();
    }

    private boolean checkInputs() {
        String user = this.textFields[0].getText().trim().toLowerCase();
        this.textFields[0].setText(user);
        if (this.mode != 0) {
            String grpName = this.groupBox.getSelectedItem().toString();
            if (grpName.startsWith("All") || grpName.endsWith("Users")) {
                Utils.popupError(this, "Incoherent group name !");
                return false;
            }
            if (this.mode == 1 && grpName.length() == 0) {
                Utils.popupError(this, "Group name ?");
                return false;
            }
        }
        if (user.length() == 0) {
            Utils.popupError(this, "User name NOT defined !");
            return false;
        }
        if (this.mode != 2) {
            String address = this.textFields[1].getText().trim();
            String device = this.textFields[2].getText().trim().toLowerCase();
            if (address.length() == 0 || this.mode == 0 && device.length() == 0) {
                Utils.popupError(this, "Please fill all fields !");
                return false;
            }
            this.textFields[2].setText(device);
            this.textFields[1].setText(address);
            try {
                InetAddress iadd = InetAddress.getByName(address);
                address = iadd.getHostAddress();
                this.textFields[1].setText(address);
            }
            catch (Exception e) {
                // empty catch block
            }
            ArrayList<String> tokens = new ArrayList<String>();
            if (this.mode == 0) {
                StringTokenizer stk = new StringTokenizer(device, "/");
                while (stk.hasMoreTokens()) {
                    tokens.add(stk.nextToken());
                }
                if (tokens.size() > 3) {
                    Utils.popupError(this, "Incorrect device name  (too many members)");
                    return false;
                }
                if (tokens.size() < 3) {
                    Utils.popupError(this, "Incorrect device name  (not enough members)");
                    return false;
                }
            }
            StringTokenizer stk1 = new StringTokenizer(address, ".");
            tokens.clear();
            while (stk1.hasMoreTokens()) {
                tokens.add(stk1.nextToken());
            }
            if (tokens.size() > 4) {
                Utils.popupError(this, "Incorrect IP address  (Too many members)");
                return false;
            }
            if (tokens.size() < 4) {
                Utils.popupError(this, "Incorrect IP address  (not enougth members)");
                return false;
            }
            address = (String)tokens.get(0) + "." + (String)tokens.get(1) + "." + (String)tokens.get(2) + "." + (String)tokens.get(3);
            this.textFields[1].setText(address);
            for (int i = 0; i < tokens.size(); ++i) {
                try {
                    Short.parseShort((String)tokens.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    if (((String)tokens.get(i)).equals("*")) continue;
                    Utils.popupError(this, "Incorrect IP address  (member #" + (i + 1) + " (" + (String)tokens.get(i) + ") is not a number)");
                    return false;
                }
            }
        }
        return true;
    }

    private void checkAccess() {
        try {
            String result = this.accessProxy.getAccess(this.getInputs());
            this.checkResultLabel.setText(result);
            if (result.equals("read")) {
                this.checkResultLabel.setIcon(UsersTree.read_icon);
            } else {
                this.checkResultLabel.setIcon(UsersTree.write_icon);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TANGO Access", (DevFailed)e);
        }
    }

    private void textKeyPressed(KeyEvent evt) {
        char c = evt.getKeyChar();
        switch (c) {
            case '\u001b': {
                this.retVal = 2;
                this.doClose();
                break;
            }
            case '\n': {
                switch (this.mode) {
                    case 1: 
                    case 2: {
                        if (!this.checkInputs()) break;
                        this.retVal = 0;
                        this.doClose();
                        break;
                    }
                    case 0: {
                        if (!this.checkInputs()) break;
                        this.checkAccess();
                    }
                }
                break;
            }
            default: {
                if (this.mode != 0) break;
                this.checkResultLabel.setText("...");
                this.checkResultLabel.setIcon(null);
            }
        }
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.checkInputs()) {
            this.retVal = 0;
            if (this.mode == 0) {
                this.checkAccess();
            } else {
                this.doClose();
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String[] getInputs() {
        String[] val = new String[this.textFields.length];
        for (int i = 0; i < this.textFields.length; ++i) {
            val[i] = this.textFields[i].getText().trim();
        }
        return val;
    }

    public UserGroup getUserGroup() {
        Object object = this.groupBox.getSelectedItem();
        if (object instanceof UserGroup) {
            return (UserGroup)object;
        }
        String name = object.toString();
        if (name.length() == 0) {
            return null;
        }
        return new UserGroup(name);
    }

    public int showDialog() {
        if (this.mode == 0) {
            try {
                this.textFields[0].setText(System.getProperty("user.name").toLowerCase());
                this.textFields[1].setText(InetAddress.getLocalHost().getHostAddress());
                this.okBtn.setText("Check");
                GridBagConstraints gbc = new GridBagConstraints();
                this.checkResultLabel = new JLabel("...");
                gbc.gridx = 1;
                gbc.gridy = titles.length + 1;
                gbc.fill = 2;
                this.centerPanel.add((Component)this.checkResultLabel, gbc);
                this.pack();
            }
            catch (UnknownHostException e) {
                Utils.popupError(this, null, e);
            }
        }
        this.setVisible(true);
        return this.retVal;
    }

    static {
        check_titles = new String[]{"User Name", "IP Address", "Device"};
        edit_titles = new String[]{"User Name", "Allowed Address", "Device"};
        clone_titles = new String[]{"User Name"};
    }
}

