/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.UserGroup;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChooseGroupDialog
extends JDialog {
    private int retVal = 0;
    private JComboBox<UserGroup> groupComboBox;
    private JLabel titleLabel;

    public ChooseGroupDialog(JFrame parent, String title, ArrayList<UserGroup> groups) {
        super((Frame)parent, true);
        this.initComponents();
        for (UserGroup group : groups) {
            this.groupComboBox.addItem(group);
        }
        this.groupComboBox.setEditable(true);
        this.titleLabel.setText(title);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel centerPanel = new JPanel();
        this.groupComboBox = new JComboBox();
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JLabel dummyLbl = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ChooseGroupDialog.this.closeDialog(evt);
            }
        });
        centerPanel.setLayout(new GridBagLayout());
        this.groupComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseGroupDialog.this.groupComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        centerPanel.add(this.groupComboBox, gridBagConstraints);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        centerPanel.add((Component)topPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 50, 0);
        centerPanel.add((Component)dummyLbl, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseGroupDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseGroupDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void groupComboBoxActionPerformed(ActionEvent evt) {
        this.retVal = 0;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public UserGroup getUserGroup() {
        Object object = this.groupComboBox.getSelectedItem();
        if (object instanceof UserGroup) {
            return (UserGroup)object;
        }
        String name = object.toString();
        if (name.length() == 0) {
            return null;
        }
        return new UserGroup(name);
    }
}

