/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.Monitor;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ServerCmdThread
extends Thread
implements AstorDefs {
    private Component parent;
    private TangoHost[] hosts;
    private int cmd;
    private Monitor monitor;
    private boolean[] levelUsed;
    private short nbStartupLevels;
    private String monitor_title;
    private boolean confirm = true;
    private boolean from_array = true;
    private ArrayList<Integer> levels;

    public ServerCmdThread(Component component, TangoHost[] tangoHostArray, int n) {
        this.parent = component;
        this.hosts = tangoHostArray;
        this.cmd = n;
        this.monitor_title = " on all controlled hosts   ";
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
        this.levelUsed = new boolean[this.nbStartupLevels];
        for (int i = 0; i < this.nbStartupLevels; ++i) {
            this.levelUsed[i] = true;
        }
    }

    public ServerCmdThread(Component component, TangoHost tangoHost, int n, boolean[] blArray) {
        this.parent = component;
        this.hosts = new TangoHost[1];
        this.hosts[0] = tangoHost;
        this.cmd = n;
        this.levelUsed = blArray;
        this.monitor_title = " on " + (Object)((Object)tangoHost) + "   ";
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
    }

    public ServerCmdThread(Component component, TangoHost tangoHost, int n, ArrayList<Integer> arrayList) {
        this(component, tangoHost, n, arrayList, true);
    }

    public ServerCmdThread(Component component, TangoHost tangoHost, int n, ArrayList<Integer> arrayList, boolean bl) {
        this.parent = component;
        this.hosts = new TangoHost[1];
        this.hosts[0] = tangoHost;
        this.cmd = n;
        this.levels = arrayList;
        this.confirm = bl;
        this.monitor_title = " on " + (Object)((Object)tangoHost) + "   ";
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
        this.from_array = false;
    }

    private void updateProgressMonitor(int n, int n2, double d) {
        String string;
        if (this.monitor == null) {
            string = cmdStr[this.cmd] + this.monitor_title;
            if (this.parent instanceof JDialog) {
                this.monitor = new Monitor((JDialog)this.parent, string, cmdStr[this.cmd]);
            } else if (this.parent instanceof JFrame) {
                this.monitor = new Monitor((JFrame)this.parent, string, cmdStr[this.cmd]);
            }
        }
        string = cmdStr[this.cmd] + "Servers on " + this.hosts[n2].getName() + " for level " + n;
        this.monitor.setProgressValue(d, string);
    }

    @Override
    public void run() {
        block15: {
            block14: {
                AstorUtil.getStarterNbStartupLevels();
                this.updateProgressMonitor(0, 0, 0.05);
                if (!this.from_array) break block14;
                switch (this.cmd) {
                    case 0: {
                        for (int i = 1; !this.monitor.isCanceled() && i <= this.nbStartupLevels; ++i) {
                            if (!this.levelUsed[i - 1]) continue;
                            if (this.confirm) {
                                int n = JOptionPane.showConfirmDialog(this.parent, cmdStr[this.cmd] + " for level " + i, "", 1);
                                if (n == 2) {
                                    i = this.nbStartupLevels;
                                    continue;
                                }
                                if (n != 0) continue;
                                this.executeCommand(this.hosts, i);
                                continue;
                            }
                            this.executeCommand(this.hosts, i);
                        }
                        break block15;
                    }
                    case 1: {
                        for (int i = this.nbStartupLevels; !this.monitor.isCanceled() && i > 0; --i) {
                            if (!this.levelUsed[i - 1]) continue;
                            int n = JOptionPane.showConfirmDialog(this.parent, cmdStr[this.cmd] + " for level " + i, "", 1);
                            if (n == 2) {
                                i = 0;
                                continue;
                            }
                            if (n != 0) continue;
                            this.executeCommand(this.hosts, i);
                        }
                        break;
                    }
                }
                break block15;
            }
            block10: for (int i = 0; i < this.levels.size(); ++i) {
                int n = this.levels.get(i);
                int n2 = JOptionPane.showConfirmDialog(this.parent, cmdStr[this.cmd] + " for level " + n, "", 1);
                switch (n2) {
                    case 2: {
                        i = this.levels.size();
                        continue block10;
                    }
                    case 0: {
                        this.executeCommand(this.hosts, n);
                        continue block10;
                    }
                }
            }
        }
        this.monitor.setProgressValue(100.0);
    }

    private void executeCommand(TangoHost[] tangoHostArray, int n) {
        for (int i = 0; !this.monitor.isCanceled() && i < tangoHostArray.length; ++i) {
            TangoHost tangoHost = tangoHostArray[i];
            try {
                switch (this.cmd) {
                    case 0: {
                        double d = ((double)(n + 1) * (double)tangoHostArray.length + (double)i) / (double)(tangoHostArray.length * (this.nbStartupLevels + 2));
                        this.updateProgressMonitor(n, i, d);
                        tangoHost.startServers(n);
                        try {
                            ServerCmdThread.sleep(500L);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 1: {
                        double d = ((double)(this.nbStartupLevels - n + 1) * (double)tangoHostArray.length + (double)i) / (double)(tangoHostArray.length * (this.nbStartupLevels + 2));
                        this.updateProgressMonitor(n, i, d);
                        tangoHost.stopServers(n);
                        try {
                            ServerCmdThread.sleep(50L);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            tangoHost.updateData();
        }
    }
}

