/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import fr.esrf.TangoApi.DbServInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PutServerInfoDialog
extends JDialog {
    public static final int RET_CANCEL = 2;
    public static final int RET_OK = 0;
    private DbServInfo server_info;
    private JButton unregisterBtn;
    private boolean unregister = false;
    private Component parent;
    private boolean manage_unregister = true;
    private JRadioButton yesButton;
    private JRadioButton noButton;
    private JComboBox<String> jComboBox1;
    private JLabel title;
    private int returnStatus = 2;

    public PutServerInfoDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.parent = jDialog;
        this.initComponents();
        this.jComboBox1.addItem("None");
        int n = AstorUtil.getStarterNbStartupLevels();
        for (int i = 1; i <= n; ++i) {
            String string = "Level " + i;
            this.jComboBox1.addItem(string);
        }
        this.pack();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.yesButton = new JRadioButton();
        this.noButton = new JRadioButton();
        JLabel jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.title = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PutServerInfoDialog.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new FlowLayout(2, 5, 5));
        jButton.setText("  OK  ");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PutServerInfoDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PutServerInfoDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setText("Controlled by Astor : ");
        jLabel.setForeground(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.yesButton.setText("Yes");
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PutServerInfoDialog.this.yesnoButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.yesButton, gridBagConstraints);
        this.noButton.setText("No");
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PutServerInfoDialog.this.yesnoButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.noButton, gridBagConstraints);
        jLabel2.setText("Startup Level : ");
        jLabel2.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        jPanel2.add(this.jComboBox1, gridBagConstraints);
        jLabel3.setText(" ");
        jLabel3.setForeground(Color.black);
        jLabel3.setFont(new Font("Dialog", 1, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setPreferredSize(new Dimension(50, 40));
        jLabel4.setMinimumSize(new Dimension(50, 40));
        jLabel4.setText(" ");
        jLabel4.setForeground(Color.black);
        jLabel4.setFont(new Font("Dialog", 1, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 10.0;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText(" ");
        jLabel5.setForeground(Color.black);
        jLabel5.setFont(new Font("Dialog", 1, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        jPanel2.add((Component)new JLabel("  "), gridBagConstraints);
        this.unregisterBtn = new JButton("Remove startup level info");
        this.unregisterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PutServerInfoDialog.this.unregisterBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        jPanel2.add((Component)this.unregisterBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.title.setText(" ");
        this.title.setForeground(Color.black);
        this.title.setFont(new Font("Dialog", 1, 16));
        this.getContentPane().add((Component)this.title, "North");
    }

    private void unregisterBtnActionPerformed(ActionEvent actionEvent) {
        this.unregister = JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to remove " + this.server_info.name + " startup info ?", "Confirm Dialog", 0) == 0;
        if (this.unregister) {
            this.doClose(0);
        }
    }

    private void yesnoButtonActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Yes")) {
            this.updateButtons(true, this.server_info.startup_level);
        } else {
            this.updateButtons(false, 0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(2);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.yesButton.getSelectedObjects() != null;
        int n = this.jComboBox1.getSelectedIndex();
        if (!bl || n == 0) {
            n = 0;
        }
        if (bl != this.server_info.controlled || n != this.server_info.startup_level) {
            this.doClose(0);
        } else {
            this.doClose(2);
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(2);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }

    private void updateButtons(boolean bl, int n) {
        this.yesButton.setSelected(bl);
        this.noButton.setSelected(!bl);
        this.jComboBox1.setEnabled(bl);
        if (bl) {
            this.server_info.startup_level = n;
            this.jComboBox1.setSelectedIndex(n);
            this.unregisterBtn.setVisible(false);
        } else {
            this.jComboBox1.setSelectedIndex(0);
            if (this.server_info.name.length() > 0 && this.manage_unregister) {
                this.unregisterBtn.setVisible(true);
            } else {
                this.unregisterBtn.setVisible(false);
            }
        }
    }

    public int showDialog(DbServInfo dbServInfo) {
        this.server_info = dbServInfo;
        this.title.setText("  " + dbServInfo.name + " running on " + dbServInfo.host + "  ");
        this.updateButtons(dbServInfo.controlled, dbServInfo.startup_level);
        this.pack();
        this.setVisible(true);
        return this.returnStatus;
    }

    public int showDialog(DbServInfo dbServInfo, int n) {
        this.server_info = dbServInfo;
        this.manage_unregister = false;
        this.title.setText("  Servers (Level " + n + ")   running on " + dbServInfo.host + "  ");
        this.updateButtons(dbServInfo.controlled, dbServInfo.startup_level);
        this.pack();
        this.setVisible(true);
        return this.returnStatus;
    }

    public DbServInfo getSelection() {
        if (this.unregister) {
            return null;
        }
        boolean bl = this.yesButton.getSelectedObjects() != null;
        int n = this.jComboBox1.getSelectedIndex();
        if (!bl || n == 0) {
            n = 0;
        }
        return new DbServInfo(this.server_info.name, this.server_info.host, bl, n);
    }
}

