/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoServer;
import admin.astor.tools.PopupTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class MultiServerCommand
extends JDialog {
    private static String str_filter = "*";
    private static String[] commands = new String[]{"", "Start", "Stop", "Status", "Uptime"};
    private JComboBox<String> comboBox;
    private JTextField filterTxt;
    private JList<String> jList;
    private long delayBetweenServers = 1000L;

    public MultiServerCommand(JFrame jFrame) throws DevFailed {
        super((Frame)jFrame, false);
        this.initComponents();
        this.filterTxt.setText(str_filter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MultiServerCommand.this.listSelectionPerformed(mouseEvent);
            }
        };
        this.jList.addMouseListener(mouseAdapter);
        for (String string : commands) {
            this.comboBox.addItem(string);
        }
        this.setList();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void setList() throws DevFailed {
        str_filter = this.filterTxt.getText();
        String[] stringArray = ApiUtil.get_db_obj().get_server_list(str_filter);
        this.jList.setListData((String[])stringArray);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.filterTxt = new JTextField();
        JScrollPane jScrollPane = new JScrollPane();
        this.jList = new JList();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.comboBox = new JComboBox();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultiServerCommand.this.closeDialog(windowEvent);
            }
        });
        jLabel.setText("Filter :  ");
        jPanel.add(jLabel);
        this.filterTxt.setColumns(20);
        this.filterTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiServerCommand.this.filterTxtActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.filterTxt);
        this.getContentPane().add((Component)jPanel, "North");
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        jScrollPane.setViewportView(this.jList);
        this.getContentPane().add((Component)jScrollPane, "Center");
        jPanel2.setLayout(new GridBagLayout());
        jLabel2.setText("Command:");
        jPanel3.add(jLabel2);
        jPanel3.add(this.comboBox);
        jButton.setText("Send");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiServerCommand.this.sendCmdBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 50);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jButton2.setText("Dismiss");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiServerCommand.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel2.add((Component)jButton2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "South");
    }

    private void listSelectionPerformed(MouseEvent mouseEvent) {
    }

    private void filterTxtActionPerformed(ActionEvent actionEvent) {
        try {
            this.setList();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"", (DevFailed)devFailed);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void sendCmdBtnActionPerformed(ActionEvent actionEvent) {
        List<String> list = this.jList.getSelectedValuesList();
        if (list.size() == 0) {
            MultiServerCommand.displayError(this, "No server selected !", "MultiServerCommand.sendCmdBtnActionPerformed()");
            return;
        }
        String string = (String)this.comboBox.getSelectedItem();
        if (string.length() == 0) {
            MultiServerCommand.displayError(this, "No command selected !", "MultiServerCommand.sendCmdBtnActionPerformed()");
            return;
        }
        if (string.toLowerCase().equals("uptime")) {
            this.displayServerUptimes(list);
        } else if (string.toLowerCase().equals("status")) {
            this.displayServerStatus(list);
        } else {
            this.starterCommandForServers(string, list);
        }
    }

    public static void displayError(Component component, String string, String string2) {
        try {
            Except.throw_exception((String)"ERROR", (String)string, (String)string2);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)devFailed);
        }
    }

    public static void main(String[] stringArray) {
        try {
            MultiServerCommand multiServerCommand = new MultiServerCommand(new JFrame());
            multiServerCommand.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"", (DevFailed)devFailed);
        }
    }

    private static String getHostnameWithoutFQDN(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private DeviceProxy getStarterInstanceForServer(String string) throws DevFailed {
        String string2 = "dserver/" + string;
        DeviceProxy deviceProxy = new DeviceProxy(string2);
        DeviceInfo deviceInfo = deviceProxy.get_info();
        String string3 = MultiServerCommand.getHostnameWithoutFQDN(deviceInfo.hostname);
        String string4 = AstorUtil.getStarterDeviceHeader() + string3;
        return new DeviceProxy(string4);
    }

    private long getDelayBetweenServers(String string, long l) {
        long l2 = -1L;
        while (l2 < 0L) {
            String string2 = (String)JOptionPane.showInputDialog(this, string + "\nDelay between servers (ms) ?", "Input Dialog", 1, null, null, l);
            if (string2 == null) {
                return -1L;
            }
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorPane.showErrorMessage((Component)this, null, (Exception)numberFormatException);
            }
        }
        if (l2 == 0L) {
            l2 = 10L;
        }
        return l2;
    }

    private void displayServerUptimes(List<String> list) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            for (String stringArray2 : list) {
                String[] i = new TangoServer("dserver/" + stringArray2).getServerUptime();
                arrayList.add(new String[]{stringArray2, i[0], i[1]});
            }
            String[] stringArray4 = new String[]{"Server", "Last   exported", "Last unexported"};
            String[][] stringArray = new String[arrayList.size()][];
            for (int popupTable = 0; popupTable < arrayList.size(); ++popupTable) {
                stringArray[popupTable] = (String[])arrayList.get(popupTable);
            }
            PopupTable popupTable = new PopupTable(this, "", stringArray4, stringArray, new Dimension(650, 250));
            popupTable.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private static String convertStatus(String string) {
        if (string.equals("ON")) {
            return "Running";
        }
        if (string.equals("FAULT")) {
            return "Stopped";
        }
        if (string.equals("MOVING")) {
            return "Running but NOT responding";
        }
        return string;
    }

    private void displayServerStatus(List<String> list) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (String stringArray2 : list) {
            try {
                String[] stringArray;
                DeviceProxy devFailed = this.getStarterInstanceForServer(stringArray2);
                DeviceAttribute deviceAttribute = devFailed.read_attribute("Servers");
                for (String string : stringArray = deviceAttribute.extractStringArray()) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken();
                    String string3 = MultiServerCommand.convertStatus(stringTokenizer.nextToken());
                    if (!string2.toLowerCase().equals(stringArray2.toLowerCase())) continue;
                    arrayList.add(new String[]{string2, string3});
                }
            }
            catch (DevFailed i) {
                arrayList.add(new String[]{stringArray2, i.errors[0].desc});
            }
        }
        if (arrayList.size() == 0) {
            System.err.println("No data found !");
            return;
        }
        String[] stringArray4 = new String[]{"Servers", "Status"};
        String[][] stringArray = new String[arrayList.size()][];
        for (int popupTable = 0; popupTable < arrayList.size(); ++popupTable) {
            stringArray[popupTable] = (String[])arrayList.get(popupTable);
        }
        try {
            PopupTable devFailed = new PopupTable(this, "", stringArray4, stringArray, new Dimension(650, 250));
            devFailed.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void starterCommandForServers(String string, List<String> list) {
        if (string.equals("Start")) {
            string = "DevStart";
        } else if (string.equals("Stop")) {
            string = "DevStop";
        }
        long l = this.getDelayBetweenServers("Send " + string + "  on all selected servers:", this.delayBetweenServers);
        if (l > 0L) {
            this.delayBetweenServers = l;
            new CommandThread(this, string, list, this.delayBetweenServers).start();
        }
    }

    private class CommandThread
    extends Thread {
        private Component component;
        private String command;
        private List<String> servNames;
        private long delay;

        private CommandThread(Component component, String string, List<String> list, long l) {
            this.component = component;
            this.command = string;
            this.servNames = list;
            this.delay = l;
        }

        @Override
        public void run() {
            this.component.setCursor(new Cursor(3));
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.servNames) {
                try {
                    DeviceProxy deviceProxy = MultiServerCommand.this.getStarterInstanceForServer(string);
                    DeviceData deviceData = new DeviceData();
                    deviceData.insert(string);
                    deviceProxy.command_inout(this.command, deviceData);
                    Thread.sleep(this.delay);
                }
                catch (DevFailed devFailed) {
                    stringBuilder.append(devFailed.errors[0].desc).append(" for ").append(string).append('\n');
                }
                catch (InterruptedException interruptedException) {
                    stringBuilder.append(interruptedException).append(" for ").append(string).append('\n');
                }
            }
            this.component.setCursor(new Cursor(0));
            if (stringBuilder.length() > 0) {
                MultiServerCommand.displayError(this.component, stringBuilder.toString(), "MultiServerCommand.starterCommandForServers()");
            }
        }
    }
}

