/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.HostInfoDialog;
import admin.astor.HostList;
import admin.astor.TangoServer;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jive.DevWizard;

public class ListDialog
extends JDialog {
    private static String str_filter = "*";
    private static String previousItem = null;
    private HostInfoDialog hostInfoDialog;
    private ArrayList<String> selectedItems = null;
    private JPanel filterPanel;
    private JTextField filterTxt;
    private JList<String> jList;
    private JLabel titleLabel;

    public ListDialog(HostInfoDialog hostInfoDialog) {
        super((Dialog)hostInfoDialog, true);
        this.hostInfoDialog = hostInfoDialog;
        this.initComponents();
        this.filterTxt.setText(str_filter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListDialog.this.listSelectionPerformed(mouseEvent);
            }
        };
        this.jList.addMouseListener(mouseAdapter);
        this.pack();
    }

    private void setList() throws DevFailed {
        str_filter = this.filterTxt.getText();
        String[] stringArray = ApiUtil.get_db_obj().get_server_list(str_filter);
        this.jList.setListData((String[])stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(previousItem)) continue;
            this.jList.setSelectedIndex(i);
        }
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.jList = new JList();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.titleLabel = new JLabel();
        this.filterPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.filterTxt = new JTextField();
        JButton jButton4 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ListDialog.this.closeDialog(windowEvent);
            }
        });
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        jScrollPane.setViewportView(this.jList);
        this.getContentPane().add((Component)jScrollPane, "Center");
        jPanel.setLayout(new BorderLayout());
        jButton.setText("Get Server List from Another host");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.fromAnotherCrateBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton, "North");
        jLabel.setFont(new Font("Tahoma", 0, 18));
        jLabel.setText("  ");
        jPanel.add((Component)jLabel, "Center");
        jButton2.setText("Start Server");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.startBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        jButton3.setText("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "Last");
        this.getContentPane().add((Component)jPanel, "South");
        jPanel3.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Tahoma", 1, 18));
        this.titleLabel.setText("Server list");
        jPanel4.add(this.titleLabel);
        jPanel3.add((Component)jPanel4, "First");
        jLabel2.setText("Filter :  ");
        this.filterPanel.add(jLabel2);
        this.filterTxt.setColumns(20);
        this.filterTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.filterTxtActionPerformed(actionEvent);
            }
        });
        this.filterPanel.add(this.filterTxt);
        jButton4.setText("Create New Server");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.createBtnActionPerformed(actionEvent);
            }
        });
        this.filterPanel.add(jButton4);
        jPanel3.add((Component)this.filterPanel, "Center");
        this.getContentPane().add((Component)jPanel3, "North");
    }

    private void createBtnActionPerformed(ActionEvent actionEvent) {
        block5: {
            try {
                DevWizard devWizard = new DevWizard((Dialog)this.hostInfoDialog, (DeviceProxy)this.hostInfoDialog.host);
                devWizard.showWizard(null);
                String string = DevWizard.lastServStarted;
                if (string == null) break block5;
                Point point = this.getLocationOnScreen();
                point.translate(50, 50);
                try {
                    if (new TangoServer(string, DevState.OFF).startupLevel(this.hostInfoDialog, this.hostInfoDialog.host.getName(), point)) {
                        this.hostInfoDialog.updateData();
                    }
                }
                catch (DevFailed devFailed) {
                    Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)devFailed));
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Utils.popupError(this.hostInfoDialog, "This server is too old !\nUse Jive to create it.");
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void filterTxtActionPerformed(ActionEvent actionEvent) {
        try {
            this.setList();
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)devFailed));
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void startBtnActionPerformed(ActionEvent actionEvent) {
        this.startSelectedItems();
    }

    private void listSelectionPerformed(MouseEvent mouseEvent) {
        previousItem = this.jList.getSelectedValue();
        if (mouseEvent.getClickCount() == 2) {
            this.startSelectedItems();
        }
    }

    private void startSelectedItems() {
        this.selectedItems = new ArrayList();
        List<String> list = this.jList.getSelectedValuesList();
        if (list.isEmpty()) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)new Exception("No server selected !"));
        } else {
            for (String string : list) {
                try {
                    String string2 = "dserver/" + string;
                    DeviceProxy deviceProxy = new DeviceProxy(string2);
                    try {
                        deviceProxy.ping();
                        ErrorPane.showErrorMessage((Component)this.hostInfoDialog, null, (Exception)new Exception(string + "  is Already Running  on " + new IORdump(string2).get_host() + " !"));
                    }
                    catch (DevFailed devFailed) {
                        this.selectedItems.add(string);
                    }
                }
                catch (DevFailed devFailed) {
                    Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)devFailed));
                }
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void fromAnotherCrateBtnActionPerformed(ActionEvent actionEvent) {
        try {
            HostList hostList = new HostList(this);
            if (hostList.showDialog() == 0) {
                ArrayList<String> arrayList = hostList.getServerList();
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = arrayList.get(i);
                }
                this.jList.setListData((String[])stringArray);
                this.filterPanel.setVisible(false);
                this.titleLabel.setText("Start servers from " + hostList.getSelectedHostName());
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    public void showDialog() {
        try {
            this.setList();
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.hostInfoDialog, null, (Exception)((Object)devFailed));
        }
        this.setVisible(true);
    }

    public ArrayList<String> getSelectedItems() {
        return this.selectedItems;
    }
}

