/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorCmdLine;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.DeviceTreeDialog;
import admin.astor.GetTextDialog;
import admin.astor.Monitor;
import admin.astor.MultiServerCommand;
import admin.astor.NewStarterDialog;
import admin.astor.OneTool;
import admin.astor.PreferenceDialog;
import admin.astor.Selector;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import admin.astor.statistics.StatisticsPanel;
import admin.astor.tango_release.JTangoVersion;
import admin.astor.tools.DevBrowser;
import admin.astor.tools.PopupHtml;
import admin.astor.tools.PopupTable;
import admin.astor.tools.PopupText;
import admin.astor.tools.ServerUsageDialog;
import admin.astor.tools.Utils;
import admin.astor.tools.WideSearchDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangORBversion;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Astor
extends JFrame
implements AstorDefs {
    private static String revNumber = "6.7.0  -  Wed Jan 27 07:30:19 CET 2016";
    public AstorTree tree = null;
    private boolean expanded = false;
    private JScrollPane scrollPane;
    static boolean displayed = false;
    public static DevBrowser dev_browser = null;
    static long t0;
    private String tango_host = "";
    private MultiServerCommand multiServerCommand = null;
    private static int jarUsed;
    public static int rwMode;
    private String[] htmlHelps = null;
    private int nb_def_tools = 1;
    private ArrayList<OneTool> app_tools = new ArrayList();
    private ArrayList<ActionListener> tools_al = new ArrayList();
    private Main logviewer = null;
    private static String searched_host;
    private WideSearchDialog wide_search_dlg = null;
    private JMenuItem aboutBtn;
    private JMenuItem accessControlBtn;
    private JPanel bottomPanel;
    private JMenuItem changeTgHostBtn;
    private JMenu cmdMenu;
    private JMenuItem ctrlPreferenceBtn;
    private JMenuItem deviceBrowserBtn;
    private JMenuItem distributionBtn;
    private JMenuItem exitBtn;
    private JMenuItem expandBtn;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem jiveMenuItem;
    private JMenuItem logviewerMenuItem;
    private JLabel modeLabel;
    private JMenuItem multiServersCmdItem;
    private JMenuItem newBranchBtn;
    private JMenuItem newHostBtn;
    private JMenuItem principleBtn;
    private JMenuItem releaseNoteBtn;
    private JMenuItem starterEventsItem;
    private JMenuItem starterNoEventsItem;
    private JMenuItem stateIconsBtn;
    private JMenuItem tangorbBtn;
    private JLabel titleLabel;
    private JMenu toolsMenu;
    private JPanel topPanel;
    private JMenuItem usePreferenceBtn;
    private JMenu viewMenu;

    public Astor() throws DevFailed {
        t0 = System.currentTimeMillis();
        this.initComponents();
        AstorUtil.getInstance().initIcons();
        this.customizeMenu();
        this.setTitle("TANGO Manager - " + revNumber);
        this.setControlSystemTitle();
        this.buildTree();
        ImageIcon imageIcon = Utils.getInstance().getIcon("TangoClass.gif");
        this.setIconImage(imageIcon.getImage());
        jarUsed = JTangoVersion.getInstance().getJarFileType();
        this.tangorbBtn.setText(JTangoVersion.JarUsed[jarUsed] + " Version");
        this.centerWindow();
        try {
            this.tango_host = ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getSize();
        Point point = new Point();
        point.x = (dimension.width - dimension2.width) / 2;
        point.y = (dimension.height - dimension2.height) / 2;
        this.setLocation(point);
    }

    private void setControlSystemTitle() throws DevFailed {
        String string = AstorUtil.getControlSystemName();
        if (string != null && string.length() > 0) {
            this.titleLabel.setText(string);
            this.topPanel.setVisible(true);
        } else {
            this.topPanel.setVisible(false);
        }
    }

    private void buildTree() throws DevFailed {
        String string = "Astor (TANGO Manager)";
        int n = revNumber.indexOf("-");
        if (n > 0) {
            string = string + " - " + revNumber.substring(0, n).trim();
        }
        JSmoothProgressBar jSmoothProgressBar = new JSmoothProgressBar();
        jSmoothProgressBar.setStringPainted(true);
        jSmoothProgressBar.setBackground(Color.lightGray);
        jSmoothProgressBar.setProgressBarColors(Color.gray, Color.gray, Color.gray);
        ImageIcon imageIcon = Utils.getInstance().getIcon("TangoLogo.gif");
        Splash splash = new Splash(imageIcon, Color.black, jSmoothProgressBar);
        splash.setTitle(string);
        splash.setMessage("Starting....");
        splash.setVisible(true);
        try {
            if (this.tree != null) {
                this.tree.stopThreads();
                this.scrollPane.remove(this.tree);
                this.remove(this.scrollPane);
            }
            this.tree = new AstorTree(this, splash);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(AstorUtil.getPreferredSize());
            this.scrollPane.setViewportView(this.tree);
            this.getContentPane().add((Component)this.scrollPane, "Center");
            this.expanded = false;
            this.pack();
            this.manageAccessControlMenu(this.tree.isAccessControlled());
        }
        catch (DevFailed devFailed) {
            splash.setVisible(false);
            throw devFailed;
        }
    }

    Dimension getTreeSize() {
        return this.scrollPane.getPreferredSize();
    }

    void setTreeSize(Dimension dimension) {
        this.scrollPane.setPreferredSize(dimension);
        this.pack();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.ctrlPreferenceBtn.setMnemonic('P');
        this.ctrlPreferenceBtn.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        String string = System.getProperty("NO_PREF");
        if (string != null && string.toLowerCase().equals("true")) {
            this.ctrlPreferenceBtn.setEnabled(false);
        }
        this.ctrlPreferenceBtn.setEnabled(rwMode == 0);
        this.usePreferenceBtn.setEnabled(rwMode == 0);
        this.changeTgHostBtn.setMnemonic('T');
        this.changeTgHostBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.viewMenu.setMnemonic('V');
        this.newBranchBtn.setMnemonic('N');
        this.newBranchBtn.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.deviceBrowserBtn.setMnemonic('B');
        this.deviceBrowserBtn.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.expandBtn.setMnemonic('E');
        this.expandBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.toolsMenu.setMnemonic('T');
        this.multiServersCmdItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jiveMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.logviewerMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.multiServersCmdItem.setEnabled(rwMode == 0);
        this.jiveMenuItem.setEnabled(rwMode != 2);
        this.accessControlBtn.setEnabled(rwMode != 2);
        this.cmdMenu.setMnemonic('C');
        this.cmdMenu.setEnabled(rwMode != 2);
        this.newHostBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.nb_def_tools = this.toolsMenu.getItemCount();
        this.buildToolsItems();
        this.buildAdditionnalHelps();
        this.expandBtn.setVisible(false);
        this.modeLabel.setText(strMode[rwMode]);
        this.bottomPanel.setVisible(rwMode != 0);
    }

    private void manageAccessControlMenu(boolean bl) {
        if (bl) {
            this.accessControlBtn.setMnemonic('A');
            this.accessControlBtn.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.accessControlBtn.setVisible(true);
            System.out.println("AccessControl is active");
        } else {
            this.accessControlBtn.setVisible(false);
        }
    }

    private void buildAdditionnalHelps() {
        this.htmlHelps = AstorUtil.getHtmlHelps();
        if (this.htmlHelps == null) {
            return;
        }
        if (this.htmlHelps.length == 0) {
            return;
        }
        this.helpMenu.add(new JSeparator());
        for (int i = 0; i < this.htmlHelps.length / 2; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(this.htmlHelps[2 * i]);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Astor.this.htmlHelpsItemActionPerformed(actionEvent);
                }
            });
            this.helpMenu.add(jMenuItem);
        }
    }

    private void htmlHelpsItemActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = null;
        for (int i = 0; i < this.htmlHelps.length; ++i) {
            if (!string.equals(this.htmlHelps[i]) || i >= this.htmlHelps.length - 1) continue;
            string2 = this.htmlHelps[i + 1];
        }
        if (string2 == null) {
            Utils.popupError(this, "No command found for item  '" + string + "'");
        }
        System.out.println(string2);
        AstorUtil.showInHtmBrowser(string2);
    }

    private void buildToolsItems() {
        for (int i = this.toolsMenu.getItemCount(); i > this.nb_def_tools; --i) {
            JMenuItem jMenuItem = this.toolsMenu.getItem(i - 1);
            jMenuItem.removeActionListener(this.tools_al.get(i - this.nb_def_tools - 1));
            this.toolsMenu.remove(i - 1);
        }
        this.app_tools.clear();
        this.tools_al.clear();
        String[] stringArray = AstorUtil.getTools();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                OneTool oneTool = new OneTool(stringArray[i], stringArray[i + 1]);
                this.app_tools.add(oneTool);
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText(oneTool.name);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Astor.this.toolsItemActionPerformed(actionEvent);
                    }
                };
                jMenuItem.addActionListener(actionListener);
                this.tools_al.add(actionListener);
                this.toolsMenu.add(jMenuItem);
            }
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.modeLabel = new JLabel();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.changeTgHostBtn = new JMenuItem();
        this.ctrlPreferenceBtn = new JMenuItem();
        this.usePreferenceBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.deviceBrowserBtn = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        this.expandBtn = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.cmdMenu = new JMenu();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        this.newHostBtn = new JMenuItem();
        this.newBranchBtn = new JMenuItem();
        this.toolsMenu = new JMenu();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        this.multiServersCmdItem = new JMenuItem();
        JMenuItem jMenuItem8 = new JMenuItem();
        this.jiveMenuItem = new JMenuItem();
        this.accessControlBtn = new JMenuItem();
        JMenuItem jMenuItem9 = new JMenuItem();
        this.logviewerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.principleBtn = new JMenuItem();
        this.distributionBtn = new JMenuItem();
        this.stateIconsBtn = new JMenuItem();
        this.tangorbBtn = new JMenuItem();
        this.starterEventsItem = new JMenuItem();
        this.starterNoEventsItem = new JMenuItem();
        JMenuItem jMenuItem10 = new JMenuItem();
        this.releaseNoteBtn = new JMenuItem();
        this.aboutBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Astor.this.exitForm(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Tahoma", 1, 18));
        this.topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.modeLabel.setFont(new Font("Tahoma", 1, 12));
        this.bottomPanel.add(this.modeLabel);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.fileMenu.setText("File");
        this.changeTgHostBtn.setText("Change Tango Host");
        this.changeTgHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.changeTgHostBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.changeTgHostBtn);
        this.ctrlPreferenceBtn.setText("Ctrl System Preferences");
        this.ctrlPreferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.ctrlPreferenceBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.ctrlPreferenceBtn);
        this.usePreferenceBtn.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.usePreferenceBtn.setMnemonic('U');
        this.usePreferenceBtn.setText("User Preferences");
        this.usePreferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.usePreferenceBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.usePreferenceBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.exitBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.deviceBrowserBtn.setText("Event Manager");
        this.deviceBrowserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.deviceBrowserBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.deviceBrowserBtn);
        jMenuItem.setText("Update Tree from database");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.refreshBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(jMenuItem);
        this.expandBtn.setText("Expand Tree");
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.expandBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.expandBtn);
        jMenuItem2.setText("Startup Errors");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.startupErrorBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(jMenuItem2);
        jMenuBar.add(this.viewMenu);
        this.cmdMenu.setText("Command");
        jMenuItem3.setText("Start All Controlled Servers");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.startServersBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(jMenuItem3);
        jMenuItem4.setText("Stop All Controlled Servers");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.stopServersBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(jMenuItem4);
        this.newHostBtn.setText("Add a New Host");
        this.newHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.newHostBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(this.newHostBtn);
        this.newBranchBtn.setText("Add a New Branch");
        this.newBranchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.newBranchBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(this.newBranchBtn);
        jMenuBar.add(this.cmdMenu);
        this.toolsMenu.setText("Tools");
        jMenu.setText("Find");
        jMenuItem5.setText("Host by Name");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.findHostItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem5);
        jMenuItem6.setText("Device/Server/Class by Filter");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.findObjectByFilterItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem6);
        this.toolsMenu.add(jMenu);
        jMenuItem7.setText("Ctrl System Info");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.tangoStatBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem7);
        this.multiServersCmdItem.setText("Multi Servers Command");
        this.multiServersCmdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.multiServersCmdItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.multiServersCmdItem);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenuItem8.setText("Server Usage");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.serverUsageMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem8);
        this.jiveMenuItem.setText("Jive");
        this.jiveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.jiveMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.jiveMenuItem);
        this.accessControlBtn.setText("Access Control");
        this.accessControlBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.accessControlBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.accessControlBtn);
        jMenuItem9.setText("Server Statistics");
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.statisticsBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem9);
        this.logviewerMenuItem.setText("LogViewer");
        this.logviewerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.logviewerMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.logviewerMenuItem);
        jMenuBar.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.principleBtn.setText("Principle");
        this.principleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.principleBtn);
        this.distributionBtn.setText("Servers Distribution");
        this.distributionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.distributionBtn);
        this.stateIconsBtn.setText("State Icons");
        this.stateIconsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.stateIconsBtn);
        this.tangorbBtn.setText("TangORB revision");
        this.tangorbBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.tangorbBtn);
        this.starterEventsItem.setText("Hosts Controlled on Events");
        this.starterEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.starterEventsItem);
        this.starterNoEventsItem.setText("Hosts Controlled on Polling");
        this.starterNoEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.starterNoEventsItem);
        jMenuItem10.setText("Faulty Host List");
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.faultyListItemhelpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(jMenuItem10);
        this.releaseNoteBtn.setText("Release Note");
        this.releaseNoteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.releaseNoteBtn);
        this.aboutBtn.setText("About");
        this.aboutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutBtn);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void ctrlPreferenceBtnActionPerformed(ActionEvent actionEvent) {
        new PreferenceDialog(this).setVisible(true);
        try {
            this.setControlSystemTitle();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    private void usePreferenceBtnActionPerformed(ActionEvent actionEvent) {
        List<String> list = AstorUtil.getAllKnownTangoHosts();
        GetTextDialog getTextDialog = new GetTextDialog(this, "List of User Tango Hosts", null, list);
        if (getTextDialog.showDialog() == 0) {
            list = getTextDialog.getTextLines();
            try {
                AstorUtil.saveUserKnownTangoHost(list);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void startupErrorBtnActionPerformed(ActionEvent actionEvent) {
        if (this.tree.subscribeErrWindow == null) {
            Utils.popupMessage(this, "No error at startup.");
        } else {
            this.tree.subscribeErrWindow.setVisible(true);
        }
    }

    private void accessControlBtnActionPerformed(ActionEvent actionEvent) {
        this.tree.startTACpanel();
    }

    private void changeTgHostBtnActionPerformed(ActionEvent actionEvent) {
        try {
            List<String> list = AstorUtil.getAllKnownTangoHosts();
            Selector selector = new Selector((JFrame)this, "Tango Host  (e.g.  hal:2001)", list, this.tango_host);
            ATKGraphicsUtils.centerDialog((Dialog)selector);
            String string = selector.showDialog();
            if (string == null || string.length() == 0) {
                return;
            }
            String[] stringArray = string.split(":");
            if (stringArray.length != 2) {
                Utils.popupError(this, "Input syntax error\n" + string + "\n is not a valid TANGO_HOST");
                return;
            }
            ApiUtil.get_db_obj((String)stringArray[0], (String)stringArray[1]);
            if (this.tango_host.equals(string)) {
                return;
            }
            String string2 = rwMode == 0 ? "-rw" : (rwMode == 1 ? "-db_ro" : "-ro");
            String string3 = "java -DTANGO_HOST=" + string + " admin.astor.Astor " + string2;
            AstorUtil.executeShellCmdAndReturn(string3);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot change TANGO_HOST", (Exception)exception);
        }
    }

    private void logviewerMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.logviewer == null) {
            this.logviewer = new Main((JFrame)this);
        }
        this.logviewer.setVisible(true);
        this.logviewer.toFront();
    }

    private void jiveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.tree.displayJiveAppli();
    }

    private void findHostItemActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, "Host Name ?", "Input Dialog", 1, null, null, searched_host);
        if (string != null) {
            try {
                this.tree.setSelectionRoot();
                this.tree.setSelectionPath(string);
                this.tree.displayHostInfo();
                searched_host = string;
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void tangoStatBtnActionPerformed(ActionEvent actionEvent) {
        if (JOptionPane.showConfirmDialog(this, "The System Information needs to browse Database\n        and it could take a long time !\n\nStart it any way ?", "Confirm Dialog", 0) == 0) {
            new DeviceTreeDialog(this);
        }
    }

    private void toolsItemActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            OneTool oneTool = this.getToolApplication(string);
            System.out.println("Starting " + oneTool.classname);
            if (oneTool.jframe != null) {
                oneTool.jframe.setVisible(true);
            } else {
                Constructor<?>[] constructorArray;
                Class<?> clazz = Class.forName(oneTool.classname);
                boolean bl = false;
                for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
                    Class<?>[] classArray = constructor.getParameterTypes();
                    if (classArray.length != 1 || classArray[0] != JFrame.class) continue;
                    oneTool.setJFrame((JFrame)constructor.newInstance(this));
                    oneTool.jframe.setVisible(true);
                    bl = true;
                }
                if (!bl) {
                    throw new Exception("Cannot find constructor for " + oneTool.classname);
                }
            }
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)exception);
        }
    }

    private OneTool getToolApplication(String string) throws Exception {
        for (OneTool oneTool : this.app_tools) {
            if (!oneTool.name.equals(string)) continue;
            return oneTool;
        }
        throw new Exception(string + " tool not found");
    }

    void removeHost(String string) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + string, "Confirm Dialog", 0) != 0) {
            return;
        }
        String string2 = "Starter/" + string;
        String string3 = "dserver/" + string2;
        String string4 = AstorUtil.getStarterDeviceHeader() + string;
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string4);
            deviceProxy.delete_property("StartDsPath");
            deviceProxy.delete_property("HostCollection");
            deviceProxy.delete_property("HostUsage");
            deviceProxy.delete_property("UseEvents");
            Database database = ApiUtil.get_db_obj((String)AstorUtil.getTangoHost());
            database.delete_server(string2);
            database.delete_device(string4);
            database.delete_device(string3);
            JOptionPane.showMessageDialog(this, string + " has been removed !", "Command Done", 1);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot remove host", (DevFailed)devFailed);
        }
        try {
            this.buildTree();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void newHostBtnActionPerformed(ActionEvent actionEvent) {
        this.addNewHost(null);
    }

    void addNewHost(TangoHost tangoHost) {
        NewStarterDialog newStarterDialog = new NewStarterDialog(this, tangoHost, this.tree.getCollectionList(), this.tree.hosts, true);
        newStarterDialog.setVisible(true);
        if (newStarterDialog.getValue() == 0) {
            try {
                this.buildTree();
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    void editHostProperties(TangoHost tangoHost) {
        NewStarterDialog newStarterDialog = new NewStarterDialog(this, tangoHost, this.tree.getCollectionList(), this.tree.hosts, false);
        newStarterDialog.setVisible(true);
    }

    private void stopServersBtnActionPerformed(ActionEvent actionEvent) {
        new ServerCmdThread(this, this.tree.hosts, 1).start();
    }

    private void startServersBtnActionPerformed(ActionEvent actionEvent) {
        new ServerCmdThread(this, this.tree.hosts, 0).start();
    }

    private void newBranchBtnActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
        if (string != null) {
            this.tree.addBranch(string);
        }
    }

    private void helpActionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem == this.principleBtn) {
            Utils.popupMessage(this, "", "principle.gif");
        } else if (jMenuItem == this.distributionBtn) {
            new HostsScanThread(this, this.tree.hosts).start();
        } else if (jMenuItem == this.stateIconsBtn) {
            Utils.popupMessage(this, "", "astor_state_icons.gif");
        } else if (jMenuItem == this.releaseNoteBtn) {
            new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML><HEAD><Title> Release Note </Title></HEAD><BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\"><P><!-------TITLE------></P><Center>\t<h2>Astor Release Notes</h2>(Generated Wed Jan 27 07:30:19 CET 2016)</Center><br><br><li><b>Astor-6.7.0 -  25/01/16:</li></b>\tStarter domain name could be set with a class property.<br><br><li><b>Astor-6.6.6 -  30/06/15:</li></b>\tJava-7 compatibility.<br>\tManage polling for Tango-9 feature.<br>\tImprove Tango release for servers.<br>\tAdd a compatibility to read JTango release.<br>\tUpdate file headers.<br><br><li><b>Astor-6.6.5 -  08/01/15:</li></b>\tImprove Server Usage utility<br><br><li><b>Astor-6.6.4 -  08/01/15:</li></b>\tImprove the statup level change.<br><br><li><b>Astor-6.6.3 -  17/12/14:</li></b>\tSeveral invokeLater() methods added.<br><br><li><b>Astor-6.6.2 -  18/11/14:</li></b>\tULong management added to event tester.<br><br><li><b>Astor-6.6.1 -  04/11/14:</li></b>\tFaulty host list added to help menu.<br><br><li><b>Astor-6.6.0 -  01/10/14:</li></b>\tServer Tango release manage Tango-9 and IDL5<br><br><li><b>Astor-6.5.1 -  05/08/14:</li></b>\tImprove Last Branches management.<br><br><li><b>Astor-6.5.0 -  19/04/14:</li></b>\tManage OFF state for Starter devices.<br>\tImprove DbPollPanel class.<br><br><li><b>Astor-6.4.6 -  29/01/14:</li></b>\tPackage ctrl_system_info added to the jar file.<br><br><li><b>Astor-6.4.5 -  10/01/14:</li></b>\tFix a problem on starter properties (HostUsage and Family)<br>\tClean compilation warnings.<br><br><li><b>Astor-6.4.3 -  07/01/14:</li></b>\tRemove warning on tools launch.<br><br><li><b>Astor-6.4.2 -  29/10/13:</li></b>\tTry to fix infinite ping loop.<br><br><li><b>Astor-6.4.1 -  25/10/13:</li></b>\tReplace dancers by official Tango logo.<br>\tCleanup part of code.<br><br><li><b>Astor-6.4.0 -  24/09/13:</li></b>\tFix a problem in Tango releases help.<br>\tfix a problem on resize with java-7<br><br><li><b>Astor-6.3.9 -  30/08/13:</li></b>\tFix problem in pool threads management using new syntax.<br>\tImprove sort methods.<br>\tServerStatePanel is now an astor.tools class (not from tool_panels package)<br><br><li><b>Astor-6.3.7 -  09/08/13:</li></b>\tImprove UnAvailableHostsDialog class.<br><br><li><b>Astor-6.3.6 -  12/06/13:</li></b>\tServer list to be started can now be taken from another host.<br><br><li><b>Astor-6.3.5 -  28/05/13:</li></b>\tUpdate splash screen with new logos.<br><br><li><b>Astor-6.3.4 -  16/05/13:</li></b>\tMinor changes.<br><br><li><b>Astor-6.3.3 -  30/04/13:</li></b>\tAdd a tool to export server from database to another one.<br><br><li><b>Astor-6.3.2 -  03/04/13:</li></b>\tAdd a display for statistics reset by host.<br><br><li><b>Astor-6.3.1 -  19/03/13:</li></b>\tFix a problem when starter is killed.<br><br><li><b>Astor-6.3.0 -  06/03/13:</li></b>\timplement READ_ONLY, DB_READ_ONLY, READ_WRITE modes.<br><br><li><b>Astor-6.2.2 -  21/01/13:</li></b>\tFix a bug in adding item on TAC<br><br><li><b>Astor-6.2.1 -  14/01/13:</li></b>\tPb on notif icon fixed.<br><br><li><b>Astor-6.2.0 -  07/01/13:</li></b>\tGroup management added on TAC panel.<br><br><li><b>Astor-6.1.2 -  26/10/12:</li></b>\tFix a problem when too much devices in SubDevices.<br><br><li><b>Astor-6.1.1 -  26/10/12:</li></b>\tHostInfoDialog can be run in stand alone.<br><br><li><b>Astor-6.1.0 -  24/10/12:</li></b>\tTango release for servers tool added.<br><br><li><b>Astor-6.0.6 -  09/10/12:</li></b>\tPb with back slash fixed (?)<br><br><li><b>Astor-6.0.5 -  21/08/12:</li></b>\tOpen Jive on a selected server.<br><br><li><b>Astor-6.0.4 -  24/05/12:</li></b>\tDistribution release.<br><br><li><b>Astor-6.0.3 -  05/04/12:</li></b>\tAdd a control system name management.<br>\tUser preferences for tango host list added.<br><br><li><b>Astor-6.0.1 -  02/04/12:</li></b>\tProblem when removing server info fixed.<br><br><li><b>Astor-6.0.0 -  08/02/12:</li></b>\tComptibility with TangORB-8.x (ZMQ event system or supposed to be).<br><br><li><b>Astor-5.5.4 -  06/12/11:</li></b>\tCreate a Thread to update splash screen (to boost startup).<br><br><li><b>Astor-5.5.3 -  07/09/11:</li></b>\tServerUsage tool added.<br><br><li><b>Astor-5.5.2 -  26/07/11:</li></b>\tStatistics on one host added.<br><br><li><b>Astor-5.5.1 -  12/04/11:</li></b>\tAuto start info added to statistics tool.<br><br><li><b>Astor-5.5.0 -  01/04/11:</li></b>\tStatistics tools added.<br><br><li><b>Astor-5.4.1 -  14/03/11:</li></b>\tPb on TangoHost.getFamily() (if not defined) fixed.<br><br><li><b>Astor-5.4.0 -  11/02/11:</li></b>\tPb with TAC when adding addresses on \"All Users\" fixed.<br>\tNo reference on app_util classes any more.<br>\tChange splash screen image.<br><br><li><b>Astor-5.3.7 -  24/01/11:</li></b>\tConstructor added.<br><br><li><b>Astor-5.3.6 -  13/01/11:</li></b>\tPb on black box reader thread fixed.<br><br><li><b>Astor-5.3.5 -  10/01/11:</li></b>\tTAC is now displayed as database servers.<br>\tStartServersAtStarteup starter class property management added.<br>\tDisplay access mode in Tango Access panel.<br><br><li><b>Astor-5.3.4 -  04/01/11:</li></b>\tDo not try to subscribe on Starter events if starter device not exported.<br><br><li><b>Astor-5.3.3 -  21/12/10:</li></b>\tLittle tool to un-export devices registred on unreachable hosts added.<br><br><li><b>Astor-5.3.2 -  16/12/10:</li></b>\tAdd a password for AccessControl tool.<br><br><li><b>Astor-5.3.1 -  02/12/10:</li></b>\tConstructors added in  PoolThreadsManager to be launched from Jive.<br><br><li><b>Astor-5.3.0 -  30/11/10:</li></b>\tFor multi servers command, if the command is done through the starter,<br>\tit is done by a thread and a delay has been added between servers.<br><br><li><b>Astor-5.2.11 -  29/11/10:</li></b>\tMulti servers command added.<br>\tUptime for servers added.<br><br><li><b>Astor-5.2.10 -  08/10/10:</li></b>\tChange default view in Polling Profiler.<br><br><li><b>Astor-5.2.9 -  01/09/10:</li></b>\tMinor change (traces removed and added).<br><br><li><b>Astor-5.2.8 -  17/06/10:</li></b>\tPb on display startup level dialog in case of many devices fixed.<br><br><li><b>Astor-5.2.7 -  17/06/10:</li></b>\tStart new server can take several servers (multiple selection).<br><br><li><b>Astor-5.2.6 -  04/06/10:</li></b>\tGlobal command to change startup level added.<br><br><li><b>Astor-5.2.5 -  08/04/10:</li></b>\tMinor bugs fixed.<br><br><li><b>Astor-5.2.4 -  05/01/10:</li></b>\tBest management of subscribe error window at startup.<br><br><li><b>Astor-5.2.3 -  18/08/09:</li></b>\tBug in Device Dependencies fixed (infinite loop)<br><br><li><b>Astor-5.2.2 -  02/06/09:</li></b>\tBug on host.check_notifyd fixed.<br><br><li><b>Astor-5.2.1 -  15/05/09:</li></b>\tRemove serialization between HostStateThread and HostInfoDialogVector.<br><br><li><b>Astor-5.2.0 -  18/04/09:</li></b>\tTango-7 tools accessible.<br>\tDevice dependencies (sub-devices) tool added.<br>\tMySqlUtil feature added.<br><br><li><b>Astor-5.1.3 -  30/01/09:</li></b>\tBlack box management added for database.<br>\tBlack box management tool improved.<br>\tFind TANGO object by filter added.<br><br><li><b>Astor-5.1.2 -  16/01/09:</li></b>\tBlack box management added for host and Server.<br>\tStarter logging display added for host and server.<br>\tSplash screen use ATK one.<br><br><li><b>Astor-5.1.1 -  17/12/08:</li></b>\tAdd a scroll pane in HostInfoDialog in case of too big dialog.<br><br><li><b>Astor-5.1.0 -  09/10/08:</li></b>\tPool thread management added but not accessible.<br>\tNew version and tests for access.<br><br><li><b>Astor-5.0.5 -  12/09/08:</li></b>\tBug in server info (if not running) fixed.<br><br><li><b>Astor-5.0.4 -  16/06/08:</li></b>\tLevel trees are now displayed on 2 rows.<br><br><li><b>Astor-5.0.3 -  22/05/08:</li></b>\tHost info dialog servers are managed in a jtree.<br><br><li><b>Astor-5.0.2 -  07/05/08:</li></b>\tHost info dialog line management changed.<br>\tBrowse Database option added in DB popup menu.<br><br><li><b>Astor-5.0.1 -  10/04/08:</li></b>\tBranch info modified.<br>\tTable of hosts and servers added.<br><br><li><b>Astor-5.0.0 -  27/03/08:</li></b>\tCompatibility with Starter 4.0 and after only !<br>\tBetter management of server list.<br>\tServer state MOVING managed.<br>\tHard kill added on servers.<br>\tNew features on polling profiler.<br><br><li><b>Astor-4.5.7 -  12/12/07:</li></b>\tReset buttons added in event configuration panel.<br><br><li><b>Astor-4.5.6 -  07/11/07:</li></b>\tDisplay host info if OSManage DS  is running on host.<br>\tDisplay host's state on HotInfoDialog.<br><br><li><b>Astor-4.5.5 -  11/09/07:</li></b>\tDb attribute polling panel added.<br>\tBug on repeate error window when refresh tree fixed.<br><br><li><b>Astor-4.5.4  -  04/09/07:</li></b>\tSet attribute polled names in lower case in new starter creation.<br><br><li><b>Astor-4.5.3  -  20/08/07: </li></b>\tServStatePanel added on HostInfoDialog (Check states option).<br><br><li><b>Astor-4.5.2  -  27/04/07: </li></b>\tDisplay host panel available for stopped server from Device Browser.<br><br><li><b>Astor-4.5.1  -  04/04/07: </li></b>\tDatabase attribute properties editor added.<br><br><li><b>Astor-4.5.0  -  27/03/07:</li></b>\tPreferences dialog added.<br><br><li><b>Astor-4.4.4  -  08/03/07:</li></b>\tLastCollections property is managed.<br><br><li><b>Astor-4.4.3  -  22/01/07:</li></b>\tRemove watch dog on host thread.<br><br><li><b>Astor-4.4.2  -  17/01/07:</li></b>\tHtml helps added.<br>    Startup error message added in view menu.<br><br><li><b>Astor-4.4.1  -  08/01/07:</li></b>\tDisable Start Server button if Starter is MOVING.<br><br><li><b>Astor-4.4.0  -  25/09/06:</li></b>\tAccess control tool added.<br><br><li><b>Astor-4.3.2:</li></b>\tBug fixed in miscellaneous host collection.<br><br><li><b>Astor-4.3.1:</li></b>\tMoving state added for collection.<br>    In StartAll command a sleep(500) has been added between two hosts.<br><br><li><b>Astor-4.3.0:</li></b>\tMoving state added for startup phase.<br><br><li><b>Astor-4.2.3:</li></b>\tHost info panel modified to use icons.<br><br><li><b>Astor-4.2.2:</li></b>\tBackward compatibilty for jive fixed.<br><br><li><b>Astor-4.2.1:</li></b>\tIcons have been changed.<br>\tSome minor changes.<br><br><li><b>Astor-4.2.0:</li></b>\tPolling profiler added.<br><br><li><b>Astor-4.1.4:</li></b>\tOpen/Save menu added on event tester window.<br><br><li><b>Astor-4.1.3:</li></b>\tHistory added on event management.<br>    The maximum servers displayed in horizontal on HostInfoDialog window has been set to 5.<br><br><li><b>Astor-4.1.2:</li></b>\tBug fixed in Device browser in member device name.<br><br><li><b>Astor-4.1.1:</li></b>\tChange TANGO_HOST added (needs TangORB-4.7.7 or later).<br><br><li><b>Astor-4.1.0:</li></b>\tDevBrowser and MkStarter utilities added.<br><br><li><b>Astor-4.0.9:</li></b>\tMinor changes for EventTester compatibility<br><br><li><b>Astor-4.0.8:</li></b>\tScreen position modified for dialogs.<br><br><li><b>Astor-4.0.7:</li></b>\tSearch if host already exist before creation.<br><br><li><b>Astor-4.0.6:</li></b>\tSearch by host name added.<br><br><li><b>Astor-4.0.5:</li></b>\tCan change memorized attribute value.<br><br><li><b>Astor-4.0.4:</li></b>\tBug in server architecture fixed.<br><br><li><b>Astor-4.0.3:</li></b>\tMinor changes, RemoteCmd property added.<br><br><li><b>Astor-4.0.2:</li></b>\tServer architecture display addded.<br><br><li><b>Astor-4.0.1:</li></b>\tDevWizard calls addded.<br><br><li><b>Astor-4.0.0:</li></b>\tPossibility to controle two database servers added.<br>");
        } else if (jMenuItem == this.tangorbBtn) {
            this.displayTangORBversion();
        } else if (jMenuItem == this.aboutBtn) {
            this.displayAboutAstor();
        } else if (jMenuItem == this.starterEventsItem) {
            this.displaySubscribedHostList(true);
        } else if (jMenuItem == this.starterNoEventsItem) {
            this.displaySubscribedHostList(false);
        } else {
            Utils.popupMessage(this, "Not implemented yet !");
        }
    }

    private void displayTangORBversion() {
        Object object;
        String string;
        int n = 400;
        int n2 = 200;
        if (jarUsed == 0) {
            string = JTangoVersion.getInstance().toString();
            object = JTangoVersion.getInstance().getJarFileName();
            int n3 = ((String)object).length() * 9;
            if (n3 > n) {
                n = n3;
            }
        } else {
            try {
                object = new TangORBversion();
            }
            catch (Exception exception) {
                ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TangORB revision", (Exception)exception);
                return;
            }
            string = ((TangORBversion)object).jarfile + ":\n\n" + object;
        }
        object = new PopupText((Frame)this, true);
        ((PopupText)object).setFont(new Font("Courier", 1, 14));
        ((PopupText)object).show(string, n, n2);
        AstorUtil.centerDialog((JDialog)object, this);
    }

    private void displayAboutAstor() {
        String string = "           Astor  (Tango Manager) \n\nThis programme is used to control, start and stop\n           the TANGO device servers. \n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
        Utils.popupMessage(this, string, "TangoClass.gif");
    }

    /*
     * WARNING - void declaration
     */
    private void displaySubscribedHostList(boolean bl) {
        void var3_7;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TangoHost tangoHost : this.tree.hosts) {
            if (bl) {
                if (!tangoHost.onEvents) continue;
                arrayList.add(tangoHost.getName() + " " + tangoHost.eventSource);
                continue;
            }
            if (tangoHost.onEvents) continue;
            arrayList.add(tangoHost.getName());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList.size() == 0) {
            String string = "There is no host controlled " + TangoHost.controlMethod(bl);
        } else if (arrayList.size() == this.tree.hosts.length) {
            String string = "All hosts are controlled " + TangoHost.controlMethod(bl);
        } else {
            String string = "On " + this.tree.hosts.length + " hosts,\n" + arrayList.size() + "  are controlled " + TangoHost.controlMethod(bl);
            for (String string2 : arrayList) {
                stringBuilder.append(string2).append('\n');
            }
        }
        if (stringBuilder.length() == 0) {
            Utils.popupMessage(this, (String)var3_7);
        } else {
            PopupText popupText = new PopupText((Frame)this, true);
            popupText.setTitle((String)var3_7);
            popupText.addText(stringBuilder.toString());
            popupText.setSize(360, 400);
            popupText.setVisible(true);
        }
    }

    private void expandBtnActionPerformed(ActionEvent actionEvent) {
        this.expanded = !this.expanded;
        this.tree.expand(this.expanded);
        if (this.expanded) {
            this.expandBtn.setText("Collapse Tree");
        } else {
            this.expandBtn.setText("Expand Tree");
        }
    }

    private void deviceBrowserBtnActionPerformed(ActionEvent actionEvent) {
        if (dev_browser == null) {
            dev_browser = new DevBrowser(this);
        }
        dev_browser.setVisible(true);
    }

    private void refreshBtnActionPerformed(ActionEvent actionEvent) {
        try {
            this.buildTree();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.doExit();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doExit();
    }

    private void findObjectByFilterItemActionPerformed(ActionEvent actionEvent) {
        if (this.wide_search_dlg == null) {
            this.wide_search_dlg = new WideSearchDialog(this);
        }
        this.wide_search_dlg.setVisible(true);
    }

    private void multiServersCmdItemActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.multiServerCommand == null) {
                this.multiServerCommand = new MultiServerCommand(this);
            }
            this.multiServerCommand.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void statisticsBtnActionPerformed(ActionEvent actionEvent) {
        StatisticsPanel statisticsPanel = new StatisticsPanel(this);
        statisticsPanel.readAndDisplayStatistics(null);
        statisticsPanel.setVisible(true);
    }

    private void serverUsageMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            new ServerUsageDialog(this).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void faultyListItemhelpActionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TangoHost tangoHost : this.tree.hosts) {
            if (tangoHost.state != 1) continue;
            stringBuilder.append(tangoHost.getName()).append('\n');
        }
        PopupText popupText = new PopupText((Frame)this, true);
        popupText.setTitle("Faulty host list");
        popupText.addText(stringBuilder.toString());
        popupText.setSize(360, 400);
        popupText.setVisible(true);
    }

    private void stopThreads() {
        System.out.println("Astor exiting....");
        if (this.tree != null && this.tree.hosts != null) {
            for (TangoHost tangoHost : this.tree.hosts) {
                tangoHost.stopThread();
                if (!tangoHost.onEvents) continue;
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        System.out.println(" ");
    }

    public void doExit() {
        if (dev_browser != null && dev_browser.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(false);
            this.stopThreads();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-ro")) {
                System.out.println("Astor is in READ_ONLY mode !!!");
                rwMode = 2;
            } else if (stringArray[0].equals("-db_ro")) {
                System.out.println("Astor is in DB_READ_ONLY mode !!!");
                rwMode = 1;
            } else if (stringArray[0].equals("-rw")) {
                System.out.println("Astor is in READ_WRITE mode !!!");
                rwMode = 0;
            } else {
                try {
                    new AstorCmdLine(stringArray);
                }
                catch (DevFailed devFailed) {
                    Except.print_exception((Exception)((Object)devFailed));
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                }
                System.exit(0);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                try {
                    Astor astor = new Astor();
                    astor.setVisible(true);
                    displayed = true;
                }
                catch (DevFailed devFailed) {
                    System.err.println(devFailed.errors[0].desc);
                    if (devFailed.errors[0].desc.indexOf("Controlled access service defined in Db but unreachable") > 0) {
                        devFailed.errors[0].desc = "Controlled access service defined in Db but unreachable\nAstor cannot be configured from database !";
                    }
                    ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
                    System.exit(-1);
                }
                catch (InternalError internalError) {
                    System.err.println(internalError.getMessage());
                }
                catch (HeadlessException headlessException) {
                    System.err.println(headlessException.getMessage());
                }
                long l2 = System.currentTimeMillis();
                System.out.println("Build  GUI :" + (l2 - l) + " ms");
            }
        });
    }

    static {
        rwMode = 0;
        searched_host = "";
    }

    class HostsScanThread
    extends Thread {
        private JFrame parent;
        private TangoHost[] hosts;

        HostsScanThread(JFrame jFrame, TangoHost[] tangoHostArray) {
            this.parent = jFrame;
            this.hosts = tangoHostArray;
        }

        @Override
        public void run() {
            String[][] stringArray = new String[this.hosts.length][];
            String string = "Scanning hosts...";
            Monitor monitor = new Monitor(this.parent, string);
            double d = 0.01;
            monitor.setProgressValue(d, "Starting...");
            try {
                HostsScanThread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                String[] stringArray2;
                int n = 0;
                for (int i = 0; i < this.hosts.length; ++i) {
                    d = (1.0 + 1.0 * (double)i) / (double)this.hosts.length;
                    monitor.setProgressValue(d, "Reading " + this.hosts[i].getName());
                    stringArray2 = this.hosts[i].getServerAttribute();
                    stringArray[i] = new String[2];
                    stringArray[i][0] = this.hosts[i].getName();
                    stringArray[i][1] = "" + stringArray2.length;
                    n += stringArray2.length;
                }
                String string2 = n + " servers   on " + this.hosts.length + " hosts";
                stringArray2 = new String[]{"Names", "Nb Servers"};
                PopupTable popupTable = new PopupTable(this.parent, string2, stringArray2, stringArray);
                popupTable.setColumnWidth(new int[]{200, 100});
                popupTable.setVisible(true);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"", (DevFailed)devFailed);
            }
        }
    }
}

