/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.PipeInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskPipeNode
extends TangoNode {
    private Database db;
    private String devName;
    private List<PipeInfo> pipeInfo;

    TaskPipeNode(Database database, String string) {
        this.db = database;
        this.devName = string;
        this.pipeInfo = null;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.pipeicon;
    }

    @Override
    public String toString() {
        return "Pipe config";
    }

    @Override
    String getTitle() {
        return "Pipe configuration";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    int getAttributeNumber() {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.size();
    }

    String getAttName(int n) {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.get(n).getName();
    }

    String getLabel(int n) {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.get(n).getLabel();
    }

    void setLabel(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setLabel(string);
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetDisplay(int n) {
        this.resetLDisplay(n);
    }

    void resetLDisplay(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setLabel("Not specified");
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULDisplay(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setLabel("");
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULDisplay(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setLabel("NaN");
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getDescription(int n) {
        if (this.pipeInfo == null) {
            this.browsePipeInfo();
        }
        return this.pipeInfo.get(n).getDescription();
    }

    void setDescription(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setDescription(string);
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetDescription(int n) {
        this.resetLDescription(n);
    }

    void resetLDescription(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setDescription("Not specified");
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULDescription(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setDescription("");
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULDescription(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo.get(n).setDescription("NaN");
            deviceProxy.setPipeConfig(this.pipeInfo);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void browsePipeInfo() {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.pipeInfo = deviceProxy.getPipeConfig();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        if (this.pipeInfo == null) {
            this.pipeInfo = new List<PipeInfo>(){

                @Override
                public int size() {
                    return 0;
                }

                @Override
                public boolean isEmpty() {
                    return true;
                }

                @Override
                public boolean contains(Object object) {
                    return false;
                }

                @Override
                public Iterator<PipeInfo> iterator() {
                    return null;
                }

                @Override
                public Object[] toArray() {
                    return new Object[0];
                }

                @Override
                public <T> T[] toArray(T[] TArray) {
                    return null;
                }

                @Override
                public boolean add(PipeInfo pipeInfo) {
                    return false;
                }

                @Override
                public boolean remove(Object object) {
                    return false;
                }

                @Override
                public boolean containsAll(Collection<?> collection) {
                    return false;
                }

                @Override
                public boolean addAll(Collection<? extends PipeInfo> collection) {
                    return false;
                }

                @Override
                public boolean addAll(int n, Collection<? extends PipeInfo> collection) {
                    return false;
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    return false;
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    return false;
                }

                @Override
                public void clear() {
                }

                @Override
                public PipeInfo get(int n) {
                    return null;
                }

                @Override
                public PipeInfo set(int n, PipeInfo pipeInfo) {
                    return null;
                }

                @Override
                public void add(int n, PipeInfo pipeInfo) {
                }

                @Override
                public PipeInfo remove(int n) {
                    return null;
                }

                @Override
                public int indexOf(Object object) {
                    return 0;
                }

                @Override
                public int lastIndexOf(Object object) {
                    return 0;
                }

                @Override
                public ListIterator<PipeInfo> listIterator() {
                    return null;
                }

                @Override
                public ListIterator<PipeInfo> listIterator(int n) {
                    return null;
                }

                @Override
                public List<PipeInfo> subList(int n, int n2) {
                    return null;
                }
            };
        }
    }

    public void restartDevice() {
        try {
            DbDevImportInfo dbDevImportInfo = this.db.import_device(this.devName);
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
            DeviceData deviceData = new DeviceData();
            deviceData.insert(this.devName);
            deviceProxy.command_inout("DevRestart", deviceData);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }
}

