/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.util.StringTokenizer;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class PogoParser {
    private String fileCode;
    private String filename;
    static final String start_protected = "PROTECTED REGION ID(";
    static final String start_protected_enabled = "ENABLED START";
    static final String end_protected = "PROTECTED REGION END";

    public PogoParser(String filename) throws PogoException {
        this.filename = filename;
        this.fileCode = ParserTool.readFile(filename);
    }

    public void write() throws PogoException {
        ParserTool.writeFile(this.filename, this.fileCode);
    }

    public boolean codeExists(String code) {
        return this.fileCode.contains(code);
    }

    public void insertInProtectedZone(String className, String method, String code) {
        this.insertInProtectedZone(className, method, code, "::");
    }

    public void insertInProtectedZone(String className, String method, String code, String separator) {
        int[] indexes;
        if (code == null || code.length() == 0) {
            return;
        }
        String this_protected = start_protected;
        if (className != null && className.length() > 0) {
            this_protected = String.valueOf(this_protected) + className + separator;
        }
        if ((indexes = this.indexesOfProtectedZone(this_protected = String.valueOf(this_protected) + method + ") " + start_protected_enabled)) != null) {
            this.fileCode = String.valueOf(this.fileCode.substring(0, indexes[1]).trim()) + '\n' + code + '\n' + this.fileCode.substring(indexes[1]);
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void replaceInProtectedZone(String className, String method, String code, String separator) {
        if (code == null || code.length() == 0) {
            return;
        }
        StringBuilder thisProtected = new StringBuilder(start_protected);
        if (className != null && className.length() > 0) {
            thisProtected.append(className).append(separator);
        }
        thisProtected.append(method).append(") ").append(start_protected_enabled);
        int[] indexes = this.indexesOfProtectedZone(thisProtected.toString());
        if (indexes != null) {
            this.fileCode = String.valueOf(this.fileCode.substring(0, indexes[0]).trim()) + '\n' + code + this.fileCode.substring(indexes[1]);
        } else {
            System.err.println(thisProtected + " not found");
        }
    }

    public void insertInProtectedZoneAtEnd(String classname, String method, String code) {
        if (code == null || code.length() == 0) {
            return;
        }
        String this_protected = start_protected + classname + "::" + method + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes != null) {
            int pos = indexes[1];
            if (pos > 0) {
                this.fileCode = String.valueOf(this.fileCode.substring(0, pos)) + '\n' + code + '\n' + this.fileCode.substring(indexes[1]);
            }
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void removeProtectedZone(String classname, String method) {
        String this_protected = start_protected + classname + "::" + method + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes != null) {
            this.fileCode = String.valueOf(this.fileCode.substring(0, indexes[0])) + this.fileCode.substring(indexes[1]);
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void removeProtectedZoneAtEnd(String classname, String method, String start_rem) {
        String this_protected = start_protected + classname + "::" + method + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes != null) {
            int pos = this.fileCode.indexOf(start_rem, indexes[0]);
            if (pos > 0) {
                this.fileCode = String.valueOf(this.fileCode.substring(0, pos)) + this.fileCode.substring(indexes[1]);
            }
        } else {
            System.err.println(String.valueOf(this_protected) + " not found");
        }
    }

    public void insertIncludeFiles(String code) {
        int start = this.fileCode.indexOf("#include");
        int end = this.fileCode.indexOf(end_protected, start);
        end = this.fileCode.lastIndexOf(10, end);
        this.fileCode = String.valueOf(this.fileCode.substring(0, start)) + code + this.fileCode.substring(end);
    }

    public void insertAdditionalMethodPrototypes(String classname, String code) {
        this.insertInProtectedZone(classname, "Additional Method prototypes", code);
    }

    public void insertAdditionalClasses(String classname, String code) {
        this.insertInProtectedZone(classname, "Additional Classes Definitions", code);
    }

    public void insertAdditionalClassDefs(String classname, String code) {
        this.insertInProtectedZone(classname, "Additional Class Declarations", code);
    }

    public void addObjFiles(String objFiles) throws PogoException {
        if (this.fileCode.indexOf(objFiles) > 0) {
            return;
        }
        int start = this.fileCode.indexOf("SHLIB_OBJS =");
        if (start < 0) {
            return;
        }
        start = this.fileCode.substring(0, start).trim().length();
        this.fileCode = String.valueOf(this.fileCode.substring(0, start)) + objFiles + this.fileCode.substring(start);
        this.write();
    }

    private int[] indexesOfProtectedZone(String this_protected) {
        int start = this.fileCode.indexOf(this_protected);
        if (start < 0) {
            System.err.println(String.valueOf(this_protected) + " not found !");
            return null;
        }
        int end = this.fileCode.indexOf(end_protected, start = this.fileCode.indexOf(10, start) + 1);
        if (end < 0) {
            System.err.println("No end of protected zone for " + this_protected + " not found !");
            return null;
        }
        end = this.fileCode.lastIndexOf(10, end);
        return new int[]{start, end};
    }

    public String getProtectedCode(String key) {
        String this_protected = start_protected + key + ") " + start_protected_enabled;
        int[] indexes = this.indexesOfProtectedZone(this_protected);
        if (indexes == null) {
            return "";
        }
        return this.fileCode.substring(indexes[0], indexes[1]);
    }

    public String getDeletedObjectsCode(String comment) {
        int start = this.fileCode.lastIndexOf(comment);
        if (start > 0) {
            if (comment.startsWith("def ")) {
                start = this.fileCode.lastIndexOf("\n", start);
            } else {
                int start2 = this.fileCode.lastIndexOf("//-----", start = this.fileCode.lastIndexOf("/**", start));
                if (start2 >= 0) {
                    start = start2;
                }
            }
            int end = this.fileCode.indexOf(end_protected, start);
            end = this.fileCode.indexOf("}", end);
            end = this.fileCode.indexOf("\n", end) + 1;
            return this.commentCode(this.fileCode.substring(start, end));
        }
        System.out.println(String.valueOf(comment) + "\tNOT FOUND !!!");
        return null;
    }

    private String commentCode(String code) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(code, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.contains(start_protected) || line.contains(end_protected)) continue;
            sb.append("// ").append(line).append("\n");
        }
        return sb.toString();
    }

    public void insertDeletedObjectsCode(String code) {
        int pos = this.fileCode.lastIndexOf(end_protected);
        pos = this.fileCode.lastIndexOf("\n", pos);
        this.fileCode = String.valueOf(this.fileCode.substring(0, pos)) + code + this.fileCode.substring(pos);
    }

    public String toString() {
        return this.fileCode;
    }
}

