/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PipeDialog
extends JDialog {
    private JFrame parent;
    private int returnValue = 0;
    private Pipe pipe;
    private JTextArea descriptionText;
    private JRadioButton expertBtn;
    private JTextField labelText;
    private JTextField nameText;
    private JLabel titleLabel;
    private JRadioButton writableBtn;
    private static int[] columnSize = new int[]{120, 150, 40, 80, 400};
    private static String[] columnTitle = new String[]{"Name", "Label", "Writable", "Level", "Description"};

    public PipeDialog(JFrame jFrame, Pipe pipe) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.pipe = pipe;
        this.initComponents();
        this.titleLabel.setText("Pipe definition");
        if (pipe != null) {
            this.nameText.setText(pipe.getName());
            if (Utils.isSet(pipe.getLabel())) {
                this.labelText.setText(pipe.getLabel());
            }
            if (Utils.isSet(pipe.getDescription())) {
                this.descriptionText.setText(pipe.getDescription());
            }
            if (Utils.isSet(pipe.getDisplayLevel())) {
                this.expertBtn.setSelected(pipe.getDisplayLevel().contains("EXPERT"));
            } else {
                this.expertBtn.setSelected(false);
            }
            if (Utils.isSet(pipe.getRwType())) {
                this.writableBtn.setSelected(pipe.getRwType().contains("WRITE"));
            }
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.nameText = new JTextField();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descriptionText = new JTextArea();
        JLabel jLabel3 = new JLabel();
        this.labelText = new JTextField();
        this.writableBtn = new JRadioButton();
        this.expertBtn = new JRadioButton();
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PipeDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setFont(new Font("Dialog", 1, 18));
        jLabel.setText("Pipe name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.nameText.setColumns(15);
        this.nameText.setFont(new Font("Dialog", 1, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel2.add((Component)this.nameText, gridBagConstraints);
        jLabel2.setFont(new Font("Dialog", 1, 14));
        jLabel2.setText("Description :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(350, 100));
        this.descriptionText.setColumns(80);
        this.descriptionText.setRows(20);
        jScrollPane.setViewportView(this.descriptionText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        jLabel3.setFont(new Font("Dialog", 1, 14));
        jLabel3.setText("Pipe Label:");
        jLabel3.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.labelText.setColumns(15);
        this.labelText.setFont(new Font("Dialog", 1, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        jPanel2.add((Component)this.labelText, gridBagConstraints);
        this.writableBtn.setFont(new Font("Dialog", 1, 14));
        this.writableBtn.setText("Writable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 3);
        jPanel2.add((Component)this.writableBtn, gridBagConstraints);
        this.expertBtn.setFont(new Font("Dialog", 1, 14));
        this.expertBtn.setText("Expert Only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 3);
        jPanel2.add((Component)this.expertBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PipeDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PipeDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.nameText.getText().trim().isEmpty()) {
                throw new PogoException("Pipe name ?");
            }
            String string = Utils.checkNameSyntax(this.nameText.getText(), "name", false);
            this.nameText.setText(string);
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
            return;
        }
        this.returnValue = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public Pipe getPipe() {
        this.pipe = OAWutils.factory.createPipe();
        this.pipe.setName(this.nameText.getText().trim());
        this.pipe.setLabel(this.labelText.getText().trim());
        this.pipe.setDescription(this.descriptionText.getText().trim());
        if (this.writableBtn.isSelected()) {
            this.pipe.setRwType("READ_WRITE");
        } else {
            this.pipe.setRwType("READ");
        }
        if (this.expertBtn.isSelected()) {
            this.pipe.setDisplayLevel("EXPERT");
        } else {
            this.pipe.setDisplayLevel("OPERATOR");
        }
        return this.pipe;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    public static void popupSummary(JFrame jFrame, ArrayList<Pipe> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = PipeDialog.buildSummary(arrayList);
        String string = Integer.toString(arrayList.size()) + "  Pipes";
        PopupTable popupTable = new PopupTable(jFrame, string, columnTitle, arrayList2);
        int n = arrayList.size();
        if (n > 35) {
            n = 35;
        }
        popupTable.setPreferredSize(columnSize, n);
        popupTable.setVisible(true);
    }

    private static ArrayList<ArrayList<String>> buildSummary(ArrayList<Pipe> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        for (Pipe pipe : arrayList) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(pipe.getName());
            arrayList3.add(pipe.getLabel());
            arrayList3.add("" + pipe.getRwType().contains("WRITE"));
            arrayList3.add(pipe.getDisplayLevel());
            arrayList3.add(Utils.strReplace(pipe.getDescription(), "\\n", "\n"));
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }
}

