/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class EnumDialog
extends JDialog {
    private ArrayList<JTextField> textFields = new ArrayList();
    private int returnValue = 0;
    private EnumPopupMenu menu = new EnumPopupMenu();
    private static final int nbLines = 20;
    private static final char[] authorizedChars = new char[]{' ', '*', '/', '+', '-', '.', '=', '%', '>', '<'};
    private JPanel centerPanel;
    private JLabel titleLabel;
    private static final int INSERT_ROW = 0;
    private static final int REMOVE_ROW = 1;
    private static final int RESET = 2;
    private static final int HELP = 3;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Insert row", "Remove row", "Reset all rows", "Help on syntax"};

    public EnumDialog(JDialog jDialog, String string, String[] stringArray) {
        super((Dialog)jDialog, true);
        int n;
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        for (n = 0; n < 20; ++n) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            this.centerPanel.add((Component)new JLabel("  " + n + "  "), gridBagConstraints);
            JTextField jTextField = new JTextField();
            jTextField.setColumns(20);
            gridBagConstraints.gridx = 1;
            this.centerPanel.add((Component)jTextField, gridBagConstraints);
            this.textFields.add(jTextField);
            jTextField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    EnumDialog.this.treeMouseClicked(mouseEvent);
                }
            });
        }
        if (stringArray != null) {
            for (n = 0; n < this.textFields.size() && n < stringArray.length; ++n) {
                this.textFields.get(n).setText(stringArray[n].trim());
            }
        }
        this.titleLabel.setText(string);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 4) == 0) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object instanceof JTextField) {
            JTextField jTextField = (JTextField)object;
            this.menu.showMenu(mouseEvent, jTextField);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.centerPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel();
        JButton jButton2 = new JButton();
        JLabel jLabel2 = new JLabel();
        JButton jButton3 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EnumDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        jButton.setText("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnumDialog.this.helpButtonActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jLabel.setText("              ");
        jPanel2.add(jLabel);
        jButton2.setText("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnumDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        jLabel2.setText("              ");
        jPanel2.add(jLabel2);
        jButton3.setText("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnumDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton3);
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
    }

    private boolean isAuthorized(char c) {
        for (char c2 : authorizedChars) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    public void checkNameSyntax(String string) throws PogoException {
        if (string == null || string.isEmpty()) {
            throw new PogoException("Enumeration (" + string + ") not valid !");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        string = "";
        for (String string2 : arrayList) {
            string = string + string2;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z' || this.isAuthorized(c)) continue;
            throw new PogoException("Syntax error in enumeration: Do not use '" + c + "' char.");
        }
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        String[] stringArray;
        for (String string : stringArray = this.getEnumLabels()) {
            try {
                this.checkNameSyntax(string);
            }
            catch (PogoException pogoException) {
                pogoException.popup(this);
                return;
            }
        }
        this.returnValue = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        this.displayHelp();
    }

    private void displayHelp() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Authorized char to define an enum:\n");
        stringBuilder.append("  - letters\n").append("  - digits\n");
        for (char c : authorizedChars) {
            stringBuilder.append("  - '").append(c).append("'\n");
        }
        JOptionPane.showMessageDialog(this, stringBuilder.toString());
    }

    private void resetFields() {
        for (JTextField jTextField : this.textFields) {
            jTextField.setText("");
        }
    }

    public String[] getEnumLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (JTextField jTextField : this.textFields) {
            String string = jTextField.getText().trim();
            if (string.isEmpty()) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public static String label2enum(String string) {
        return Utils.strReplace(string.toUpperCase(), " ", "_");
    }

    public static String enum2toolTip(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder("enum {\n");
        for (String string : stringArray) {
            stringBuilder.append("\t").append(EnumDialog.label2enum(string)).append(",\n");
        }
        stringBuilder.append("}");
        return Utils.buildToolTip(stringBuilder.toString());
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    private int getSelectedTextIndex(JTextField jTextField) {
        for (int i = 0; i < this.textFields.size(); ++i) {
            if (this.textFields.get(i) != jTextField) continue;
            return i;
        }
        return 0;
    }

    private void insertRow(JTextField jTextField) {
        int n;
        String string = "";
        for (int i = n = this.getSelectedTextIndex(jTextField); i < this.textFields.size(); ++i) {
            String string2 = this.textFields.get(i).getText();
            this.textFields.get(i).setText(string);
            string = string2;
        }
    }

    private void removeRow(JTextField jTextField) {
        int n;
        for (int i = n = this.getSelectedTextIndex(jTextField); i < this.textFields.size() - 1; ++i) {
            this.textFields.get(i).setText(this.textFields.get(i + 1).getText());
        }
        this.textFields.get(this.textFields.size() - 1).setText("");
    }

    private class EnumPopupMenu
    extends JPopupMenu {
        private JTextField textField;
        private JLabel title = new JLabel();

        private EnumPopupMenu() {
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EnumPopupMenu.this.menuActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent, JTextField jTextField) {
            this.textField = jTextField;
            String string = jTextField.getText().isEmpty() ? "index " + EnumDialog.this.getSelectedTextIndex(jTextField) : jTextField.getText();
            this.title.setText(string);
            this.show(jTextField, mouseEvent.getX(), mouseEvent.getY());
        }

        private void menuActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    EnumDialog.this.insertRow(this.textField);
                    break;
                }
                case 1: {
                    EnumDialog.this.removeRow(this.textField);
                    break;
                }
                case 2: {
                    EnumDialog.this.resetFields();
                    break;
                }
                case 3: {
                    EnumDialog.this.displayHelp();
                }
            }
        }
    }
}

