/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.DeletedObjects;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.OldPogoModel;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.RenamedObjects;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.ProtectedAreaManager;
import org.tango.pogo.pogo_gui.tools.Utils;

public class DeviceClass {
    private OldPogoModel old_pogo_class = null;
    private PogoDeviceClass pogoClass = null;
    private ArrayList<DeviceClass> ancestors = new ArrayList();
    private static final String defaultInheritanceStart = "Device_";
    private static final String defaultInheritanceEnd = "Impl";
    private static final String defaultInheritance = "Device_Impl";
    private ArrayList<String> parentClasses = new ArrayList();

    public DeviceClass() {
        this.pogoClass = OAWutils.factory.createPogoDeviceClass();
        this.pogoClass.setDescription(OAWutils.factory.createClassDescription());
        this.pogoClass.getDescription().getInheritances().add(DeviceClass.getDefaultInheritance());
    }

    public DeviceClass(String string, DeviceClass deviceClass) {
        this.pogoClass = OAWutils.factory.createPogoDeviceClass();
        this.pogoClass.setDescription(OAWutils.factory.createClassDescription());
        this.pogoClass.setName(string);
        EList<Inheritance> eList = this.pogoClass.getDescription().getInheritances();
        if (eList.size() == 0) {
            eList.add(DeviceClass.getDefaultInheritance());
        }
        if (deviceClass != null) {
            Inheritance inheritance = OAWutils.factory.createInheritance();
            inheritance.setClassname(deviceClass.pogoClass.getName());
            inheritance.setSourcePath(deviceClass.pogoClass.getDescription().getSourcePath());
            eList.add(0, inheritance);
        }
    }

    public DeviceClass(String string) throws PogoException {
        this(string, true);
    }

    public DeviceClass(String string, boolean bl) throws PogoException {
        if (string.endsWith(".xmi")) {
            this.pogoClass = OAWutils.getInstance().loadDeviceClassModel(string);
            EList<Inheritance> eList = this.pogoClass.getDescription().getInheritances();
            if (eList.size() == 0) {
                eList.add(DeviceClass.getDefaultInheritance());
            }
            String string2 = Utils.getPath(string);
            this.pogoClass.getDescription().setSourcePath(string2);
            Utils.getInstance().stopSplashRefresher();
            if (bl && !this.loadInheritanceClasses()) {
                throw new PogoException("CANCEL");
            }
        } else {
            String string3 = ParserTool.readFile(string);
            if (!string3.contains("This file is generated by POGO")) {
                throw new PogoException("The file has not been generated by Pogo or too much modified by hand\n    (" + string + ")\n");
            }
            this.old_pogo_class = new OldPogoModel(string);
            this.pogoClass = this.old_pogo_class.getPogoDeviceClass();
        }
        DeviceClass.checkIfAbstractClass(this.pogoClass, true);
    }

    public static boolean isDefaultInheritance(Inheritance inheritance) {
        if (inheritance.getClassname() == null) {
            return true;
        }
        return inheritance.getClassname().startsWith(defaultInheritanceStart) && inheritance.getClassname().endsWith(defaultInheritanceEnd);
    }

    public static Inheritance getDefaultInheritance() {
        Inheritance inheritance = OAWutils.factory.createInheritance();
        inheritance.setClassname(defaultInheritance);
        inheritance.setSourcePath("");
        return inheritance;
    }

    public ArrayList<String> getAbstractAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EList<Attribute> eList = this.pogoClass.getAttributes();
        for (Attribute attribute : eList) {
            if (Utils.isTrue(attribute.getStatus().getConcrete()) || Utils.isTrue(attribute.getStatus().getConcreteHere())) continue;
            arrayList.add(attribute.getName());
        }
        return arrayList;
    }

    public ArrayList<String> getAbstractCommandNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EList<Command> eList = this.pogoClass.getCommands();
        for (Command command : eList) {
            if (Utils.isTrue(command.getStatus().getConcrete()) || Utils.isTrue(command.getStatus().getConcreteHere())) continue;
            arrayList.add(command.getName());
        }
        return arrayList;
    }

    public boolean checkIfAbstractClass() {
        return DeviceClass.checkIfAbstractClass(this.pogoClass, false);
    }

    public static boolean checkIfAbstractClass(PogoDeviceClass pogoDeviceClass, boolean bl) {
        EList<Command> eList = pogoDeviceClass.getCommands();
        EList<Attribute> eList2 = pogoDeviceClass.getAttributes();
        if (bl) {
            pogoDeviceClass.getDescription().setHasAbstractCommand("false");
            pogoDeviceClass.getDescription().setHasAbstractAttribute("false");
            for (Command eObject : eList) {
                if (eObject.getStatus() == null || Utils.isTrue(eObject.getStatus().getConcrete()) || Utils.isTrue(eObject.getStatus().getConcreteHere())) continue;
                pogoDeviceClass.getDescription().setHasAbstractCommand("true");
            }
            for (Attribute attribute : eList2) {
                if (attribute.getStatus() == null || Utils.isTrue(attribute.getStatus().getConcrete()) || Utils.isTrue(attribute.getStatus().getConcreteHere())) continue;
                pogoDeviceClass.getDescription().setHasAbstractAttribute("true");
            }
        }
        return Utils.isTrue(pogoDeviceClass.getDescription().getHasAbstractCommand()) || Utils.isTrue(pogoDeviceClass.getDescription().getHasAbstractAttribute());
    }

    public boolean isOldPogoModel() {
        return this.old_pogo_class != null;
    }

    public boolean isOldPogoModelAbstract() throws PogoException {
        if (this.old_pogo_class == null) {
            throw new PogoException("This class is not an old POGO model.");
        }
        return this.old_pogo_class.isAbsAbstract();
    }

    private String checkInheritanceFile(String string, String string2) throws PogoException {
        System.out.println("checkInheritanceFile for  " + string);
        if (new File(string).exists()) {
            return string;
        }
        String string3 = this.pogoClass.getDescription().getSourcePath();
        String string4 = Utils.getAbsolutePath(string, string3);
        System.out.println("Relative: " + string4);
        if (new File(string4).exists()) {
            return string4;
        }
        String string5 = InheritanceUtils.checkInheritanceFileFromEnv(string);
        if (string5 != null) {
            return string5;
        }
        if (!PogoGUI.useDisplay) {
            throw new PogoException(string + ": inheritance file not found");
        }
        JOptionPane.showMessageDialog(new JFrame(), string + "\nInheritance class Not Found !", "Error Window", 0);
        String string6 = this.pogoClass.getDescription().getSourcePath();
        JFileChooser jFileChooser = new JFileChooser(new File(string6).getAbsolutePath());
        PogoFileFilter pogoFileFilter = new PogoFileFilter("xmi", string2 + " class");
        jFileChooser.setFileFilter(pogoFileFilter);
        if (jFileChooser.showOpenDialog(new JFrame()) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file != null) {
                if (!file.isDirectory()) {
                    return file.getAbsolutePath();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private boolean loadInheritanceClasses() throws PogoException {
        try {
            EList<Inheritance> eList = this.pogoClass.getDescription().getInheritances();
            for (Inheritance inheritance : eList) {
                if (DeviceClass.isDefaultInheritance(inheritance)) continue;
                String string = inheritance.getClassname();
                String string2 = inheritance.getSourcePath() + System.getProperty("file.separator") + string + ".xmi";
                if ((string2 = this.checkInheritanceFile(string2, string)) == null) {
                    return false;
                }
                Utils.getInstance().startSplashRefresher("Loading  " + Utils.getRelativeFilename(string2));
                this.ancestors.add(new DeviceClass(string2, false));
                inheritance.setSourcePath(Utils.getPath(string2));
                Utils.getInstance().stopSplashRefresher();
            }
        }
        catch (PogoException pogoException) {
            if (PogoGUI.useDisplay) {
                Utils.getInstance().stopSplashRefresher();
                pogoException.popup(new JFrame());
            }
            throw pogoException;
        }
        catch (Exception exception) {
            if (PogoGUI.useDisplay) {
                Utils.getInstance().stopSplashRefresher();
                PogoException.popup((Component)new JFrame(), exception);
            }
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void removeInheritance() {
        EList<Inheritance> eList = this.pogoClass.getDescription().getInheritances();
        eList.clear();
        Inheritance inheritance = OAWutils.factory.createInheritance();
        inheritance.setClassname(DeviceClass.getDefaultInheritance().getClassname());
        inheritance.setSourcePath("");
        eList.add(inheritance);
        EList<Property> eList2 = this.pogoClass.getClassProperties();
        EList<Property> eList3 = this.pogoClass.getDeviceProperties();
        EList<Command> eList4 = this.pogoClass.getCommands();
        EList<Attribute> eList5 = this.pogoClass.getAttributes();
        EList<State> eList6 = this.pogoClass.getStates();
        for (Property eObject : eList2) {
            eObject.getStatus().setInherited("false");
        }
        for (Property property : eList3) {
            property.getStatus().setInherited("false");
        }
        for (Command command : eList4) {
            if (command.getName().equals("State") || command.getName().equals("Statuse")) continue;
            command.getStatus().setInherited("false");
        }
        for (Attribute attribute : eList5) {
            attribute.getStatus().setInherited("false");
        }
        for (State state : eList6) {
            state.getStatus().setInherited("false");
        }
    }

    public String getProjectFilename() {
        return this.pogoClass.getDescription().getSourcePath() + "/" + this.pogoClass.getName() + ".xmi";
    }

    public PogoDeviceClass getPogoDeviceClass() {
        return this.pogoClass;
    }

    public ArrayList<DeviceClass> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(ArrayList<DeviceClass> arrayList) {
        this.ancestors = arrayList;
    }

    public void addAncestor(DeviceClass deviceClass) {
        for (DeviceClass deviceClass2 : deviceClass.ancestors) {
            this.ancestors.add(deviceClass2);
            Inheritance inheritance = OAWutils.factory.createInheritance();
            inheritance.setClassname(deviceClass2.getPogoDeviceClass().getName());
            inheritance.setSourcePath(deviceClass2.getPogoDeviceClass().getDescription().getSourcePath());
            this.pogoClass.getDescription().getInheritances().add(inheritance);
        }
        this.ancestors.add(deviceClass);
        Inheritance inheritance = OAWutils.factory.createInheritance();
        inheritance.setClassname(deviceClass.getPogoDeviceClass().getName());
        inheritance.setSourcePath(deviceClass.getPogoDeviceClass().getDescription().getSourcePath());
        this.pogoClass.getDescription().getInheritances().add(inheritance);
    }

    public String getSourceFile(String string) {
        String string2 = System.getProperty("file.separator");
        String string3 = this.pogoClass.getDescription().getSourcePath() + string2;
        if (string.equals("cpp")) {
            return string3 + this.pogoClass.getName() + ".cpp";
        }
        if (string.equals("python")) {
            return string3 + this.pogoClass.getName() + ".py";
        }
        string3 = string3 + "org" + string2 + "tango" + string2 + this.pogoClass.getName().toLowerCase() + string2;
        return string3 + this.pogoClass.getName() + ".java";
    }

    public void generateWithNewName(String string, boolean bl, DeletedObjects deletedObjects, RenamedObjects renamedObjects) throws SecurityException, IOException, PogoException {
        String string2 = this.getPogoDeviceClass().getName();
        if (bl) {
            this.getPogoDeviceClass().getDescription().setFilestogenerate("XMI File, Code files");
            this.generate(deletedObjects, renamedObjects);
        }
        deletedObjects.clear();
        renamedObjects.clear();
        this.getPogoDeviceClass().setName(string);
        this.getPogoDeviceClass().getDescription().setFilestogenerate("XMI File, Code files");
        this.generate(new DeletedObjects(), new RenamedObjects());
        if (this.getPogoDeviceClass().getDescription().getLanguage().toLowerCase().equals("cpp")) {
            String[] stringArray;
            String string3 = this.getPogoDeviceClass().getDescription().getSourcePath();
            for (String string4 : stringArray = new String[]{".h", ".cpp", "Class.h", "Class.cpp", "StateMachine.cpp"}) {
                String string5 = string3 + "/" + string2 + string4;
                String string6 = string3 + "/" + string + string4;
                ProtectedAreaManager protectedAreaManager = new ProtectedAreaManager(string5);
                protectedAreaManager.setClassName(string, string6);
            }
            for (String string4 : stringArray) {
                if (new File(string3 + "/" + string2 + string4).delete()) continue;
                System.err.println("failed to delete" + string2 + string4);
            }
        }
    }

    public void generate(DeletedObjects deletedObjects, RenamedObjects renamedObjects) throws SecurityException, IOException, PogoException {
        String string = this.pogoClass.getName();
        String string2 = this.pogoClass.getDescription().getLanguage().toLowerCase();
        if (renamedObjects != null) {
            renamedObjects.readCode(string, this.getSourceFile(string2));
        }
        if (deletedObjects != null) {
            deletedObjects.readCode(this.getSourceFile(string2));
        }
        String string3 = this.pogoClass.getDescription().getSourcePath();
        EList<Inheritance> eList = this.pogoClass.getDescription().getInheritances();
        for (Inheritance inheritance : eList) {
            String string4 = inheritance.getSourcePath();
            if (string4 == null || string4.isEmpty()) continue;
            string4 = Utils.getRelativePath(string4, string3);
            inheritance.setSourcePath(string4);
            break;
        }
        OAWutils oAWutils = OAWutils.getInstance();
        oAWutils.generate(this.pogoClass);
        if (deletedObjects != null && deletedObjects.size() > 0) {
            deletedObjects.insertCode(this.getSourceFile(string2));
            System.out.println(this.getSourceFile(string2) + "  updated");
        }
        if (renamedObjects != null && renamedObjects.size() > 0) {
            renamedObjects.insertCode(string, this.getSourceFile(string2));
            System.out.println(this.getSourceFile(string2) + "  updated");
        }
    }

    public void generateDocFromOldModel(String string, String string2) throws PogoException {
        try {
            String string3 = Utils.getPath(string);
            string3 = string3 + "/" + PogoProperty.docHome + "/Description.html";
            if (string2 == null) {
                string2 = Utils.getPath(string3);
            }
            this.old_pogo_class.generateDocFromOldModel(string3, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof PogoException) {
                throw (PogoException)exception;
            }
            throw new PogoException(exception.toString());
        }
    }

    public void generateFromOldModel(String string, boolean bl) throws PogoException {
        try {
            String string2 = Utils.getPath(string);
            string2 = string2 + "/new_src";
            if (!new File(string2).exists() && !new File(string2).mkdir()) {
                throw new PogoException("Cannot create path: " + string2);
            }
            this.pogoClass.getDescription().setFilestogenerate("XMI file,Code files,Linux Makefile");
            this.pogoClass.getDescription().setSourcePath(string2);
            System.out.println("\n===============================================================\n\n");
            OAWutils.getInstance().generate(this.pogoClass);
            if (bl) {
                this.recoverCodeFromOldPogoModel();
            }
            this.old_pogo_class.swapDirectories(this.pogoClass);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof PogoException) {
                throw (PogoException)exception;
            }
            throw new PogoException(exception.toString());
        }
    }

    private void recoverCodeFromOldPogoModel() throws Exception {
        if (this.old_pogo_class == null) {
            throw new PogoException("This is not an old POGO model");
        }
        if (Utils.getLanguage(this.pogoClass.getDescription().getLanguage()) == 1) {
            this.old_pogo_class.recoverCppCodeFromOldPogoModel(this.pogoClass);
            this.old_pogo_class.manageCppAdditionalFiles(this.pogoClass);
        }
    }

    public void resetParentClasses() {
        this.parentClasses.clear();
    }

    public ArrayList<String> getParentClasses() {
        return this.parentClasses;
    }

    public void addParentClass(String string) {
        this.parentClasses.add(string);
    }

    public String toString() {
        if (this.pogoClass.getName() == null || this.pogoClass.getName().length() == 0) {
            return "This class";
        }
        return this.pogoClass.getName();
    }

    public static void main(String[] stringArray) {
        String string = "/segfs/tango/tools/pogo/test/cpp/test_oaw";
        String string2 = string + "/TestOaw.xmi";
        try {
            OAWutils oAWutils = OAWutils.getInstance();
            PogoDeviceClass pogoDeviceClass = oAWutils.loadDeviceClassModel(string2);
            System.err.println("\n\n\n");
            pogoDeviceClass.getDescription().setSourcePath(string);
            oAWutils.generate(pogoDeviceClass);
        }
        catch (PogoException pogoException) {
            System.err.println(pogoException.getMessage());
        }
    }
}

