/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.analysis.ActionFilterNFAProvider;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.ProductionFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class GrammarConstraintProvider
implements IGrammarConstraintProvider {
    protected static final ConstraintElement INVALID = new ConstraintElement();
    protected static final ConstraintElement TYPEMATCH = new ConstraintElement(){

        protected boolean isTypeMatch() {
            return true;
        }
    };
    protected static final ConstraintElement UNINTITIALIZED = new ConstraintElement();
    protected Map<Grammar, List<IGrammarConstraintProvider.IConstraintContext>> cache = Maps.newHashMap();
    @Inject
    protected Context2NameFunction context2Name;
    @Inject
    protected IContextProvider contextProvider;
    @Inject
    protected ActionFilterNFAProvider nfaProvider;

    protected ConstraintElement createConstraintElement(EObject context, AbstractElement ele, EClass requiredType, Set<Object> visited) {
        boolean isOptional = GrammarUtil.isOptionalCardinality(ele);
        if (ele instanceof Action) {
            if (requiredType == null) {
                return INVALID;
            }
            Action action = (Action)ele;
            if (action.getFeature() == null) {
                if (action.getType().getClassifier() == requiredType) {
                    return TYPEMATCH;
                }
                return isOptional ? null : INVALID;
            }
            new ConstraintElement(context, this.getConstraintElementType(ele), ele);
        } else {
            if (ele instanceof RuleCall) {
                RuleCall rc = (RuleCall)ele;
                if (GrammarUtil.isUnassignedEObjectRuleCall(rc)) {
                    if (!visited.add(rc)) {
                        return null;
                    }
                    ConstraintElement result = this.createConstraintElement((ParserRule)rc.getRule(), requiredType, visited);
                    if (result != null && result != INVALID) {
                        if (rc.getRule().getType().getClassifier() == requiredType) {
                            result.typeMatch();
                        }
                        if (result.isTypeMatch()) {
                            return result;
                        }
                    }
                    return isOptional ? null : INVALID;
                }
                if (GrammarUtil.containingAssignment(ele) != null) {
                    return new ConstraintElement(context, this.getConstraintElementType(ele), ele);
                }
                return null;
            }
            if (ele instanceof Keyword) {
                if (GrammarUtil.containingAssignment(ele) != null) {
                    return new ConstraintElement(context, this.getConstraintElementType(ele), ele);
                }
                return null;
            }
            if (ele instanceof Assignment) {
                if (requiredType == null) {
                    return INVALID;
                }
                Assignment ass = (Assignment)ele;
                ConstraintElement result = this.createConstraintElement(context, ass.getTerminal(), requiredType, visited);
                if (result != null && result != INVALID) {
                    result.setMany(result.isMany() || GrammarUtil.isMultipleCardinality(ele));
                    result.setOptional(result.isOptional() || GrammarUtil.isOptionalCardinality(ele));
                }
                return result;
            }
            if (ele instanceof CrossReference) {
                CrossReference cr = (CrossReference)ele;
                ConstraintElement result = this.createConstraintElement(context, cr.getTerminal(), requiredType, visited);
                if (result != null && result != INVALID) {
                    result.setMany(result.isMany() || GrammarUtil.isMultipleCardinality(ele));
                    result.setOptional(result.isOptional() || GrammarUtil.isOptionalCardinality(ele));
                }
                return result;
            }
            if (ele instanceof Alternatives) {
                ConstraintElement result;
                Alternatives alt = (Alternatives)ele;
                ArrayList<ConstraintElement> children = Lists.newArrayList();
                ArrayList<ConstraintElement> typeMatchChildren = Lists.newArrayList();
                boolean allInvalid = true;
                boolean nullExists = false;
                boolean typeMatch = false;
                for (AbstractElement ae : alt.getElements()) {
                    ConstraintElement ce = this.createConstraintElement(context, ae, requiredType, visited);
                    if (ce == INVALID) continue;
                    allInvalid = false;
                    if (ce != TYPEMATCH) {
                        if (ce != null) {
                            if (ce.isTypeMatch()) {
                                typeMatchChildren.add(ce);
                                continue;
                            }
                            children.add(ce);
                            continue;
                        }
                        nullExists = true;
                        continue;
                    }
                    typeMatch = true;
                }
                if (allInvalid) {
                    return isOptional ? null : INVALID;
                }
                if (typeMatch || !typeMatchChildren.isEmpty()) {
                    children = typeMatchChildren;
                    nullExists = typeMatch;
                }
                if (children.isEmpty()) {
                    return typeMatch ? TYPEMATCH : null;
                }
                if (children.size() == 1) {
                    result.setMany((result = (ConstraintElement)children.get(0)).isMany() || GrammarUtil.isMultipleCardinality(ele));
                    result.setOptional(result.isOptional() || nullExists || GrammarUtil.isOptionalCardinality(ele));
                    return result;
                }
                result.setOptional((result = new ConstraintElement(context, this.getConstraintElementType(ele), ele)).isOptional() || nullExists);
                for (ConstraintElement child : children) {
                    if (child.getType() == IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE && !child.isOptional() && !child.isMany()) {
                        result.addAllChilden(child);
                        continue;
                    }
                    result.addChild(child);
                }
                return result;
            }
            if (ele instanceof Group || ele instanceof UnorderedGroup) {
                ConstraintElement result;
                CompoundElement group = (CompoundElement)ele;
                ArrayList<ConstraintElement> children = Lists.newArrayList();
                boolean typeMatch = false;
                for (AbstractElement ae : group.getElements()) {
                    ConstraintElement ce = this.createConstraintElement(context, ae, requiredType, visited);
                    if (ce == INVALID && !ce.isOptional()) {
                        return isOptional ? null : INVALID;
                    }
                    if (ce != INVALID && ce != null && ce != TYPEMATCH) {
                        children.add(ce);
                        continue;
                    }
                    if (ce != TYPEMATCH) continue;
                    typeMatch = true;
                }
                if (children.isEmpty()) {
                    return typeMatch ? TYPEMATCH : null;
                }
                if (!(children.size() != 1 || ((ConstraintElement)children.get(0)).isOptional() && typeMatch)) {
                    result.setMany((result = (ConstraintElement)children.get(0)).isMany() || GrammarUtil.isMultipleCardinality(ele));
                    result.setOptional(result.isOptional() || GrammarUtil.isOptionalCardinality(ele));
                    if (typeMatch) {
                        result.typeMatch();
                    }
                    return result;
                }
                result = new ConstraintElement(context, this.getConstraintElementType(ele), ele);
                for (ConstraintElement child : children) {
                    if (child.getType() == IGrammarConstraintProvider.ConstraintElementType.GROUP && !child.isOptional() && !child.isMany()) {
                        result.addAllChilden(child);
                        continue;
                    }
                    result.addChild(child);
                }
                if (typeMatch) {
                    result.typeMatch();
                }
                return result;
            }
        }
        return null;
    }

    protected ConstraintElement createConstraintElement(EObject context, ActionFilterNFAProvider.ActionFilterState state, EClass requiredType, boolean allowLocal, Set<Object> visited) {
        ConstraintElement local;
        if (allowLocal && GrammarUtil.isAssignedAction(state.getGrammarElement())) {
            if (((Action)state.getGrammarElement()).getType().getClassifier() == requiredType) {
                ConstraintElement result = new ConstraintElement(context, IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_ACTION_CALL, state.getGrammarElement());
                result.typeMatch();
                return result;
            }
            return INVALID;
        }
        if (!visited.add(state)) {
            return INVALID;
        }
        List<ConstraintElement> followers = Lists.newArrayList();
        boolean allInvalid = true;
        boolean containsOne = false;
        boolean typematch = false;
        for (ActionFilterNFAProvider.ActionFilterTransition t : state.getAllOutgoing()) {
            if (t.isRuleCall()) continue;
            containsOne = true;
            ConstraintElement f = this.createConstraintElement(context, (ActionFilterNFAProvider.ActionFilterState)t.getTarget(), requiredType, true, visited);
            if (f == TYPEMATCH) {
                allInvalid = false;
                typematch = true;
                continue;
            }
            if (f == INVALID) continue;
            allInvalid = false;
            if (f == null) continue;
            followers.add(f);
        }
        if (containsOne && allInvalid) {
            return INVALID;
        }
        ConstraintElement constraintElement = local = allowLocal ? this.createConstraintElement(context, state.getGrammarElement(), requiredType, visited) : null;
        if (typematch && local != null) {
            local.typeMatch();
        }
        if (allowLocal && state.isEndState() && !GrammarUtil.isUnassignedEObjectRuleCall(state.getGrammarElement()) && GrammarUtil.containingRule(state.getGrammarElement()).getType().getClassifier() != requiredType && (local == null || !local.isTypeMatch())) {
            return INVALID;
        }
        if (local == INVALID && !GrammarUtil.isOptionalCardinality(state.getGrammarElement())) {
            return INVALID;
        }
        if (followers.isEmpty()) {
            return local == INVALID || local == null ? (typematch ? TYPEMATCH : null) : local;
        }
        if (local != INVALID && local != null) {
            int i = 0;
            while (i < followers.size()) {
                ConstraintElement follower = followers.get(i);
                if (follower.getType() == IGrammarConstraintProvider.ConstraintElementType.GROUP && !follower.isMany() && !follower.isOptional()) {
                    follower.addChild(local);
                } else {
                    ConstraintElement group = new ConstraintElement(context, IGrammarConstraintProvider.ConstraintElementType.GROUP);
                    group.addChild(follower);
                    group.addChild(local);
                    followers.set(i, group);
                }
                ++i;
            }
        }
        if ((followers = this.filterDuplicates(followers)).size() == 1) {
            return followers.get(0);
        }
        ConstraintElement alt = null;
        for (ConstraintElement f : followers) {
            if (f.getType() != IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE || f.isMany() || f.isOptional()) continue;
            alt = f;
            break;
        }
        if (alt != null) {
            followers.remove(alt);
        } else {
            alt = new ConstraintElement(context, IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE);
        }
        for (ConstraintElement f : followers) {
            alt.addChild(f);
        }
        return alt;
    }

    protected ConstraintElement createConstraintElement(ParserRule rule, EClass requiredType, Set<Object> visited) {
        if (!visited.add(rule)) {
            return INVALID;
        }
        if (GrammarUtil.containsAssignedAction(rule)) {
            ActionFilterNFAProvider.ActionFilterState start = (ActionFilterNFAProvider.ActionFilterState)this.nfaProvider.getNFA(rule.getAlternatives());
            return this.createConstraintElement(rule, start, requiredType, false, visited);
        }
        return this.createConstraintElement(rule, rule.getAlternatives(), requiredType, visited);
    }

    protected void filterDuplicateConstraintsAndSetNames(Grammar grammar, List<IGrammarConstraintProvider.IConstraintContext> contexts) {
        HashMap equalConstraints = Maps.newHashMap();
        for (IGrammarConstraintProvider.IConstraintContext context : contexts) {
            for (IGrammarConstraintProvider.IConstraint constraint : context.getConstraints()) {
                ArrayList<IGrammarConstraintProvider.IConstraint> same = (ArrayList<IGrammarConstraintProvider.IConstraint>)equalConstraints.get(constraint);
                if (same == null) {
                    same = Lists.newArrayList();
                    equalConstraints.put(constraint, same);
                }
                same.add(constraint);
            }
        }
        IdentityHashMap<IGrammarConstraintProvider.IConstraint, IGrammarConstraintProvider.IConstraint> allConstraints = Maps.newIdentityHashMap();
        for (Collection equal : equalConstraints.values()) {
            IGrammarConstraintProvider.IConstraint representative = this.findRepresentativeConstraint(equal);
            ((Constraint)representative).setName(this.findBestConstraintName(equal));
            for (IGrammarConstraintProvider.IConstraint constraint : equal) {
                allConstraints.put(constraint, representative);
            }
        }
        for (IGrammarConstraintProvider.IConstraintContext context : contexts) {
            int i = 0;
            while (i < context.getConstraints().size()) {
                IGrammarConstraintProvider.IConstraint replacement = (IGrammarConstraintProvider.IConstraint)allConstraints.get(context.getConstraints().get(i));
                context.getConstraints().set(i, replacement);
                ++i;
            }
            ((AbstractConstraintContext)context).initConstraints();
        }
    }

    protected List<ConstraintElement> filterDuplicates(List<ConstraintElement> list) {
        ArrayList<ConstraintElement> result = Lists.newArrayList();
        for (ConstraintElement ce : list) {
            boolean found = false;
            for (ConstraintElement r : result) {
                if (!ce.equals(r)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(ce);
        }
        return result;
    }

    protected Map<Grammar, Integer> getInheritanceDistance(Grammar grammar) {
        HashMap<Grammar, Integer> result = Maps.newHashMap();
        Grammar current = grammar;
        int distance = 0;
        while (current != null) {
            result.put(current, distance);
            current = current.getUsedGrammars().isEmpty() ? null : (Grammar)current.getUsedGrammars().get(0);
            ++distance;
        }
        return result;
    }

    protected void collectElements(IGrammarConstraintProvider.IConstraintElement ele, List<AbstractElement> result) {
        if (ele.getGrammarElement() != null) {
            result.add(ele.getGrammarElement());
        }
        if (ele.getChildren() != null) {
            for (IGrammarConstraintProvider.IConstraintElement e : ele.getChildren()) {
                this.collectElements(e, result);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String findBestConstraintName(Collection<IGrammarConstraintProvider.IConstraint> equalConstraints) {
        void var9_19;
        HashSet<ParserRule> relevantRules = Sets.newHashSet();
        HashSet<Action> relevantActions = Sets.newHashSet();
        HashSet<ParserRule> contextRules = Sets.newHashSet();
        for (IGrammarConstraintProvider.IConstraint c : equalConstraints) {
            for (EObject ctx : ((Constraint)c).getAllContext()) {
                if (!(ctx instanceof ParserRule)) continue;
                contextRules.add((ParserRule)ctx);
            }
        }
        ArrayList<AbstractElement> ele = Lists.newArrayList();
        IGrammarConstraintProvider.IConstraint first = equalConstraints.iterator().next();
        if (first.getBody() != null) {
            this.collectElements(first.getBody(), ele);
        }
        for (AbstractElement e : ele) {
            relevantRules.add(GrammarUtil.containingParserRule(e));
        }
        for (IGrammarConstraintProvider.IConstraint c : equalConstraints) {
            for (EObject eObject : ((Constraint)c).getAllContext()) {
                Action action;
                ParserRule rule;
                if (!(eObject instanceof Action) || contextRules.contains(rule = GrammarUtil.containingParserRule(action = (Action)eObject))) continue;
                relevantActions.add(action);
                relevantRules.add(rule);
            }
        }
        if (relevantRules.isEmpty()) {
            EClass type = first.getType();
            if (type != null) {
                for (ParserRule context : contextRules) {
                    for (Action a : GrammarUtil.containedActions(context)) {
                        if (a.getType().getClassifier() != type) continue;
                        relevantRules.add(context);
                    }
                }
                if (relevantRules.isEmpty()) {
                    for (ParserRule context : contextRules) {
                        if (context.getType().getClassifier() != type) continue;
                        relevantRules.add(context);
                    }
                }
            }
            if (relevantRules.isEmpty()) {
                relevantRules.addAll(contextRules);
            }
        }
        ArrayList<String> actions = Lists.newArrayList();
        ArrayList<String> rules = Lists.newArrayList();
        for (Action action : relevantActions) {
            actions.add(this.context2Name.getUniqueActionName(action));
        }
        for (ParserRule parserRule : relevantRules) {
            rules.add(this.context2Name.getContextName(parserRule));
        }
        Collections.sort(rules);
        String string = Joiner.on("_").join(rules);
        if (!actions.isEmpty()) {
            Collections.sort(actions);
            String string2 = String.valueOf(string) + "_" + Joiner.on('_').join(actions);
        }
        return var9_19;
    }

    protected IGrammarConstraintProvider.IConstraint findRepresentativeConstraint(Collection<IGrammarConstraintProvider.IConstraint> equalConstraints) {
        for (IGrammarConstraintProvider.IConstraint c : equalConstraints) {
            if (!(((Constraint)c).getMostSpecificContext() instanceof ParserRule)) continue;
            return c;
        }
        return equalConstraints.iterator().next();
    }

    protected IGrammarConstraintProvider.ConstraintElementType getConstraintElementType(AbstractElement ele) {
        if (ele instanceof Action) {
            if (((Action)ele).getFeature() != null) {
                return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_ACTION_CALL;
            }
        } else {
            if (ele instanceof Alternatives) {
                return IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE;
            }
            if (ele instanceof Group || ele instanceof UnorderedGroup) {
                return IGrammarConstraintProvider.ConstraintElementType.GROUP;
            }
            if (GrammarUtil.containingCrossReference(ele) != null) {
                if (ele instanceof RuleCall) {
                    RuleCall rc = (RuleCall)ele;
                    if (rc.getRule() instanceof ParserRule) {
                        return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_CROSSREF_DATATYPE_RULE_CALL;
                    }
                    if (rc.getRule() instanceof TerminalRule) {
                        return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_CROSSREF_TERMINAL_RULE_CALL;
                    }
                    if (rc.getRule() instanceof EnumRule) {
                        return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_CROSSREF_ENUM_RULE_CALL;
                    }
                } else if (ele instanceof Keyword) {
                    return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_CROSSREF_KEYWORD;
                }
            } else if (GrammarUtil.containingAssignment(ele) != null) {
                if (ele instanceof RuleCall) {
                    RuleCall rc = (RuleCall)ele;
                    if (rc.getRule() instanceof ParserRule) {
                        if (rc.getRule().getType().getClassifier() instanceof EClass) {
                            return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_PARSER_RULE_CALL;
                        }
                        return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_DATATYPE_RULE_CALL;
                    }
                    if (rc.getRule() instanceof TerminalRule) {
                        return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_TERMINAL_RULE_CALL;
                    }
                    if (rc.getRule() instanceof EnumRule) {
                        return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_ENUM_RULE_CALL;
                    }
                } else if (ele instanceof Keyword) {
                    return IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_KEYWORD;
                }
            }
        }
        throw new RuntimeException("Unknown Grammar Element: " + EmfFormatter.objPath(ele));
    }

    protected IGrammarConstraintProvider.IConstraintContext getConstraints(Action context) {
        AssignedActionConstraintContext result = new AssignedActionConstraintContext(context, this.context2Name.getContextName(context));
        ActionFilterNFAProvider.ActionFilterState start = (ActionFilterNFAProvider.ActionFilterState)this.nfaProvider.getNFA(context);
        Set<EClass> types = this.contextProvider.getTypesForContext(context);
        for (EClass type : types) {
            ActionConstraint constraint;
            if (type == null) {
                ActionConstraint constraint2 = new ActionConstraint(context, null, null, this);
                result.addConstraint(constraint2);
                continue;
            }
            ConstraintElement ce = this.createConstraintElement(context, start, type, false, Sets.<Object>newHashSet());
            if (ce == TYPEMATCH) {
                constraint = new ActionConstraint(context, type, null, this);
                result.addConstraint(constraint);
                continue;
            }
            if (ce != null && ce != INVALID) {
                constraint = new ActionConstraint(context, type, ce, this);
                result.addConstraint(constraint);
                continue;
            }
            System.err.println("constraint is " + ce + " for context " + this.context2Name.getContextName(context) + " and type " + type.getName());
        }
        return result;
    }

    @Override
    public List<IGrammarConstraintProvider.IConstraintContext> getConstraints(Grammar context) {
        List<IGrammarConstraintProvider.IConstraintContext> result = this.cache.get(context);
        if (result == null) {
            result = Lists.newArrayList();
            for (ParserRule parserRule : GrammarUtil.allParserRules(context)) {
                if (!(parserRule.getType().getClassifier() instanceof EClass)) continue;
                result.add(this.getConstraints(parserRule));
                for (Action action : GrammarUtil.containedActions(parserRule)) {
                    if (action.getFeature() == null) continue;
                    result.add(this.getConstraints(action));
                }
            }
            this.filterDuplicateConstraintsAndSetNames(context, result);
            this.cache.put(context, result);
        }
        return result;
    }

    protected IGrammarConstraintProvider.IConstraintContext getConstraints(ParserRule context) {
        ParserRuleConstraintContext result = new ParserRuleConstraintContext(context, this.context2Name.getContextName(context));
        Set<EClass> types = this.contextProvider.getTypesForContext(context);
        for (EClass type : types) {
            RuleConstraint constraint;
            if (type == null) {
                RuleConstraint constraint2 = new RuleConstraint(context, null, null, this);
                result.addConstraint(constraint2);
                continue;
            }
            ConstraintElement ce = this.createConstraintElement(context, type, Sets.<Object>newHashSet());
            if (ce == TYPEMATCH) {
                constraint = new RuleConstraint(context, type, null, this);
                result.addConstraint(constraint);
                continue;
            }
            if (ce != null && ce != INVALID) {
                constraint = new RuleConstraint(context, type, ce, this);
                result.addConstraint(constraint);
                continue;
            }
            System.err.println("constraint is " + ce + " for context " + this.context2Name.getContextName(context) + " and type " + type.getName());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractConstraintContext
    implements IGrammarConstraintProvider.IConstraintContext {
        protected List<IGrammarConstraintProvider.IConstraint> constraints = Lists.newArrayList();
        protected String name;

        private AbstractConstraintContext(String name) {
            this.name = name;
        }

        protected void addConstraint(Constraint constraint) {
            this.constraints.add(constraint);
        }

        @Override
        public List<IGrammarConstraintProvider.IConstraint> getConstraints() {
            return this.constraints;
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected void initConstraints() {
            Collections.sort(this.constraints, new Comparator<IGrammarConstraintProvider.IConstraint>(){

                @Override
                public int compare(IGrammarConstraintProvider.IConstraint o1, IGrammarConstraintProvider.IConstraint o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (IGrammarConstraintProvider.IConstraint ele : this.constraints) {
                ((Constraint)ele).initLists();
            }
        }

        public String toString() {
            Iterable<String> constraintNames = Iterables.transform(this.constraints, new Function<IGrammarConstraintProvider.IConstraint, String>(){

                @Override
                public String apply(IGrammarConstraintProvider.IConstraint from) {
                    return from.getName();
                }
            });
            return String.valueOf(this.getName()) + ": " + Joiner.on(" | ").join(constraintNames) + ";";
        }
    }

    protected static class ActionConstraint
    extends Constraint {
        protected Action actionContext;

        public ActionConstraint(Action context, EClass type, ConstraintElement body, GrammarConstraintProvider provider) {
            super(type, body, provider);
            this.actionContext = context;
        }

        protected EObject getMostSpecificContext() {
            return this.body == null ? this.actionContext : this.body.getContext();
        }
    }

    protected static class AssignedActionConstraintContext
    extends AbstractConstraintContext {
        protected Action action;

        public AssignedActionConstraintContext(Action action, String name) {
            super(name);
            this.action = action;
        }

        public EClass getCommonType() {
            return (EClass)this.action.getType().getClassifier();
        }

        public EObject getContext() {
            return this.action;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Constraint
    implements IGrammarConstraintProvider.IConstraint {
        protected IGrammarConstraintProvider.IConstraintElement[] assignments;
        protected ConstraintElement body;
        protected GrammarConstraintProvider provider;
        protected IGrammarConstraintProvider.IConstraintElement[] elements;
        protected IGrammarConstraintProvider.IFeatureInfo[] features;
        protected String name;
        protected EObject specificContext;
        protected EClass type;

        public Constraint(EClass type, ConstraintElement body, GrammarConstraintProvider provider) {
            this.type = type;
            this.body = body;
            if (this.body != null) {
                this.body.setContainingConstraint(this);
            }
        }

        protected void collectElements(ConstraintElement ele, List<IGrammarConstraintProvider.IConstraintElement> elements, List<IGrammarConstraintProvider.IConstraintElement> assignments, List<IGrammarConstraintProvider.IConstraintElement>[] assignmentsByFeature) {
            ele.setElementId(elements.size());
            elements.add(ele);
            switch (ele.getType()) {
                case ASSIGNED_ACTION_CALL: 
                case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
                case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
                case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
                case ASSIGNED_CROSSREF_KEYWORD: 
                case ASSIGNED_DATATYPE_RULE_CALL: 
                case ASSIGNED_ENUM_RULE_CALL: 
                case ASSIGNED_KEYWORD: 
                case ASSIGNED_PARSER_RULE_CALL: 
                case ASSIGNED_TERMINAL_RULE_CALL: {
                    EClass type = ele.getContainingConstraint().getType();
                    EStructuralFeature feature = type.getEStructuralFeature(ele.getFeatureName());
                    if (feature == null) {
                        throw new RuntimeException("Feature " + ele.getFeatureName() + " not found in " + type.getName());
                    }
                    int featureID = type.getFeatureID(feature);
                    List<IGrammarConstraintProvider.IConstraintElement> assignmentByFeature = assignmentsByFeature[featureID];
                    if (assignmentByFeature == null) {
                        assignmentsByFeature[featureID] = assignmentByFeature = Lists.newArrayList();
                    }
                    ele.setFeatureAssignmentId(assignmentByFeature.size());
                    assignmentByFeature.add(ele);
                    ele.setAssignmentId(assignments.size());
                    assignments.add(ele);
                    return;
                }
                case ALTERNATIVE: 
                case GROUP: {
                    for (IGrammarConstraintProvider.IConstraintElement e : ele.getChildren()) {
                        this.collectElements((ConstraintElement)e, elements, assignments, assignmentsByFeature);
                    }
                    return;
                }
            }
        }

        @Override
        public int compareTo(IGrammarConstraintProvider.IConstraint o) {
            return this.getName().compareTo(o.getName());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Constraint)) {
                return false;
            }
            Constraint c = (Constraint)obj;
            if (this.type != null && c.type != null) {
                if (!this.type.getName().equals(c.type.getName())) {
                    return false;
                }
                if (!this.type.getEPackage().getNsURI().equals(c.type.getEPackage().getNsURI())) {
                    return false;
                }
            } else if (this.type != null || c.type != null) {
                return false;
            }
            return this.body == null && c.body == null || this.body != null && this.body.equals(c.body);
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement[] getAssignments() {
            return this.assignments;
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement getBody() {
            return this.body;
        }

        protected Object getCacheKey() {
            return Tuples.create(this.body.getContext(), this.type);
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement[] getElements() {
            return this.elements;
        }

        @Override
        public IGrammarConstraintProvider.IFeatureInfo[] getFeatures() {
            return this.features;
        }

        protected abstract EObject getMostSpecificContext();

        protected Collection<EObject> getAllContext() {
            LinkedHashSet<EObject> result = Sets.newLinkedHashSet();
            result.add(this.getMostSpecificContext());
            this.collectContexts(this.body, result);
            return result;
        }

        protected void collectContexts(ConstraintElement ele, Set<EObject> result) {
            if (ele != null) {
                EObject context = ele.getContext();
                if (context != null) {
                    result.add(context);
                }
                if (ele.getChildren() != null) {
                    for (IGrammarConstraintProvider.IConstraintElement child : ele.getChildren()) {
                        this.collectContexts((ConstraintElement)child, result);
                    }
                }
            }
        }

        @Override
        public Iterable<IGrammarConstraintProvider.IFeatureInfo> getMultiAssignementFeatures() {
            ArrayList<IGrammarConstraintProvider.IFeatureInfo> result = Lists.newArrayList();
            IGrammarConstraintProvider.IFeatureInfo[] iFeatureInfoArray = this.features;
            int n = this.features.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IFeatureInfo info = iFeatureInfoArray[n2];
                if (info != null && info.getAssignments().length > 1) {
                    result.add(info);
                }
                ++n2;
            }
            return result;
        }

        @Override
        public String getName() {
            return String.valueOf(this.name) + "_" + (this.type == null ? "null" : this.type.getName());
        }

        @Override
        public String getSimpleName() {
            return this.name;
        }

        @Override
        public Iterable<IGrammarConstraintProvider.IFeatureInfo> getSingleAssignementFeatures() {
            ArrayList<IGrammarConstraintProvider.IFeatureInfo> result = Lists.newArrayList();
            IGrammarConstraintProvider.IFeatureInfo[] iFeatureInfoArray = this.features;
            int n = this.features.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IFeatureInfo info = iFeatureInfoArray[n2];
                if (info != null && info.getAssignments().length == 1) {
                    result.add(info);
                }
                ++n2;
            }
            return result;
        }

        @Override
        public EClass getType() {
            return this.type;
        }

        public int hashCode() {
            int result;
            int n = result = this.body == null ? 0 : this.body.hashCode();
            if (this.type != null) {
                result += 7 * this.type.getName().hashCode();
                result += 13 * this.type.getEPackage().getNsURI().hashCode();
            }
            return result;
        }

        protected void initLists() {
            ArrayList<IGrammarConstraintProvider.IConstraintElement> ele = Lists.newArrayList();
            ArrayList<IGrammarConstraintProvider.IConstraintElement> ass = Lists.newArrayList();
            List[] feat = new List[this.getType() == null ? 0 : this.getType().getFeatureCount()];
            if (this.body != null) {
                this.collectElements(this.body, ele, ass, feat);
            }
            this.elements = ele.toArray(new IGrammarConstraintProvider.IConstraintElement[ele.size()]);
            this.assignments = ass.toArray(new IGrammarConstraintProvider.IConstraintElement[ass.size()]);
            this.features = new IGrammarConstraintProvider.IFeatureInfo[feat.length];
            int i = 0;
            while (i < feat.length) {
                if (feat[i] != null) {
                    EStructuralFeature feature = this.getType().getEStructuralFeature(i);
                    IGrammarConstraintProvider.IConstraintElement[] fass = feat[i].toArray(new IGrammarConstraintProvider.IConstraintElement[feat[i].size()]);
                    this.features[i] = new FeatureInfo(this, feature, fass);
                }
                ++i;
            }
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String toString() {
            String typeName = this.getType() == null ? "null" : this.getType().getName();
            String body = this.getBody() != null ? this.getBody().toString() : "{" + typeName + "}";
            return String.valueOf(this.getName()) + " returns " + typeName + ": " + body + ";";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ConstraintElement
    implements IGrammarConstraintProvider.IConstraintElement {
        protected int assignmentId = -1;
        protected List<IGrammarConstraintProvider.IConstraintElement> children;
        protected List<IGrammarConstraintProvider.IConstraintElement> containedAssignments = null;
        protected ConstraintElement container;
        protected IGrammarConstraintProvider.IConstraint containingConstraint;
        protected EObject context;
        protected List<Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType>> dependingAssignments;
        protected AbstractElement element;
        protected URI elementURI;
        protected int elementId = -1;
        protected int featureAssignmentId = -1;
        protected IGrammarConstraintProvider.IFeatureInfo featureInfo;
        protected boolean many;
        protected boolean optional;
        protected IGrammarConstraintProvider.ConstraintElementType type;
        protected boolean typeMatch = false;

        protected ConstraintElement() {
        }

        protected ConstraintElement(EObject context, IGrammarConstraintProvider.ConstraintElementType type) {
            this(context, type, null, false, false);
        }

        protected ConstraintElement(EObject context, IGrammarConstraintProvider.ConstraintElementType type, AbstractElement element) {
            this(context, type, element, type != IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_ACTION_CALL && GrammarUtil.isMultipleCardinality(element), type != IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_ACTION_CALL && GrammarUtil.isOptionalCardinality(element));
        }

        protected ConstraintElement(EObject context, IGrammarConstraintProvider.ConstraintElementType type, AbstractElement element, boolean many, boolean optional) {
            this.context = context;
            this.type = type;
            this.element = element;
            this.many = many;
            this.optional = optional;
            if (type == IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE || type == IGrammarConstraintProvider.ConstraintElementType.GROUP) {
                this.children = Lists.newArrayList();
            }
        }

        protected void addAllChilden(ConstraintElement childrenOwner) {
            for (IGrammarConstraintProvider.IConstraintElement c : childrenOwner.children) {
                this.addChild((ConstraintElement)c);
            }
            childrenOwner.getChildren().clear();
            if (childrenOwner.isTypeMatch()) {
                this.typeMatch();
            }
        }

        protected void addChild(ConstraintElement child) {
            child.container = this;
            if (child == INVALID || child == TYPEMATCH) {
                throw new RuntimeException("This is not a valid child: '" + child + "'");
            }
            this.children.add(child);
            if (child.isTypeMatch()) {
                this.typeMatch();
            }
        }

        protected void collectDependingAssignmentsByContainer(IGrammarConstraintProvider.IConstraintElement child, List<Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType>> result, boolean childMany, boolean childOptional) {
            IGrammarConstraintProvider.IConstraintElement container = child.getContainer();
            if (container == null) {
                return;
            }
            boolean cntOptional = container.isOptionalRecursive(null);
            boolean cntMany = container.isManyRecursive(null);
            switch (container.getType()) {
                case ALTERNATIVE: {
                    if (container.isManyRecursive(null)) break;
                    for (IGrammarConstraintProvider.IConstraintElement choice : container.getChildren()) {
                        if (choice == child) continue;
                        for (IGrammarConstraintProvider.IConstraintElement ass : choice.getContainedAssignments()) {
                            result.add(Tuples.create(ass, IGrammarConstraintProvider.RelationalDependencyType.EXCLUDE_IF_SET));
                        }
                    }
                    break;
                }
                case GROUP: {
                    if (!cntOptional && !cntMany) {
                        return;
                    }
                    for (IGrammarConstraintProvider.IConstraintElement choice : container.getChildren()) {
                        if (choice == child) continue;
                        for (IGrammarConstraintProvider.IConstraintElement ass : choice.getContainedAssignments()) {
                            boolean assMany = ass.isManyRecursive(container);
                            boolean assOptional = ass.isOptionalRecursive(container);
                            boolean exclude_if_unset = !assOptional;
                            boolean mandatory_if_set = !childOptional;
                            boolean same = false;
                            boolean same_or_less = false;
                            boolean same_or_more = false;
                            if (cntMany) {
                                if (!(assMany || assOptional || childMany || childOptional)) {
                                    same = true;
                                } else if (childOptional && !childMany && !assOptional || !assOptional && !childMany && !assOptional && assMany) {
                                    same_or_less = true;
                                } else if (!childOptional && !childMany && assOptional && !assMany || !childOptional && childMany && !assOptional && !assMany || !childOptional && childMany && assOptional && !assMany) {
                                    same_or_more = true;
                                }
                            }
                            if (exclude_if_unset && !same_or_less && !same) {
                                result.add(Tuples.create(ass, IGrammarConstraintProvider.RelationalDependencyType.EXCLUDE_IF_UNSET));
                            }
                            if (mandatory_if_set && !same_or_more && !same) {
                                result.add(Tuples.create(ass, IGrammarConstraintProvider.RelationalDependencyType.MANDATORY_IF_SET));
                            }
                            if (same) {
                                result.add(Tuples.create(ass, IGrammarConstraintProvider.RelationalDependencyType.SAME));
                            }
                            if (same_or_less) {
                                result.add(Tuples.create(ass, IGrammarConstraintProvider.RelationalDependencyType.SAME_OR_LESS));
                            }
                            if (!same_or_more) continue;
                            result.add(Tuples.create(ass, IGrammarConstraintProvider.RelationalDependencyType.SAME_OR_MORE));
                        }
                    }
                    break;
                }
            }
            childMany = childMany || container.isMany();
            childOptional = childOptional || container.isOptional() || container.getType() == IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE;
            this.collectDependingAssignmentsByContainer(container, result, childMany, childOptional);
        }

        protected boolean containsChild(IGrammarConstraintProvider.IConstraintElement child) {
            if (this.children == null) {
                return false;
            }
            for (IGrammarConstraintProvider.IConstraintElement c : this.children) {
                if (!c.equals(child)) continue;
                return true;
            }
            return false;
        }

        protected String context2Name(EObject context) {
            return ((Constraint)this.getContainingConstraint()).provider.context2Name.apply(context);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConstraintElement)) {
                return false;
            }
            ConstraintElement ce = (ConstraintElement)obj;
            switch (this.type) {
                case ALTERNATIVE: {
                    if (this.children == null || ce.children == null || this.children.size() != ce.children.size()) {
                        return false;
                    }
                    for (IGrammarConstraintProvider.IConstraintElement child : this.children) {
                        if (ce.containsChild(child)) continue;
                        return false;
                    }
                    return true;
                }
                case GROUP: {
                    return this.children.equals(ce.children);
                }
            }
            return this.getElementURI().equals(ce.getElementURI());
        }

        protected IGrammarConstraintProvider.IConstraintElement findCommonContainer(List<IGrammarConstraintProvider.IConstraintElement> elements) {
            if (elements.size() == 0) {
                return null;
            }
            if (elements.size() == 1) {
                return elements.get(0);
            }
            IGrammarConstraintProvider.IConstraintElement result = elements.get(0);
            int i = 1;
            while (i < elements.size()) {
                boolean found = false;
                while (!found && result != null) {
                    IGrammarConstraintProvider.IConstraintElement cand = elements.get(i);
                    while (!found && cand != null) {
                        if (cand == result) {
                            found = true;
                            continue;
                        }
                        cand = cand.getContainer();
                    }
                    if (found) continue;
                    result = result.getContainer();
                }
                ++i;
            }
            return result;
        }

        @Override
        public Action getAction() {
            return this.element instanceof Action ? (Action)this.element : null;
        }

        @Override
        public int getAssignmentID() {
            return this.assignmentId;
        }

        protected String getAssignmentOperator() {
            if (this.element instanceof Action) {
                return ((Action)this.element).getOperator();
            }
            Assignment ass = GrammarUtil.containingAssignment(this.element);
            if (ass != null) {
                return ass.getOperator();
            }
            return null;
        }

        @Override
        public EObject getCallContext() {
            switch (this.type) {
                case ASSIGNED_ACTION_CALL: {
                    return this.getAction();
                }
                case ASSIGNED_PARSER_RULE_CALL: {
                    return this.getRuleCall().getRule();
                }
            }
            return null;
        }

        @Override
        public String getCardinality() {
            return this.isMany() ? (this.isOptional() ? "*" : "+") : (this.isOptional() ? "?" : "");
        }

        @Override
        public List<IGrammarConstraintProvider.IConstraintElement> getChildren() {
            return this.children;
        }

        @Override
        public List<IGrammarConstraintProvider.IConstraintElement> getContainedAssignments() {
            if (this.containedAssignments == null) {
                this.containedAssignments = Lists.newArrayList();
                if (this.assignmentId >= 0) {
                    this.containedAssignments.add(this);
                }
                if (this.getChildren() != null) {
                    for (IGrammarConstraintProvider.IConstraintElement child : this.getChildren()) {
                        this.containedAssignments.addAll(child.getContainedAssignments());
                    }
                }
            }
            return this.containedAssignments;
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement getContainer() {
            return this.container;
        }

        @Override
        public IGrammarConstraintProvider.IConstraint getContainingConstraint() {
            if (this.containingConstraint == null) {
                this.containingConstraint = this.getContainer().getContainingConstraint();
            }
            return this.containingConstraint;
        }

        protected EObject getContext() {
            return this.context;
        }

        @Override
        public CrossReference getCrossReference() {
            if (this.element == null) {
                return null;
            }
            return GrammarUtil.containingCrossReference(this.element);
        }

        @Override
        public EClass getCrossReferenceType() {
            if (this.element == null) {
                return null;
            }
            CrossReference cr = GrammarUtil.containingCrossReference(this.element);
            if (cr == null) {
                return null;
            }
            return (EClass)cr.getType().getClassifier();
        }

        @Override
        public List<Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType>> getDependingAssignment() {
            if (this.assignmentId < 0) {
                return null;
            }
            if (this.dependingAssignments == null) {
                this.dependingAssignments = Lists.newArrayList();
                this.collectDependingAssignmentsByContainer(this, this.dependingAssignments, this.isMany(), this.isOptional());
            }
            return this.dependingAssignments;
        }

        @Override
        public int getElementID() {
            return this.elementId;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.getFeatureInfo().getFeature();
        }

        @Override
        public int getFeatureAssignmentID() {
            return this.featureAssignmentId;
        }

        @Override
        public IGrammarConstraintProvider.IFeatureInfo getFeatureInfo() {
            return this.featureInfo;
        }

        protected String getFeatureName() {
            if (this.element instanceof Action) {
                return ((Action)this.element).getFeature();
            }
            Assignment ass = GrammarUtil.containingAssignment(this.element);
            if (ass != null) {
                return ass.getFeature();
            }
            return null;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.element;
        }

        @Override
        public Keyword getKeyword() {
            return this.element instanceof Keyword ? (Keyword)this.element : null;
        }

        @Override
        public RuleCall getRuleCall() {
            return this.element instanceof RuleCall ? (RuleCall)this.element : null;
        }

        @Override
        public IGrammarConstraintProvider.ConstraintElementType getType() {
            return this.type;
        }

        protected URI getElementURI() {
            if (this.elementURI == null) {
                this.elementURI = this.element == null ? URI.createURI("null") : EcoreUtil.getURI(this.element);
            }
            return this.elementURI;
        }

        public int hashCode() {
            switch (this.type) {
                case ALTERNATIVE: {
                    int result = 0;
                    for (IGrammarConstraintProvider.IConstraintElement child : this.children) {
                        result += child.hashCode();
                    }
                    return result;
                }
                case GROUP: {
                    int result = 0;
                    int i = 0;
                    while (i < this.children.size()) {
                        result += this.children.get(i).hashCode() + i;
                        ++i;
                    }
                    return result;
                }
            }
            return this.getElementURI().hashCode();
        }

        @Override
        public boolean isCardinalityOneAmongAssignments(List<IGrammarConstraintProvider.IConstraintElement> assignments) {
            if (assignments.size() < 2) {
                return false;
            }
            IGrammarConstraintProvider.IConstraintElement commonContainer = this.findCommonContainer(assignments);
            return commonContainer.getType() != IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE && !this.isOptionalRecursive(commonContainer) && !this.isManyRecursive(commonContainer);
        }

        @Override
        public boolean isMany() {
            return this.many;
        }

        @Override
        public boolean isManyRecursive(IGrammarConstraintProvider.IConstraintElement root) {
            return this.isMany() || this.container != null && this.container != root && this.container.isManyRecursive(root);
        }

        @Override
        public boolean isOptional() {
            return this.optional && !this.typeMatch;
        }

        @Override
        public boolean isOptionalRecursive(IGrammarConstraintProvider.IConstraintElement root) {
            if (this.isOptional()) {
                return true;
            }
            if (this.getContainer() != root) {
                if (this.getContainer().getType() == IGrammarConstraintProvider.ConstraintElementType.ALTERNATIVE) {
                    return true;
                }
                if (this.getContainer().isOptionalRecursive(root)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isRoot() {
            return this.container == null;
        }

        protected boolean isTypeMatch() {
            return this.typeMatch;
        }

        protected void setAssignmentId(int id) {
            this.assignmentId = id;
        }

        protected void setContainingConstraint(IGrammarConstraintProvider.IConstraint containingConstraint) {
            this.containingConstraint = containingConstraint;
        }

        protected void setElementId(int id) {
            this.elementId = id;
        }

        protected void setFeatureAssignmentId(int id) {
            this.featureAssignmentId = id;
        }

        protected void setFeatureInfo(IGrammarConstraintProvider.IFeatureInfo featureInfo) {
            this.featureInfo = featureInfo;
        }

        protected void setMany(boolean many) {
            this.many = many;
        }

        protected void setOptional(boolean optional) {
            this.optional = optional;
        }

        public String toString() {
            if (this == INVALID) {
                return "INVALID";
            }
            if (this == TYPEMATCH) {
                return "TYPEMATCH";
            }
            if (this.type == null) {
                return "error(type is null)";
            }
            GrammarElementTitleSwitch t2s = new GrammarElementTitleSwitch().hideCardinality().showActionsAsRuleCalls().showAssignments();
            ProductionFormatter<ConstraintElement, AbstractElement> formatter = new ProductionFormatter<ConstraintElement, AbstractElement>();
            formatter.setTokenToString(t2s);
            return formatter.format(new IGrammarConstraintProvider.ConstraintElementProduction(this.getContainingConstraint()), this, true);
        }

        protected void typeMatch() {
            this.typeMatch = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FeatureInfo
    implements IGrammarConstraintProvider.IFeatureInfo {
        protected IGrammarConstraintProvider.IConstraintElement[] assignments;
        protected IGrammarConstraintProvider.IConstraint constraint;
        protected Boolean contentValidationNeeded;
        protected List<Pair<IGrammarConstraintProvider.IFeatureInfo, IGrammarConstraintProvider.RelationalDependencyType>> dependingFeatures;
        protected EStructuralFeature feature;

        public FeatureInfo(IGrammarConstraintProvider.IConstraint constraint, EStructuralFeature feature, IGrammarConstraintProvider.IConstraintElement[] assignments) {
            this.constraint = constraint;
            this.feature = feature;
            this.assignments = assignments;
            IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = assignments;
            int n = assignments.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
                ((ConstraintElement)ass).setFeatureInfo(this);
                ++n2;
            }
        }

        public int getAssignmentCount() {
            return this.assignments.length;
        }

        @Override
        public IGrammarConstraintProvider.IConstraintElement[] getAssignments() {
            return this.assignments;
        }

        @Override
        public IGrammarConstraintProvider.IConstraint getContainingConstraint() {
            return this.constraint;
        }

        @Override
        public List<Pair<IGrammarConstraintProvider.IFeatureInfo, IGrammarConstraintProvider.RelationalDependencyType>> getDependingFeatures() {
            if (this.dependingFeatures == null) {
                this.dependingFeatures = Lists.newArrayList();
                for (Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType> p : this.getRelationalAssignemntConstraintIntersection()) {
                    this.dependingFeatures.add(Tuples.create(p.getFirst().getFeatureInfo(), p.getSecond()));
                }
            }
            return this.dependingFeatures;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.feature;
        }

        @Override
        public int getLowerBound() {
            int result = 0;
            IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = this.getAssignments();
            int n = iConstraintElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
                if (!ass.isOptionalRecursive(null)) {
                    ++result;
                }
                ++n2;
            }
            return result;
        }

        protected List<Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType>> getRelationalAssignemntConstraintIntersection() {
            List<Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType>> r = this.getAssignments()[0].getDependingAssignment();
            if (this.getAssignmentCount() == 1) {
                return r;
            }
            r = Lists.newArrayList(r);
            int i = 1;
            while (i < this.getAssignments().length) {
                int j = r.size() - 1;
                while (j >= 0) {
                    if (this.getAssignments()[i] == r.get(j).getFirst() || !this.getAssignments()[i].getDependingAssignment().contains(r.get(j))) {
                        r.remove(j);
                    }
                    --j;
                }
                ++i;
            }
            return r;
        }

        @Override
        public int getUpperBound() {
            IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = this.getAssignments();
            int n = iConstraintElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
                if (ass.isManyRecursive(null)) {
                    return -1;
                }
                ++n2;
            }
            return this.getAssignmentCount();
        }

        @Override
        public boolean isContentValidationNeeded() {
            if (this.contentValidationNeeded != null) {
                return this.contentValidationNeeded;
            }
            this.contentValidationNeeded = false;
            if (this.assignments.length >= 2) {
                IGrammarConstraintProvider.IConstraintElement first = this.assignments[0];
                if (first.getType() == IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_ACTION_CALL) {
                    this.contentValidationNeeded = true;
                } else {
                    int i = 1;
                    while (i < this.assignments.length) {
                        IGrammarConstraintProvider.IConstraintElement a = this.assignments[i];
                        if (a.getType() == IGrammarConstraintProvider.ConstraintElementType.ASSIGNED_ACTION_CALL || first.getCrossReferenceType() != a.getCrossReferenceType() || !EcoreUtil.equals(first.getGrammarElement(), a.getGrammarElement())) {
                            this.contentValidationNeeded = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            return this.contentValidationNeeded;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.feature.getName());
            b.append("[");
            b.append(this.getLowerBound());
            b.append(", ");
            b.append(this.getUpperBound() == -1 ? "*" : Integer.valueOf(this.getUpperBound()));
            b.append("]");
            for (Pair<IGrammarConstraintProvider.IFeatureInfo, IGrammarConstraintProvider.RelationalDependencyType> rel : this.getDependingFeatures()) {
                b.append("\n    ");
                b.append((Object)rel.getSecond());
                b.append(" ");
                b.append(rel.getFirst().getFeature().getName());
            }
            return b.toString();
        }

        @Override
        public List<EObject> getCalledContexts() {
            ArrayList<EObject> result = Lists.newArrayList();
            IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = this.getAssignments();
            int n = iConstraintElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
                EObject ctx = ass.getCallContext();
                if (ctx != null) {
                    result.add(ctx);
                }
                ++n2;
            }
            return result;
        }
    }

    protected static class ParserRuleConstraintContext
    extends AbstractConstraintContext {
        protected ParserRule rule;

        public ParserRuleConstraintContext(ParserRule rule, String name) {
            super(name);
            this.rule = rule;
        }

        public EClass getCommonType() {
            return (EClass)this.rule.getType().getClassifier();
        }

        public EObject getContext() {
            return this.rule;
        }
    }

    protected static class RuleConstraint
    extends Constraint {
        protected ParserRule context;

        public RuleConstraint(ParserRule context, EClass type, ConstraintElement body, GrammarConstraintProvider provider) {
            super(type, body, provider);
            this.context = context;
        }

        protected EObject getMostSpecificContext() {
            return this.body == null ? this.context : this.body.getContext();
        }
    }
}

