/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.IAllContainersState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveShadowedAllContainerState
implements IAllContainersState {
    private IAllContainersState globalState;
    private IResourceDescriptions localDescriptions;

    @Override
    public Collection<URI> getContainedURIs(String containerHandle) {
        LinkedHashSet<URI> result = Sets.newLinkedHashSet();
        for (IResourceDescription descriptions : this.localDescriptions.getAllResourceDescriptions()) {
            String computedHandle = this.getContainerHandle(descriptions.getURI());
            if (computedHandle == null || !computedHandle.equals(containerHandle)) continue;
            result.add(descriptions.getURI());
        }
        result.addAll(this.globalState.getContainedURIs(containerHandle));
        return result;
    }

    @Override
    public String getContainerHandle(URI uri) {
        return this.globalState.getContainerHandle(uri);
    }

    @Override
    public List<String> getVisibleContainerHandles(String handle) {
        return this.globalState.getVisibleContainerHandles(handle);
    }

    @Override
    public boolean isEmpty(String containerHandle) {
        for (IResourceDescription descriptions : this.localDescriptions.getAllResourceDescriptions()) {
            String computedHandle = this.getContainerHandle(descriptions.getURI());
            if (computedHandle == null || !computedHandle.equals(containerHandle)) continue;
            return false;
        }
        return this.globalState.isEmpty(containerHandle);
    }

    public static class Provider {
        @Inject
        private com.google.inject.Provider<LiveShadowedAllContainerState> provider;

        public IAllContainersState get(IResourceDescriptions localDescriptions, IAllContainersState globalState) {
            LiveShadowedAllContainerState result = this.provider.get();
            result.globalState = globalState;
            result.localDescriptions = localDescriptions;
            return result;
        }
    }
}

