/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUriContainer
extends AbstractContainer {
    private final URI filterMe;
    private final IContainer delegate;

    public FilterUriContainer(URI filterMe, IContainer delegate) {
        this.filterMe = filterMe;
        this.delegate = delegate;
    }

    @Override
    public boolean isEmpty() {
        return this.getResourceDescriptionCount() == 0;
    }

    @Override
    public boolean hasResourceDescription(URI uri) {
        if (this.filterMe.equals(uri)) {
            return false;
        }
        return this.delegate.hasResourceDescription(uri);
    }

    @Override
    public int getResourceDescriptionCount() {
        int delegateCount = this.delegate.getResourceDescriptionCount();
        if (this.delegate.hasResourceDescription(this.filterMe)) {
            return delegateCount - 1;
        }
        return delegateCount;
    }

    @Override
    public Iterable<IResourceDescription> getResourceDescriptions() {
        return Iterables.filter(this.delegate.getResourceDescriptions(), new Predicate<IResourceDescription>(){

            @Override
            public boolean apply(IResourceDescription input) {
                return !input.getURI().equals(FilterUriContainer.this.filterMe);
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName qualifiedName, boolean ignoreCase) {
        Iterable<IEObjectDescription> unfiltered = this.delegate.getExportedObjects(type, qualifiedName, ignoreCase);
        return Iterables.filter(unfiltered, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                URI resourceURI = input.getEObjectURI().trimFragment();
                return !resourceURI.equals(FilterUriContainer.this.filterMe);
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        Iterable<IEObjectDescription> unfiltered = this.delegate.getExportedObjectsByType(type);
        return Iterables.filter(unfiltered, new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                URI resourceURI = input.getEObjectURI().trimFragment();
                return !resourceURI.equals(FilterUriContainer.this.filterMe);
            }
        });
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        if (uri.equals(this.filterMe)) {
            return null;
        }
        return this.delegate.getResourceDescription(uri);
    }
}

