/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.FileNotFoundOnClasspathException;
import org.eclipse.xtext.resource.IClasspathUriResolver;

public class ClassloaderClasspathUriResolver
implements IClasspathUriResolver {
    public URI resolve(Object context, URI classpathUri) {
        Object myContext = context;
        if (myContext == null) {
            myContext = Thread.currentThread().getContextClassLoader();
        }
        if (myContext instanceof Class) {
            myContext = ((Class)myContext).getClassLoader();
        }
        if (!(myContext instanceof ClassLoader)) {
            myContext = myContext.getClass().getClassLoader();
        }
        ClassLoader classLoader = (ClassLoader)myContext;
        try {
            if (ClasspathUriUtil.isClasspathUri(classpathUri)) {
                return this.findResourceOnClasspath(classLoader, classpathUri);
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    public URI findResourceOnClasspath(ClassLoader classLoader, URI classpathUri) throws URISyntaxException {
        URL resource;
        String pathAsString = classpathUri.path();
        if (classpathUri.hasAbsolutePath()) {
            pathAsString = pathAsString.substring(1);
        }
        if ((resource = classLoader.getResource(pathAsString)) == null) {
            throw new FileNotFoundOnClasspathException("Couldn't find resource on classpath. URI was '" + classpathUri + "'");
        }
        URI fileUri = URI.createURI(resource.toString(), true);
        return fileUri.appendFragment(classpathUri.fragment());
    }
}

