/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xtext.builder.trace.DebugLocationData;
import org.eclipse.xtext.builder.trace.DebugTraceRegion;
import org.eclipse.xtext.builder.trace.TraceFactory;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;

public class TraceResourceFactory
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        ResourceImpl result = new ResourceImpl(uri){

            @Override
            protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
                TraceRegionSerializer serializer = new TraceRegionSerializer();
                DebugTraceRegion result = serializer.doReadFrom(inputStream, new Strategy());
                this.getContents().add(result);
            }

            @Override
            protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
                TraceRegionSerializer serializer = new TraceRegionSerializer();
                serializer.doWriteTo(new Strategy(), (DebugTraceRegion)this.getContents().get(0), outputStream);
            }
        };
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Strategy
    implements TraceRegionSerializer.Strategy<DebugTraceRegion, DebugLocationData> {
        protected Strategy() {
        }

        @Override
        public DebugLocationData createLocation(int offset, int length, int lineNumber, int endLineNumber, URI path) {
            DebugLocationData result = TraceFactory.eINSTANCE.createDebugLocationData();
            result.setOffset(offset);
            result.setLength(length);
            result.setLineNumber(lineNumber);
            result.setEndLineNumber(endLineNumber);
            result.setPath(path);
            return result;
        }

        @Override
        public DebugTraceRegion createRegion(int offset, int length, int lineNumber, int endLineNumber, List<DebugLocationData> associations, DebugTraceRegion parent) {
            DebugTraceRegion result = TraceFactory.eINSTANCE.createDebugTraceRegion();
            result.setMyOffset(offset);
            result.setMyLength(length);
            result.setMyLineNumber(lineNumber);
            result.setMyEndLineNumber(endLineNumber);
            result.getAssociations().addAll(associations);
            if (parent != null) {
                parent.getNestedRegions().add(result);
            }
            return result;
        }

        @Override
        public void writeRegion(DebugTraceRegion region, TraceRegionSerializer.Callback<DebugTraceRegion, DebugLocationData> callback) throws IOException {
            callback.doWriteRegion(region.getMyOffset(), region.getMyLength(), region.getMyLineNumber(), region.getMyEndLineNumber(), region.getAssociations(), region.getNestedRegions());
        }

        @Override
        public void writeLocation(DebugLocationData location, TraceRegionSerializer.Callback<DebugTraceRegion, DebugLocationData> callback) throws IOException {
            callback.doWriteLocation(location.getOffset(), location.getLength(), location.getLineNumber(), location.getEndLineNumber(), location.getPath());
        }
    }
}

