/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.clustering.IResourceClusteringPolicy;

public class DynamicResourceClusteringPolicy
implements IResourceClusteringPolicy {
    public static final String MINIMUM_CLUSTER_SIZE = "org.eclipse.xtext.builder.clustering.DynamicResourceClusteringPolicy.minimumClusterSize";
    public static final String MINIMUM_PERCENT_FREE_MEMORY = "org.eclipse.xtext.builder.clustering.DynamicResourceClusteringPolicy.minimumPercentFreeMemory";
    private static final Logger LOGGER = Logger.getLogger(DynamicResourceClusteringPolicy.class);
    private static final long MINIMUM_FREE_MEMORY = 0xA00000L;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.clustering.DynamicResourceClusteringPolicy.minimumClusterSize")
    private final int minimumClusterSize = 20;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.clustering.DynamicResourceClusteringPolicy.minimumPercentFreeMemory")
    private final long minimumPercentFreeMemory = 15L;
    private static boolean hasLoggedAboutIncreasingHeap = false;

    public boolean continueProcessing(ResourceSet resourceSet, URI next, int alreadyProcessed) {
        if (alreadyProcessed == 0) {
            return true;
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory > Runtime.getRuntime().totalMemory() + 0xA00000L) {
            return true;
        }
        long freeMemory = Runtime.getRuntime().freeMemory();
        if (freeMemory < 0xA00000L) {
            this.logClusterCapped(resourceSet, alreadyProcessed, freeMemory, maxMemory);
            return false;
        }
        if (alreadyProcessed < 20) {
            return true;
        }
        if (freeMemory < maxMemory / 100L * 15L) {
            this.logClusterCapped(resourceSet, alreadyProcessed, freeMemory, maxMemory);
            return false;
        }
        return true;
    }

    protected void logClusterCapped(ResourceSet resourceSet, int alreadyProcessed, long freeMemory, long totalMemory) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cluster capped at " + alreadyProcessed + '/' + resourceSet.getResources().size() + " processed/loaded resources; " + (freeMemory >> 20) + "/" + (totalMemory >> 20) + " free/total memory");
        }
        if (!hasLoggedAboutIncreasingHeap) {
            hasLoggedAboutIncreasingHeap = true;
            LOGGER.error("Your total heap size (" + (totalMemory >> 20) + "m) is too small. Please increase the maximum heap for your running Eclipse! See http://wiki.eclipse.org/FAQ_How_do_I_increase_the_heap_size_available_to_Eclipse%3F");
        }
    }
}

