/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewLabelProvider
extends ColumnLabelProvider {
    private HashMap<ImageDescriptor, Image> images;
    private final IWorkbenchWindow window;
    private final Color dimmedForeground;

    public ViewLabelProvider(IWorkbenchWindow window, Color dimmedForeground) {
        this.window = window;
        this.dimmedForeground = dimmedForeground;
    }

    @Override
    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
    }

    Image cacheImage(ImageDescriptor desc) {
        Image image;
        if (this.images == null) {
            this.images = new HashMap(21);
        }
        if ((image = this.images.get(desc)) == null) {
            image = desc.createImage();
            this.images.put(desc, image);
        }
        return image;
    }

    @Override
    public void dispose() {
        if (this.images != null) {
            for (Image i : this.images.values()) {
                i.dispose();
            }
            this.images = null;
        }
        super.dispose();
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof IViewDescriptor) {
            ImageDescriptor desc = ((IViewDescriptor)element).getImageDescriptor();
            if (desc != null) {
                return this.cacheImage(desc);
            }
        } else if (element instanceof IViewCategory) {
            ImageDescriptor desc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
            return this.cacheImage(desc);
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        String label = WorkbenchMessages.ViewLabel_unknown;
        if (element instanceof IViewCategory) {
            label = ((IViewCategory)element).getLabel();
        } else if (element instanceof IViewDescriptor) {
            label = ((IViewDescriptor)element).getLabel();
        }
        return DialogUtil.removeAccel(label);
    }

    @Override
    public Color getBackground(Object element) {
        return null;
    }

    @Override
    public Color getForeground(Object element) {
        IWorkbenchPage activePage;
        if (element instanceof IViewDescriptor && (activePage = this.window.getActivePage()) != null && activePage.findViewReference(((IViewDescriptor)element).getId()) != null) {
            return this.dimmedForeground;
        }
        return null;
    }
}

