/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Menu;

public abstract class CompoundContributionItem
extends ContributionItem {
    private IMenuListener menuListener = new IMenuListener(){

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
        }
    };
    private IContributionItem[] oldItems;

    protected CompoundContributionItem() {
    }

    protected CompoundContributionItem(String id) {
        super(id);
    }

    @Override
    public void fill(Menu menu, int index) {
        if (index == -1) {
            index = menu.getItemCount();
        }
        IContributionItem[] items = this.getContributionItemsToFill();
        if (index > menu.getItemCount()) {
            index = menu.getItemCount();
        }
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            int oldItemCount = menu.getItemCount();
            if (item.isVisible()) {
                item.fill(menu, index);
            }
            int newItemCount = menu.getItemCount();
            int numAdded = newItemCount - oldItemCount;
            index += numAdded;
            ++i;
        }
    }

    protected abstract IContributionItem[] getContributionItems();

    private IContributionItem[] getContributionItemsToFill() {
        this.disposeOldItems();
        this.oldItems = this.getContributionItems();
        return this.oldItems;
    }

    private void disposeOldItems() {
        if (this.oldItems != null) {
            int i = 0;
            while (i < this.oldItems.length) {
                IContributionItem oldItem = this.oldItems[i];
                oldItem.dispose();
                ++i;
            }
            this.oldItems = null;
        }
    }

    @Override
    public boolean isDirty() {
        return true;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }

    @Override
    public void dispose() {
        this.disposeOldItems();
        super.dispose();
    }
}

