/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.Map;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractSourceProvider
implements ISourceProvider {
    protected static boolean DEBUG = Policy.DEBUG_SOURCES;
    private final ListenerList listeners = new ListenerList(1);

    @Override
    public final void addSourceProviderListener(ISourceProviderListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        this.listeners.add(listener);
    }

    protected final void fireSourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISourceProviderListener)listener).sourceChanged(sourcePriority, sourceName, sourceValue);
            ++n2;
        }
    }

    protected final void fireSourceChanged(int sourcePriority, Map sourceValuesByName) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISourceProviderListener)listener).sourceChanged(sourcePriority, sourceValuesByName);
            ++n2;
        }
    }

    protected final void logDebuggingInfo(String message) {
        if (DEBUG && message != null) {
            Tracing.printTrace("SOURCES", message);
        }
    }

    @Override
    public final void removeSourceProviderListener(ISourceProviderListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        this.listeners.remove(listener);
    }

    public void initialize(IServiceLocator locator) {
    }
}

