/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.serializer;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.BooleanLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.Import;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Mwe2Package;
import org.eclipse.emf.mwe2.language.mwe2.PlainString;
import org.eclipse.emf.mwe2.language.mwe2.PropertyReference;
import org.eclipse.emf.mwe2.language.mwe2.Reference;
import org.eclipse.emf.mwe2.language.mwe2.StringLiteral;
import org.eclipse.emf.mwe2.language.services.Mwe2GrammarAccess;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public abstract class AbstractMwe2SemanticSequencer
extends AbstractDelegatingSemanticSequencer {
    @Inject
    private Mwe2GrammarAccess grammarAccess;

    public void createSequence(EObject context, EObject semanticObject) {
        if (semanticObject.eClass().getEPackage() == Mwe2Package.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 5: {
                    if (context != this.grammarAccess.getAssignmentRule()) break;
                    this.sequence_Assignment(context, (Assignment)semanticObject);
                    return;
                }
                case 7: {
                    if (context != this.grammarAccess.getBooleanLiteralRule() && context != this.grammarAccess.getValueRule()) break;
                    this.sequence_BooleanLiteral(context, (BooleanLiteral)semanticObject);
                    return;
                }
                case 3: {
                    if (context == this.grammarAccess.getComponentRule() || context == this.grammarAccess.getValueRule()) {
                        this.sequence_Component(context, (Component)semanticObject);
                        return;
                    }
                    if (context != this.grammarAccess.getRootComponentRule()) break;
                    this.sequence_RootComponent(context, (Component)semanticObject);
                    return;
                }
                case 2: {
                    if (context != this.grammarAccess.getDeclaredPropertyRule()) break;
                    this.sequence_DeclaredProperty(context, (DeclaredProperty)semanticObject);
                    return;
                }
                case 4: {
                    if (context != this.grammarAccess.getImportRule()) break;
                    this.sequence_Import(context, (Import)semanticObject);
                    return;
                }
                case 0: {
                    if (context != this.grammarAccess.getModuleRule()) break;
                    this.sequence_Module(context, (Module)semanticObject);
                    return;
                }
                case 12: {
                    if (context != this.grammarAccess.getPlainStringRule()) break;
                    this.sequence_PlainString(context, (PlainString)semanticObject);
                    return;
                }
                case 11: {
                    if (context != this.grammarAccess.getPropertyReferenceRule() && context != this.grammarAccess.getPropertyReferenceImplRule()) break;
                    this.sequence_PropertyReferenceImpl(context, (PropertyReference)semanticObject);
                    return;
                }
                case 8: {
                    if (context != this.grammarAccess.getReferenceRule() && context != this.grammarAccess.getValueRule()) break;
                    this.sequence_Reference(context, (Reference)semanticObject);
                    return;
                }
                case 9: {
                    if (context != this.grammarAccess.getStringLiteralRule() && context != this.grammarAccess.getValueRule()) break;
                    this.sequence_StringLiteral(context, (StringLiteral)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_Assignment(EObject context, Assignment semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_BooleanLiteral(EObject context, BooleanLiteral semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_Component(EObject context, Component semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_DeclaredProperty(EObject context, DeclaredProperty semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_Import(EObject context, Import semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.IMPORT__IMPORTED_NAMESPACE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.IMPORT__IMPORTED_NAMESPACE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getImportAccess().getImportedNamespaceImportedFQNParserRuleCall_1_0(), (Object)semanticObject.getImportedNamespace());
        feeder.finish();
    }

    protected void sequence_Module(EObject context, Module semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_PlainString(EObject context, PlainString semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.PLAIN_STRING__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.PLAIN_STRING__VALUE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getPlainStringAccess().getValueConstantValueParserRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_PropertyReferenceImpl(EObject context, PropertyReference semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getPropertyReferenceImplAccess().getReferableDeclaredPropertyFQNParserRuleCall_0_1(), (Object)semanticObject.getReferable());
        feeder.finish();
    }

    protected void sequence_Reference(EObject context, Reference semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing(semanticObject, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getReferenceAccess().getReferableReferrableFQNParserRuleCall_0_1(), (Object)semanticObject.getReferable());
        feeder.finish();
    }

    protected void sequence_RootComponent(EObject context, Component semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }

    protected void sequence_StringLiteral(EObject context, StringLiteral semanticObject) {
        this.genericSequencer.createSequence(context, semanticObject);
    }
}

