/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowComponentWithID;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;

public class Mwe2Bridge {
    private static final Log log = LogFactory.getLog(Mwe2Bridge.class);
    private final WorkflowComponentWithID delegate;

    public Mwe2Bridge(WorkflowComponentWithID delegate) {
        this.delegate = delegate;
    }

    public void invoke(final IWorkflowContext ctx) {
        IssuesImpl issuesImpl = new IssuesImpl();
        this.delegate.invoke(new WorkflowContext(){

            public void set(String slotName, Object value) {
                ctx.put(slotName, value);
            }

            public String[] getSlotNames() {
                return ctx.getSlotNames().toArray(new String[ctx.getSlotNames().size()]);
            }

            public Object get(String slotName) {
                return ctx.get(slotName);
            }
        }, new NullProgressMonitor(), issuesImpl);
        this.handleIssues(issuesImpl);
    }

    protected void handleIssues(IssuesImpl issuesImpl) {
        MWEDiagnostic[] mWEDiagnosticArray = issuesImpl.getWarnings();
        int n = mWEDiagnosticArray.length;
        int n2 = 0;
        while (n2 < n) {
            MWEDiagnostic diag = mWEDiagnosticArray[n2];
            log.warn(diag.toString());
            ++n2;
        }
        if (issuesImpl.hasErrors()) {
            throw new RuntimeException(issuesImpl.toString());
        }
    }

    public void postInvoke() {
    }

    public void preInvoke() {
        IssuesImpl issuesImpl = new IssuesImpl();
        this.delegate.checkConfiguration(issuesImpl);
        this.handleIssues(issuesImpl);
    }
}

