/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact;

public enum ArtifactScopeEnum {
    compile(1),
    test(2),
    runtime(3),
    provided(4),
    system(5),
    runtime_plus_system(6);

    public static final ArtifactScopeEnum DEFAULT_SCOPE;
    private int id;
    private static final ArtifactScopeEnum[][][] COMPLIANCY_SETS;

    private ArtifactScopeEnum(int id) {
        this.id = id;
    }

    int getId() {
        return this.id;
    }

    public static final ArtifactScopeEnum checkScope(ArtifactScopeEnum scope) {
        return scope == null ? DEFAULT_SCOPE : scope;
    }

    public String getScope() {
        if (this.id == 1) {
            return "compile";
        }
        if (this.id == 2) {
            return "test";
        }
        if (this.id == 3) {
            return "runtime";
        }
        if (this.id == 4) {
            return "provided";
        }
        if (this.id == 5) {
            return "system";
        }
        return "runtime+system";
    }

    public boolean encloses(ArtifactScopeEnum scope) {
        ArtifactScopeEnum s = ArtifactScopeEnum.checkScope(scope);
        if (this.id == ArtifactScopeEnum.system.id) {
            return scope.id == ArtifactScopeEnum.system.id;
        }
        for (ArtifactScopeEnum[][] set : COMPLIANCY_SETS) {
            if (this.id != set[0][0].id) continue;
            for (ArtifactScopeEnum ase : set[1]) {
                if (s.id != ase.id) continue;
                return true;
            }
            break;
        }
        return false;
    }

    static {
        DEFAULT_SCOPE = compile;
        COMPLIANCY_SETS = new ArtifactScopeEnum[][][]{{{compile}, {compile, provided, system}}, {{test}, {compile, test, provided, system}}, {{runtime}, {compile, runtime, system}}, {{provided}, {compile, test, provided}}};
    }
}

