/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.xtext;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.danieldietrich.protectedregions.support.IFileSystemReader;
import net.danieldietrich.protectedregions.support.IPathFilter;
import net.danieldietrich.protectedregions.support.IProtectedRegionSupport;
import net.danieldietrich.protectedregions.xtext.TangoFileUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidiJavaIoFileSystemAccess
extends JavaIoFileSystemAccess
implements IFileSystemReader {
    private transient Logger logger = LoggerFactory.getLogger(BidiJavaIoFileSystemAccess.class);
    private final IProtectedRegionSupport support;
    private IPathFilter filter;

    public BidiJavaIoFileSystemAccess(IProtectedRegionSupport support) {
        this.support = support;
    }

    protected IProtectedRegionSupport getSupport() {
        return this.support;
    }

    @Override
    public void setOutputConfigurations(Map<String, OutputConfiguration> outputs) {
        super.setOutputConfigurations(outputs);
        if (outputs != null) {
            for (OutputConfiguration output : outputs.values()) {
                this.readRegions(output.getName(), output.getOutputDirectory());
            }
        }
    }

    @Override
    public void setOutputPath(String path) {
        this.setOutputPath("DEFAULT_OUTPUT", path);
    }

    @Override
    public void setOutputPath(String outputName, String path) {
        super.setOutputPath(outputName, path);
        this.readRegions(outputName, path);
    }

    @Override
    public void generateFile(String fileName, CharSequence contents) {
        URI uri = this.getUri(fileName);
        this.logger.debug("Generating {} at {} => {}", new Object[]{fileName, "DEFAULT_OUTPUT", uri});
        CharSequence mergedContents = this.support.mergeRegions(this, fileName, "DEFAULT_OUTPUT", contents);
        super.generateFile(fileName, mergedContents);
    }

    @Override
    public void generateFile(String fileName, String slot, CharSequence contents) {
        URI uri = this.getUri(fileName, slot);
        CharSequence mergedContents = this.support.mergeRegions(this, fileName, slot, contents);
        TangoFileUtils.writeFile(uri, mergedContents.toString());
    }

    @Override
    public IPathFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(IPathFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean exists(URI uri) {
        return new File(uri).exists();
    }

    @Override
    public CharSequence readFile(URI uri) throws IllegalArgumentException, IOException {
        File file = new File(uri);
        return FileUtils.readFileToString(file);
    }

    @Override
    public Set<URI> listFiles(URI path) {
        Collection<File> files = FileUtils.listFiles(new File(path), null, true);
        HashSet<URI> result = new HashSet<URI>();
        for (File file : files) {
            if (this.filter != null && !this.filter.accept(file.toURI())) continue;
            result.add(file.toURI());
        }
        return result;
    }

    @Override
    public boolean hasFiles(URI uri) {
        return new File(uri).isDirectory();
    }

    @Override
    public boolean isFile(URI uri) {
        return new File(uri).isFile();
    }

    @Override
    public String getCanonicalPath(URI uri) {
        try {
            return new File(uri).getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.warn("Cannot get canonical path for {}.", uri);
            return uri.getRawPath();
        }
    }

    @Override
    public URI getUri(String relativePath) {
        return this.getUri(relativePath, "DEFAULT_OUTPUT");
    }

    @Override
    public URI getUri(String relativePath, String slot) {
        Map<String, String> pathes = this.getPathes();
        if (pathes.size() == 0) {
            throw new IllegalStateException("No slots initialized!? Call #setOutputPath(...)");
        }
        String slotPath = pathes.get(slot == null ? "DEFAULT_OUTPUT" : slot);
        if (slotPath == null) {
            throw new IllegalStateException("Slot " + slot + " not found.");
        }
        return new File(String.valueOf(slotPath) + "/" + relativePath).toURI();
    }

    private void readRegions(String slot, String path) {
        this.logger.info("Adding slot {} => {}", (Object)slot, (Object)path);
        this.support.readRegions(this, slot);
    }
}

