/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.connector;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import io.tesla.aether.client.AetherClient;
import io.tesla.aether.client.AetherClientAuthentication;
import io.tesla.aether.client.AetherClientConfig;
import io.tesla.aether.client.AetherClientProxy;
import io.tesla.aether.client.Response;
import io.tesla.aether.client.RetryableSource;
import io.tesla.aether.connector.AuthorizationException;
import io.tesla.aether.connector.ResourceDoesNotExistException;
import io.tesla.aether.connector.TransferException;
import io.tesla.aether.okhttp.OkHttpAetherClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.Transfer;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.repository.layout.MavenDefaultLayout;
import org.eclipse.aether.util.repository.layout.RepositoryLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AetherRepositoryConnector
implements RepositoryConnector {
    private final Logger logger = LoggerFactory.getLogger(AetherRepositoryConnector.class);
    private final RepositoryLayout layout = new MavenDefaultLayout();
    private final TransferListener listener;
    private final RepositorySystemSession session;
    private final AuthenticationContext repoAuthenticationContext;
    private final AuthenticationContext proxyAuthenticationContext;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final Map<String, String> checksumAlgos;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private boolean useCache = true;
    private Map<String, String> commonHeaders;
    private AetherClient aetherClient;
    private static final ExceptionWrapper<MetadataTransfer> METADATA = new ExceptionWrapper<MetadataTransfer>(){

        @Override
        public void wrap(MetadataTransfer transfer, Exception e, RemoteRepository repository) {
            MetadataTransferException ex = null;
            if (e instanceof ResourceDoesNotExistException) {
                ex = new MetadataNotFoundException(transfer.getMetadata(), repository);
            } else if (e != null) {
                ex = new MetadataTransferException(transfer.getMetadata(), repository, e);
            }
            transfer.setException(ex);
        }
    };
    private static final ExceptionWrapper<ArtifactTransfer> ARTIFACT = new ExceptionWrapper<ArtifactTransfer>(){

        @Override
        public void wrap(ArtifactTransfer transfer, Exception e, RemoteRepository repository) {
            ArtifactTransferException ex = null;
            if (e instanceof ResourceDoesNotExistException) {
                ex = new ArtifactNotFoundException(transfer.getArtifact(), repository);
            } else if (e != null) {
                ex = new ArtifactTransferException(transfer.getArtifact(), repository, e);
            }
            transfer.setException(ex);
        }
    };

    public AetherRepositoryConnector(RemoteRepository repository, RepositorySystemSession session, FileProcessor fileProcessor) throws NoRepositoryConnectorException {
        this(repository, session, fileProcessor, null);
    }

    public AetherRepositoryConnector(RemoteRepository repository, RepositorySystemSession session, FileProcessor fileProcessor, SSLSocketFactory sslSocketFactory) throws NoRepositoryConnectorException {
        PlexusConfiguration[] properties;
        PlexusConfiguration httpHeaders;
        PlexusConfiguration wagonConfig;
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryConnectorException(repository);
        }
        if (!repository.getProtocol().regionMatches(true, 0, "http", 0, "http".length())) {
            throw new NoRepositoryConnectorException(repository);
        }
        this.repository = repository;
        this.listener = session.getTransferListener();
        this.fileProcessor = fileProcessor;
        this.session = session;
        AetherClientConfig config = new AetherClientConfig();
        this.repoAuthenticationContext = AuthenticationContext.forRepository(session, repository);
        this.proxyAuthenticationContext = AuthenticationContext.forProxy(session, repository);
        this.commonHeaders = new HashMap<String, String>();
        Map<?, ?> headers = ConfigUtils.getMap(session, null, "aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers");
        if (headers != null) {
            this.commonHeaders.putAll(headers);
        }
        if ((wagonConfig = (PlexusConfiguration)ConfigUtils.getObject(session, null, "aether.connector.wagon.config." + repository.getId())) != null && (httpHeaders = wagonConfig.getChild("httpHeaders")) != null && (properties = httpHeaders.getChildren("property")) != null) {
            for (PlexusConfiguration property : properties) {
                this.commonHeaders.put(property.getChild("name").getValue(), property.getChild("value").getValue());
            }
        }
        config.setHeaders(this.commonHeaders);
        config.setUserAgent(ConfigUtils.getString(session, "Aether", "aether.connector.userAgent"));
        this.checksumAlgos = new LinkedHashMap<String, String>();
        this.checksumAlgos.put("SHA-1", ".sha1");
        this.checksumAlgos.put("MD5", ".md5");
        if (repository.getProxy() != null) {
            AetherClientProxy proxy = new AetherClientProxy();
            proxy.setHost(repository.getProxy().getHost());
            proxy.setPort(repository.getProxy().getPort());
            if (this.proxyAuthenticationContext != null) {
                String username = this.proxyAuthenticationContext.get("username");
                String password = this.proxyAuthenticationContext.get("password");
                proxy.setAuthentication(new AetherClientAuthentication(username, password));
            }
            config.setProxy(proxy);
        }
        if (this.repoAuthenticationContext != null) {
            String username = this.repoAuthenticationContext.get("username");
            String password = this.repoAuthenticationContext.get("password");
            AetherClientAuthentication authentication = new AetherClientAuthentication(username, password);
            config.setAuthentication(authentication);
        }
        int connectTimeout = ConfigUtils.getInteger(session, 10000, "aether.connector.connectTimeout");
        int readTimeout = ConfigUtils.getInteger(session, 1800000, "aether.connector.requestTimeout");
        config.setConnectionTimeout(connectTimeout);
        config.setRequestTimeout(readTimeout);
        config.setSslSocketFactory(sslSocketFactory);
        this.aetherClient = new OkHttpAetherClient(config);
    }

    @Override
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        GetTask task;
        String resource;
        if (this.closed.get()) {
            throw new IllegalStateException("connector closed");
        }
        artifactDownloads = this.safe(artifactDownloads);
        metadataDownloads = this.safe(metadataDownloads);
        CountDownLatch latch = new CountDownLatch(artifactDownloads.size() + metadataDownloads.size());
        ArrayList<GetTask> tasks = new ArrayList<GetTask>();
        for (MetadataDownload metadataDownload : metadataDownloads) {
            resource = this.layout.getPath(metadataDownload.getMetadata()).getPath();
            task = new GetTask(this, resource, metadataDownload.getFile(), metadataDownload.getChecksumPolicy(), latch, (Transfer)metadataDownload, METADATA);
            tasks.add(task);
            task.run();
        }
        for (ArtifactDownload artifactDownload : artifactDownloads) {
            resource = this.layout.getPath(artifactDownload.getArtifact()).getPath();
            task = new GetTask(this, resource, artifactDownload.isExistenceCheck() ? null : artifactDownload.getFile(), artifactDownload.getChecksumPolicy(), latch, (Transfer)artifactDownload, ARTIFACT);
            tasks.add(task);
            task.run();
        }
        this.await(latch);
        for (GetTask getTask : tasks) {
            getTask.flush();
        }
    }

    @Override
    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTask task;
        String path;
        if (this.closed.get()) {
            throw new IllegalStateException("connector closed");
        }
        artifactUploads = this.safe(artifactUploads);
        metadataUploads = this.safe(metadataUploads);
        CountDownLatch latch = new CountDownLatch(artifactUploads.size() + metadataUploads.size());
        ArrayList<PutTask> tasks = new ArrayList<PutTask>();
        for (ArtifactUpload artifactUpload : artifactUploads) {
            path = this.layout.getPath(artifactUpload.getArtifact()).getPath();
            task = new PutTask(this, path, artifactUpload.getFile(), latch, (Transfer)artifactUpload, ARTIFACT);
            tasks.add(task);
            task.run();
        }
        for (MetadataUpload metadataUpload : metadataUploads) {
            path = this.layout.getPath(metadataUpload.getMetadata()).getPath();
            task = new PutTask(this, path, metadataUpload.getFile(), latch, (Transfer)metadataUpload, METADATA);
            tasks.add(task);
            task.run();
        }
        this.await(latch);
        for (PutTask putTask : tasks) {
            putTask.flush();
        }
    }

    private void await(CountDownLatch latch) {
        boolean interrupted = false;
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void handleResponseCode(String url, int responseCode, String responseMsg) throws AuthorizationException, ResourceDoesNotExistException, TransferException {
        if (responseCode == 404) {
            throw new ResourceDoesNotExistException(String.format("Unable to locate resource %s. Error code %s", url, responseCode));
        }
        if (responseCode == 403 || responseCode == 401 || responseCode == 407) {
            throw new AuthorizationException(String.format("Access denied to %s. Error code %s, %s", url, responseCode, responseMsg));
        }
        if (responseCode >= 300) {
            throw new TransferException(String.format("Failed to transfer %s. Error code %s, %s", url, responseCode, responseMsg));
        }
    }

    private TransferEvent.Builder newEvent(TransferResource resource, TransferEvent.RequestType requestType, TransferEvent.EventType eventType) {
        return this.newEvent(resource, null, requestType, eventType);
    }

    private TransferEvent.Builder newEvent(TransferResource resource, Exception e, TransferEvent.RequestType requestType, TransferEvent.EventType eventType) {
        TransferEvent.Builder event = new TransferEvent.Builder(this.session, resource);
        event.setType(eventType);
        event.setRequestType(requestType);
        event.setException(e);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadChecksum(File file, String uri, String algo, Object checksum) throws IOException {
        Closer closer = Closer.create();
        try {
            if (checksum instanceof Exception) {
                throw (Exception)checksum;
            }
            final byte[] bytes = String.valueOf(checksum).getBytes("UTF-8");
            String ext = this.checksumAlgos.get(algo);
            Response response = this.aetherClient.put(uri + ext, new RetryableSource(){

                @Override
                public void copyTo(OutputStream os) throws IOException {
                    ByteStreams.asByteSource(bytes).copyTo(os);
                }

                @Override
                public long length() {
                    return bytes.length;
                }
            });
            int statusCode = response.getStatusCode();
            if (statusCode >= 400) {
                throw new TransferException(String.format("Upload checksum failed for %s with status code %s", uri + ext, "RESPONSE" == null ? 500 : statusCode));
            }
        }
        catch (Exception e) {
            String msg = "Failed to upload " + algo + " checksum for " + file + ": " + e.getMessage();
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(msg, e);
            } else {
                this.logger.warn(msg);
            }
        }
        finally {
            closer.close();
        }
    }

    private String buildUrl(String path) {
        String repoUrl = this.repository.getUrl();
        path = path.replace(' ', '+');
        if (repoUrl.charAt(repoUrl.length() - 1) != '/') {
            return repoUrl + '/' + path;
        }
        return repoUrl + path;
    }

    @Override
    public void close() {
        this.closed.set(true);
        AuthenticationContext.close(this.repoAuthenticationContext);
        AuthenticationContext.close(this.proxyAuthenticationContext);
    }

    private <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private File getTmpFile(String path) {
        File file;
        File f = new File(path);
        while ((file = new File(f.getParentFile(), "aether-" + UUID.randomUUID() + "-" + f.getName() + "-in-progress")).exists()) {
        }
        return file;
    }

    private class LatchGuard {
        private final CountDownLatch latch;
        private final AtomicBoolean done = new AtomicBoolean(false);

        public LatchGuard(CountDownLatch latch) {
            this.latch = latch;
        }

        public void countDown() {
            if (!this.done.getAndSet(true)) {
                this.latch.countDown();
            }
        }
    }

    static interface ExceptionWrapper<T> {
        public void wrap(T var1, Exception var2, RemoteRepository var3);
    }

    static class PutTask<T extends Transfer>
    implements Runnable {
        private final T upload;
        private final ExceptionWrapper<T> wrapper;
        private final String path;
        private final File file;
        private volatile Exception exception;
        private final LatchGuard latch;
        final /* synthetic */ AetherRepositoryConnector this$0;

        public PutTask(String path, File file, CountDownLatch latch, T upload, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.file = file;
            this.upload = upload;
            this.wrapper = wrapper;
            this.latch = var1_1.new LatchGuard(latch);
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ((Transfer)this.upload).setState(Transfer.State.ACTIVE);
            TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), this.path, this.file, ((Transfer)this.upload).getTrace());
            try {
                String uri = this.this$0.buildUrl(this.path);
                if (this.this$0.listener != null) {
                    this.this$0.listener.transferInitiated(this.this$0.newEvent(transferResource, this.exception, TransferEvent.RequestType.PUT, TransferEvent.EventType.INITIATED).build());
                }
                if (this.this$0.listener != null) {
                    transferResource.setContentLength(this.file.length());
                    this.this$0.listener.transferStarted(this.this$0.newEvent(transferResource, null, TransferEvent.RequestType.PUT, TransferEvent.EventType.STARTED).build());
                }
                FileSource source = this.this$0.new FileSource(transferResource);
                Response response = this.this$0.aetherClient.put(uri, source);
                this.this$0.handleResponseCode(uri, response.getStatusCode(), response.getStatusMessage());
                int statusCode = response.getStatusCode();
                if (statusCode >= 400) {
                    throw new TransferException(String.format("Upload failed for %s with status code %s", uri, "RESPONSE" == null ? 500 : statusCode));
                }
                if (this.this$0.listener != null) {
                    this.this$0.listener.transferSucceeded(this.this$0.newEvent(transferResource, null, TransferEvent.RequestType.PUT, TransferEvent.EventType.SUCCEEDED).setTransferredBytes(source.getBytesTransferred()).build());
                }
                this.uploadChecksums(this.file, uri);
            }
            catch (Exception e) {
                try {
                    this.exception = e;
                }
                finally {
                    if (this.this$0.listener != null) {
                        this.this$0.listener.transferFailed(this.this$0.newEvent(transferResource, this.exception, TransferEvent.RequestType.PUT, TransferEvent.EventType.FAILED).build());
                    }
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public void flush() {
            this.wrapper.wrap(this.upload, this.exception, this.this$0.repository);
            ((Transfer)this.upload).setState(Transfer.State.DONE);
        }

        private void uploadChecksums(File file, String uri) {
            try {
                Map<String, Object> checksums = ChecksumUtils.calc(file, this.this$0.checksumAlgos.keySet());
                for (Map.Entry<String, Object> entry : checksums.entrySet()) {
                    this.this$0.uploadChecksum(file, uri, entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                this.this$0.logger.debug("Failed to upload checksums for " + file + ": " + e.getMessage(), e);
            }
        }
    }

    static class GetTask<T extends Transfer>
    implements Runnable {
        private final T download;
        private final String path;
        private final File fileInLocalRepository;
        private final String checksumPolicy;
        private final LatchGuard latch;
        private volatile Exception exception;
        private final ExceptionWrapper<T> wrapper;
        final /* synthetic */ AetherRepositoryConnector this$0;

        public GetTask(String path, File fileInLocalRepository, String checksumPolicy, CountDownLatch latch, T download, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.fileInLocalRepository = fileInLocalRepository;
            this.checksumPolicy = checksumPolicy;
            this.latch = var1_1.new LatchGuard(latch);
            this.download = download;
            this.wrapper = wrapper;
        }

        public T getDownload() {
            return this.download;
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ((Transfer)this.download).setState(Transfer.State.ACTIVE);
            String uri = this.this$0.buildUrl(this.path);
            TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), this.path, this.fileInLocalRepository, ((Transfer)this.download).getTrace());
            try {
                if (this.this$0.listener != null) {
                    this.this$0.listener.transferInitiated(this.this$0.newEvent(transferResource, TransferEvent.RequestType.GET, TransferEvent.EventType.INITIATED).build());
                }
                if (this.fileInLocalRepository == null) {
                    if (!this.resourceExist(uri)) {
                        throw new ResourceDoesNotExistException("Could not find " + uri + " in " + this.this$0.repository.getUrl());
                    }
                    this.latch.countDown();
                    return;
                }
                this.this$0.fileProcessor.mkdirs(this.fileInLocalRepository.getParentFile());
                FileTransfer temporaryFileInLocalRepository = this.resumableGet(uri, this.fileInLocalRepository, transferResource, TransferEvent.RequestType.GET, this.this$0.listener);
                this.validateChecksums(temporaryFileInLocalRepository.file, this.fileInLocalRepository, uri, transferResource);
                this.rename(temporaryFileInLocalRepository.file, this.fileInLocalRepository);
                if (this.this$0.listener != null) {
                    this.this$0.listener.transferSucceeded(this.this$0.newEvent(transferResource, TransferEvent.RequestType.GET, TransferEvent.EventType.SUCCEEDED).setTransferredBytes(temporaryFileInLocalRepository.bytesTransferred).build());
                }
            }
            catch (Throwable t) {
                this.exception = Exception.class.isAssignableFrom(t.getClass()) ? (Exception)Exception.class.cast(t) : new Exception(t);
                if (this.this$0.listener != null) {
                    this.this$0.listener.transferFailed(this.this$0.newEvent(transferResource, this.exception, TransferEvent.RequestType.GET, TransferEvent.EventType.FAILED).build());
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        private boolean resourceExist(String uri) throws IOException {
            return this.this$0.aetherClient.head(uri).getStatusCode() == 200;
        }

        private void validateChecksums(File temporaryFileInLocalRepository, File fileInLocalRepository, String uri, TransferResource transferResource) throws Exception {
            block6: {
                boolean failOnInvalidOrMissingCheckums = "fail".equals(this.checksumPolicy);
                try {
                    Map<String, Object> checksums = ChecksumUtils.calc(temporaryFileInLocalRepository, this.this$0.checksumAlgos.keySet());
                    if (!this.verifyChecksum(temporaryFileInLocalRepository, fileInLocalRepository, uri, (String)checksums.get("SHA-1"), ".sha1")) {
                        throw new ChecksumFailureException("Checksum validation failed, no checksums available from the repository");
                    }
                    if (!this.verifyChecksum(temporaryFileInLocalRepository, fileInLocalRepository, uri, (String)checksums.get("MD5"), ".md5")) {
                        throw new ChecksumFailureException("Checksum validation failed, no checksums available from the repository");
                    }
                }
                catch (Exception e) {
                    if (this.this$0.listener != null) {
                        this.this$0.listener.transferCorrupted(this.this$0.newEvent(transferResource, e, TransferEvent.RequestType.GET, TransferEvent.EventType.CORRUPTED).build());
                    }
                    if (!failOnInvalidOrMissingCheckums) break block6;
                    if (this.this$0.listener != null) {
                        this.this$0.listener.transferFailed(this.this$0.newEvent(transferResource, e, TransferEvent.RequestType.GET, TransferEvent.EventType.FAILED).build());
                    }
                    throw e;
                }
            }
        }

        private boolean verifyChecksum(File temporaryFileInLocalRepository, File fileInLocalRepository, String uri, String actual, String ext) throws ChecksumFailureException {
            String checksumUri = uri + ext;
            File checksumFileInLocalRepository = new File(temporaryFileInLocalRepository.getParentFile(), fileInLocalRepository.getName() + ext);
            TransferResource transferResource = new TransferResource(this.this$0.repository.getUrl(), checksumUri, checksumFileInLocalRepository, ((Transfer)this.download).getTrace());
            try {
                FileTransfer temporaryChecksumFile = this.resumableGet(checksumUri, checksumFileInLocalRepository, transferResource, TransferEvent.RequestType.GET, null);
                String expected = ChecksumUtils.read(temporaryChecksumFile.file);
                if (!expected.equalsIgnoreCase(actual)) {
                    throw new ChecksumFailureException(expected, actual);
                }
                this.rename(temporaryChecksumFile.file, checksumFileInLocalRepository);
            }
            catch (Exception e) {
                throw new ChecksumFailureException(e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileTransfer resumableGet(String uri, File fileInLocalRepository, TransferResource transferResource, TransferEvent.RequestType requestType, TransferListener listener) throws Exception {
            long bytesTransferred = 0L;
            boolean downloadSuccessful = false;
            boolean resumeDownloadInProgress = false;
            File temporaryFileInLocalRepository = null;
            for (int retries = 0; retries < 10; ++retries) {
                String contentLength;
                Response response;
                File[] files;
                for (File inProgress : files = fileInLocalRepository.getParentFile().listFiles()) {
                    if (!inProgress.getName().startsWith("aether") || !inProgress.getName().endsWith(fileInLocalRepository.getName() + "-in-progress")) continue;
                    temporaryFileInLocalRepository = inProgress;
                    resumeDownloadInProgress = true;
                    break;
                }
                if (temporaryFileInLocalRepository == null) {
                    temporaryFileInLocalRepository = this.this$0.getTmpFile(fileInLocalRepository.getPath());
                }
                if (resumeDownloadInProgress) {
                    HashMap<String, String> requestHeaders = new HashMap<String, String>();
                    requestHeaders.put("Range", "bytes=" + temporaryFileInLocalRepository.length() + "-");
                    requestHeaders.put("Accept-Encoding", "identity");
                    response = this.this$0.aetherClient.get(uri, requestHeaders);
                } else {
                    response = this.this$0.aetherClient.get(uri);
                }
                this.this$0.handleResponseCode(uri, response.getStatusCode(), response.getStatusMessage());
                if (resumeDownloadInProgress && response.getHeader("Accept-Ranges") == null && response.getStatusCode() == 200) {
                    temporaryFileInLocalRepository.delete();
                }
                if (listener != null && (contentLength = response.getHeader("Content-Length")) != null) {
                    long length = Long.parseLong(contentLength);
                    transferResource.setContentLength(length);
                    listener.transferStarted(this.this$0.newEvent(transferResource, null, requestType, TransferEvent.EventType.STARTED).setTransferredBytes(bytesTransferred).build());
                }
                Closer closer = Closer.create();
                byte[] buffer = new byte[0x100000];
                int n = 0;
                try {
                    InputStream is = closer.register(response.getInputStream());
                    OutputStream os = closer.register(new BufferedOutputStream(new FileOutputStream(temporaryFileInLocalRepository, resumeDownloadInProgress)));
                    while (-1 != (n = is.read(buffer))) {
                        os.write(buffer, 0, n);
                        if (listener != null) {
                            listener.transferProgressed(this.this$0.newEvent(transferResource, null, requestType, TransferEvent.EventType.PROGRESSED).setTransferredBytes(n).setDataBuffer(buffer, 0, n).build());
                        }
                        bytesTransferred += (long)n;
                    }
                    downloadSuccessful = true;
                    continue;
                }
                catch (IOException e) {
                    this.exception = e;
                    return this.exception;
                }
                finally {
                    closer.close();
                    if (!downloadSuccessful) continue;
                    this.exception = null;
                    break;
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return new FileTransfer(temporaryFileInLocalRepository, bytesTransferred);
        }

        public void flush() {
            this.wrapper.wrap(this.download, this.exception, this.this$0.repository);
            ((Transfer)this.download).setState(Transfer.State.DONE);
        }

        private void rename(File from, File to) throws IOException {
            this.this$0.fileProcessor.move(from, to);
        }

        class FileTransfer {
            File file;
            long bytesTransferred;

            FileTransfer(File file, long bytesTransferred) {
                this.file = file;
                this.bytesTransferred = bytesTransferred;
            }
        }
    }

    class FileSource
    implements RetryableSource {
        private long bytesTransferred = 0L;
        private final TransferResource resource;
        private TransferCancelledException exception;

        public FileSource(TransferResource transferResource) {
            this.resource = transferResource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(OutputStream os) throws IOException {
            Closer closer = Closer.create();
            try {
                InputStream is = closer.register(new FileInputStream(this.resource.getFile()));
                closer.register(os);
                int n = 0;
                byte[] buffer = new byte[4096];
                while (-1 != (n = is.read(buffer))) {
                    os.write(buffer, 0, n);
                    if (AetherRepositoryConnector.this.listener != null) {
                        AetherRepositoryConnector.this.listener.transferProgressed(AetherRepositoryConnector.this.newEvent(this.resource, null, TransferEvent.RequestType.PUT, TransferEvent.EventType.PROGRESSED).setTransferredBytes(this.bytesTransferred).setDataBuffer(buffer, 0, n).build());
                    }
                    this.bytesTransferred += (long)n;
                }
            }
            catch (TransferCancelledException e) {
                this.exception = e;
            }
            finally {
                closer.close();
            }
        }

        @Override
        public long length() {
            return this.resource.getFile().length();
        }

        public TransferCancelledException getException() {
            return this.exception;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }
    }
}

