/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ATKGraphicsUtils {
    private static FontRenderContext frc = null;
    static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public static Dimension measureString(String s, Font f) {
        ATKGraphicsUtils.init();
        if (f != null && s != null) {
            Rectangle2D bounds = f.getStringBounds(s, frc);
            int w = (int)(bounds.getWidth() + 0.5);
            int h = (int)(bounds.getHeight() + 0.5);
            return new Dimension(w, h);
        }
        return new Dimension(0, 0);
    }

    public static FontRenderContext getDefaultRenderContext() {
        ATKGraphicsUtils.init();
        return frc;
    }

    public static LineMetrics getLineMetrics(String s, Font f) {
        ATKGraphicsUtils.init();
        return f.getLineMetrics(s, frc);
    }

    public static void centerDialog(Dialog dlg, int dlgWidth, int dlgHeight) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (dlg.getParent() != null && dlg.getParent().isVisible()) {
            r = dlg.getParent().getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = ATKGraphicsUtils.screenSize.width;
            r.height = ATKGraphicsUtils.screenSize.height;
        }
        dlg.pack();
        Insets insets = dlg.getInsets();
        int wx = dlgWidth + (insets.right + insets.left);
        int wy = dlgHeight + (insets.bottom + insets.top);
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe + wx > ATKGraphicsUtils.screenSize.width) {
            xe = ATKGraphicsUtils.screenSize.width - wx;
        }
        if (ye + wy > ATKGraphicsUtils.screenSize.height) {
            ye = ATKGraphicsUtils.screenSize.height - wy;
        }
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        dlg.setBounds(xe, ye, wx, wy);
    }

    public static void centerDialog(Dialog dlg) {
        dlg.pack();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (dlg.getParent() != null && dlg.getParent().isVisible()) {
            r = dlg.getParent().getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = ATKGraphicsUtils.screenSize.width;
            r.height = ATKGraphicsUtils.screenSize.height;
        }
        int wx = dlg.getPreferredSize().width;
        int wy = dlg.getPreferredSize().height;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe + wx > ATKGraphicsUtils.screenSize.width) {
            xe = ATKGraphicsUtils.screenSize.width - wx;
        }
        if (ye + wy > ATKGraphicsUtils.screenSize.height) {
            ye = ATKGraphicsUtils.screenSize.height - wy;
        }
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        dlg.setBounds(xe, ye, wx, wy);
    }

    public static void centerFrameOnScreen(Frame fr) {
        int wy;
        Rectangle r = new Rectangle(0, 0, ATKGraphicsUtils.screenSize.width, ATKGraphicsUtils.screenSize.height);
        fr.pack();
        int wx = fr.getPreferredSize().width;
        if (wx > ATKGraphicsUtils.screenSize.width) {
            wx = ATKGraphicsUtils.screenSize.width;
        }
        if ((wy = fr.getPreferredSize().height) > ATKGraphicsUtils.screenSize.height) {
            wy = ATKGraphicsUtils.screenSize.height;
        }
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        fr.setBounds(xe, ye, wx, wy);
    }

    public static void centerFrame(JComponent parent, Frame fr) {
        fr.pack();
        Window parentWin = ATKGraphicsUtils.getWindowForComponent(parent);
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (parentWin != null && parentWin.isVisible()) {
            r = parentWin.getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = ATKGraphicsUtils.screenSize.width;
            r.height = ATKGraphicsUtils.screenSize.height;
        }
        int wx = fr.getPreferredSize().width;
        int wy = fr.getPreferredSize().height;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe + wx > ATKGraphicsUtils.screenSize.width) {
            xe = ATKGraphicsUtils.screenSize.width - wx;
        }
        if (ye + wy > ATKGraphicsUtils.screenSize.height) {
            ye = ATKGraphicsUtils.screenSize.height - wy;
        }
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        fr.setBounds(xe, ye, wx, wy);
    }

    public static Window getWindowForComponent(Component aComponent) {
        if (aComponent == null) {
            return null;
        }
        if (aComponent instanceof Frame || aComponent instanceof Dialog) {
            return (Window)aComponent;
        }
        return ATKGraphicsUtils.getWindowForComponent(aComponent.getParent());
    }

    public static void printComponent(JComponent comp, String title, boolean fitToPage, int printerResolution) {
        PrintJob printJob;
        PageAttributes pa = new PageAttributes();
        JobAttributes ja = new JobAttributes();
        pa.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
        pa.setColor(PageAttributes.ColorType.COLOR);
        pa.setMedia(PageAttributes.MediaType.A4);
        if (fitToPage) {
            pa.setPrinterResolution(72);
        } else {
            pa.setPrinterResolution(printerResolution);
        }
        ja.setMaxPage(1);
        ja.setMinPage(1);
        ja.setDialog(JobAttributes.DialogType.NATIVE);
        Window parent = ATKGraphicsUtils.getWindowForComponent(comp);
        if (parent instanceof Frame) {
            printJob = Toolkit.getDefaultToolkit().getPrintJob((Frame)parent, title, ja, pa);
        } else {
            Frame dummy = new Frame();
            printJob = Toolkit.getDefaultToolkit().getPrintJob(dummy, title, ja, pa);
        }
        if (printJob != null) {
            int w = comp.getSize().width;
            int h = comp.getSize().height;
            BufferedImage img = new BufferedImage(w, h, 1);
            Color oldBackground = comp.getBackground();
            comp.setBackground(Color.WHITE);
            comp.paint(img.getGraphics());
            comp.setBackground(oldBackground);
            try {
                int ty;
                int tx;
                if (fitToPage) {
                    double nResolution;
                    int wp = printJob.getPageDimension().width - 72;
                    double ratioW = (double)w / (double)wp;
                    int hp = printJob.getPageDimension().height - 72;
                    double ratioH = (double)h / (double)hp;
                    if (ratioW > ratioH) {
                        nResolution = 72.0 * ratioW;
                        tx = (int)(nResolution * 0.5);
                        double cH = nResolution / 72.0 * (double)hp - (double)h;
                        ty = (int)(0.5 * (nResolution + cH));
                    } else {
                        nResolution = 72.0 * ratioH;
                        double cW = nResolution / 72.0 * (double)wp - (double)w;
                        tx = (int)(0.5 * (nResolution + cW));
                        ty = (int)(nResolution * 0.5);
                    }
                    pa.setPrinterResolution((int)(nResolution + 0.5));
                } else {
                    tx = printerResolution / 2;
                    ty = printerResolution / 2;
                }
                Graphics g = printJob.getGraphics();
                if (g != null) {
                    g.translate(tx, ty);
                    g.setClip(0, 0, w, h);
                    g.drawImage(img, 0, 0, null);
                    g.dispose();
                } else {
                    JOptionPane.showMessageDialog(parent, "Unexpected error while printing.\nCheck you printer", title, 0);
                }
                printJob.end();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(parent, "Exception occured while printing\n" + e.getMessage(), title, 0);
            }
        }
    }

    public static void positionFrameOnScreen(Frame fr, int posx, int posy) {
        int ye;
        int xe;
        int wy;
        Rectangle r = new Rectangle(0, 0, ATKGraphicsUtils.screenSize.width, ATKGraphicsUtils.screenSize.height);
        fr.pack();
        int wx = fr.getPreferredSize().width;
        if (wx > ATKGraphicsUtils.screenSize.width) {
            wx = ATKGraphicsUtils.screenSize.width;
        }
        if ((wy = fr.getPreferredSize().height) > ATKGraphicsUtils.screenSize.height) {
            wy = ATKGraphicsUtils.screenSize.height;
        }
        if (posx + wx > ATKGraphicsUtils.screenSize.width) {
            xe = ATKGraphicsUtils.screenSize.width - wx;
            if (xe < 0) {
                xe = 0;
            }
        } else {
            xe = posx;
        }
        if (posy + wy > ATKGraphicsUtils.screenSize.height) {
            ye = ATKGraphicsUtils.screenSize.height - wy;
            if (ye < 0) {
                ye = 0;
            }
        } else {
            ye = posy;
        }
        fr.setBounds(xe, ye, wx, wy);
    }

    private static int[] parseWindowPosition(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return null;
        }
        String[] posStrs = str.split(",");
        if (posStrs == null) {
            return null;
        }
        if (posStrs.length != 2) {
            return null;
        }
        int posX = -1;
        int posY = -1;
        try {
            posX = Integer.parseInt(posStrs[0]);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        try {
            posY = Integer.parseInt(posStrs[1]);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (posX >= 0 && posY >= 0) {
            int[] wPos = new int[]{posX, posY};
            return wPos;
        }
        return null;
    }

    public static int[] getWindowPosFromArgs(String[] args) {
        if (args.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-wpos")) {
                if (i == args.length - 1) {
                    return null;
                }
                String wposStr = args[++i];
                int[] windowPos = ATKGraphicsUtils.parseWindowPosition(wposStr);
                return windowPos;
            }
            ++i;
        }
        return null;
    }

    private static void init() {
        if (frc == null) {
            BufferedImage img = new BufferedImage(10, 10, 1);
            Graphics2D g = (Graphics2D)img.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            frc = g.getFontRenderContext();
            g.dispose();
        }
    }
}

