/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.Headers;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.java.JavaAttribute;
import fr.esrf.tango.pogo.generator.java.JavaCommand;
import fr.esrf.tango.pogo.generator.java.JavaDynamicAttribute;
import fr.esrf.tango.pogo.generator.java.JavaDynamicCommand;
import fr.esrf.tango.pogo.generator.java.JavaPipe;
import fr.esrf.tango.pogo.generator.java.JavaUtils;
import fr.esrf.tango.pogo.generator.java.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class JavaDevice
implements IGenerator {
    @Inject
    @Extension
    private JavaUtils _javaUtils;
    @Inject
    @Extension
    private JavaAttribute _javaAttribute;
    @Inject
    @Extension
    private JavaPipe _javaPipe;
    @Inject
    @Extension
    private JavaDynamicAttribute _javaDynamicAttribute;
    @Inject
    @Extension
    private JavaDynamicCommand _javaDynamicCommand;
    @Inject
    @Extension
    private JavaCommand _javaCommand;
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            EList<Attribute> _dynamicAttributes;
            boolean _isEmpty_1;
            boolean _equals_2;
            boolean _equals_1;
            ClassDescription _description_1;
            String _filestogenerate;
            boolean _contains;
            ClassDescription _description = cls.getDescription();
            String _language = _description.getLanguage();
            String _lowerCase = _language.toLowerCase();
            boolean _equals = _lowerCase.equals("java");
            if (!_equals || !(_contains = (_filestogenerate = (_description_1 = cls.getDescription()).getFilestogenerate()).contains("Code files"))) continue;
            String _javaDeviceClassFileName = this._javaUtils.javaDeviceClassFileName(cls, true);
            String _plus = "Generating " + _javaDeviceClassFileName;
            StringUtils.printTrace(_plus);
            String _javaDeviceClassFileName_1 = this._javaUtils.javaDeviceClassFileName(cls, true);
            CharSequence _generateJavaDeviceFile = this.generateJavaDeviceFile(cls);
            fsa.generateFile(_javaDeviceClassFileName_1, _generateJavaDeviceFile);
            EList<Command> _dynamicCommands = cls.getDynamicCommands();
            boolean _isEmpty = _dynamicCommands.isEmpty();
            boolean bl = _equals_1 = !_isEmpty;
            if (_equals_1) {
                EList<Command> _dynamicCommands_1 = cls.getDynamicCommands();
                for (Command command : _dynamicCommands_1) {
                    String _name = command.getName();
                    String _javaDynamicObjectFileName = this._javaUtils.javaDynamicObjectFileName(cls, _name);
                    String _plus_1 = "Generating " + _javaDynamicObjectFileName;
                    StringUtils.printTrace(_plus_1);
                    String _name_1 = command.getName();
                    String _javaDynamicObjectFileName_1 = this._javaUtils.javaDynamicObjectFileName(cls, _name_1);
                    CharSequence _generateJavaDynamicCommandClassFile = this._javaDynamicCommand.generateJavaDynamicCommandClassFile(cls, command);
                    fsa.generateFile(_javaDynamicObjectFileName_1, _generateJavaDynamicCommandClassFile);
                }
            }
            boolean bl2 = _equals_2 = !(_isEmpty_1 = (_dynamicAttributes = cls.getDynamicAttributes()).isEmpty());
            if (!_equals_2) continue;
            EList<Attribute> _dynamicAttributes_1 = cls.getDynamicAttributes();
            for (Attribute attribute : _dynamicAttributes_1) {
                String _name = attribute.getName();
                String _javaDynamicObjectFileName = this._javaUtils.javaDynamicObjectFileName(cls, _name);
                String _plus_1 = "Generating " + _javaDynamicObjectFileName;
                StringUtils.printTrace(_plus_1);
                String _name_1 = attribute.getName();
                String _javaDynamicObjectFileName_1 = this._javaUtils.javaDynamicObjectFileName(cls, _name_1);
                CharSequence _generateJavaDynamicAttributeClassFile = this._javaDynamicAttribute.generateJavaDynamicAttributeClassFile(cls, attribute);
                fsa.generateFile(_javaDynamicObjectFileName_1, _generateJavaDynamicAttributeClassFile);
            }
        }
    }

    public CharSequence generateJavaDeviceFile(PogoDeviceClass cls) {
        boolean _greaterThan_3;
        boolean _greaterThan_2;
        boolean _greaterThan_1;
        boolean _greaterThan;
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _javaHeader = this.javaHeader(cls);
        _builder.append((Object)_javaHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*  ");
        String _name = cls.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" class description:");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*    ");
        ClassDescription _description = cls.getDescription();
        String _description_1 = _description.getDescription();
        String _comments = StringUtils.comments(_description_1, "*    ");
        _builder.append((Object)_comments, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Device");
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        String _inheritance = this._javaUtils.getInheritance(cls);
        _builder.append((Object)_inheritance, "");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasInheritanceClass = this._javaUtils.hasInheritanceClass(cls);
        boolean bl = _equals = !_hasInheritanceClass;
        if (_equals) {
            _builder.append("\t");
            _builder.append("protected static final Logger logger = LoggerFactory.getLogger(");
            String _name_2 = cls.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append(".class);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("protected static final XLogger xlogger = XLoggerFactory.getXLogger(");
            String _name_3 = cls.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append(".class);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tProgrammer's data members");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("    ");
        String _protectedArea = this._protectedArea.protectedArea(cls, "variables", "Put static variables here", true);
        _builder.append((Object)_protectedArea, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "private", "Put private variables here", true);
        _builder.append((Object)_protectedArea_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tProperty data members and related methods");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _addClassProperties = this.addClassProperties(cls);
        _builder.append((Object)_addClassProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _addDeviceProperties = this.addDeviceProperties(cls);
        _builder.append((Object)_addDeviceProperties, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tMiscellaneous methods");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _initDeviceMethod = this.initDeviceMethod(cls);
        _builder.append((Object)_initDeviceMethod, "\t");
        _builder.newLineIfNotEmpty();
        EList<ForwardedAttribute> _forwardedAttributes = cls.getForwardedAttributes();
        int _size = _forwardedAttributes.size();
        boolean bl2 = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            CharSequence _addForwardedAttributes = this._javaAttribute.addForwardedAttributes(cls);
            _builder.append((Object)_addForwardedAttributes, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        CharSequence _deleteDeviceMethod = this.deleteDeviceMethod(cls);
        _builder.append((Object)_deleteDeviceMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _aroundInvokeMethod = this.aroundInvokeMethod(cls);
        _builder.append((Object)_aroundInvokeMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _dynamicManagerMethod = this.dynamicManagerMethod(cls);
        _builder.append((Object)_dynamicManagerMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        int _size_1 = _attributes.size();
        boolean bl3 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append("\t");
            _builder.append("//========================================================");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tAttribute data members and related methods");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//========================================================");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _attributeMethods = this._javaAttribute.attributeMethods(cls);
            _builder.append((Object)_attributeMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList<Pipe> _pipes = cls.getPipes();
        int _size_2 = _pipes.size();
        boolean bl4 = _greaterThan_2 = _size_2 > 0;
        if (_greaterThan_2) {
            _builder.append("\t");
            _builder.append("//========================================================");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tPipe data members and related methods");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//========================================================");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _pipeMethods = this._javaPipe.pipeMethods(cls);
            _builder.append((Object)_pipeMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList<Command> _commands = cls.getCommands();
        int _size_3 = _commands.size();
        boolean bl5 = _greaterThan_3 = _size_3 > 0;
        if (_greaterThan_3) {
            _builder.append("\t");
            _builder.append("//========================================================");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tCommand data members and related methods");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//========================================================");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _stateAndStatusMethods = this._javaCommand.stateAndStatusMethods(cls);
            _builder.append((Object)_stateAndStatusMethods, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _executeCommandMethods = this._javaCommand.executeCommandMethods(cls);
            _builder.append((Object)_executeCommandMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tProgrammer's methods");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//========================================================");
        _builder.newLine();
        _builder.append("\t");
        String _protectedArea_2 = this._protectedArea.protectedArea(cls, "methods", "Put your own methods here", true);
        _builder.append((Object)_protectedArea_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _mainMethod = this.mainMethod(cls);
        _builder.append((Object)_mainMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence javaHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _openProtectedArea = this._protectedArea.openProtectedArea(cls, ".java");
        _builder.append((Object)_openProtectedArea, "");
        _builder.newLineIfNotEmpty();
        String _javaDeviceClassFileName = this._javaUtils.javaDeviceClassFileName(cls, false);
        String _name = cls.getName();
        String _plus = "Java source for the " + _name;
        String _plus_1 = String.valueOf(_plus) + " class and its commands.\n";
        String _plus_2 = String.valueOf(_plus_1) + "The class is derived from Device. It represents the\n";
        String _plus_3 = String.valueOf(_plus_2) + "CORBA servant object which will be accessed from the\n";
        String _plus_4 = String.valueOf(_plus_3) + "network. All commands which can be executed on the\n";
        String _name_1 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_1;
        String _plus_6 = String.valueOf(_plus_5) + " are implemented in this file.";
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        ClassDescription _description_2 = cls.getDescription();
        String _copyright = _description_2.getCopyright();
        String _fileHeader = this._headers.fileHeader(_javaDeviceClassFileName, _plus_6, _title, _license, _copyright);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _closeProtectedArea = this._protectedArea.closeProtectedArea(cls, ".java");
        _builder.append((Object)_closeProtectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("package ");
        String _javaDevicePackage = this._javaUtils.javaDevicePackage(cls);
        _builder.append((Object)_javaDevicePackage, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _inheritancePackage = this._javaUtils.inheritancePackage(cls);
        String _plus_7 = "import org.slf4j.Logger;\nimport org.slf4j.LoggerFactory;\nimport org.slf4j.ext.XLogger;\nimport org.slf4j.ext.XLoggerFactory;\nimport org.tango.DeviceState;\nimport org.tango.server.InvocationContext;\nimport org.tango.server.ServerManager;\nimport org.tango.server.annotation.AroundInvoke;\nimport org.tango.server.annotation.Attribute;\nimport org.tango.server.annotation.AttributeProperties;\nimport org.tango.server.annotation.ClassProperty;\nimport org.tango.server.annotation.Command;\nimport org.tango.server.annotation.Delete;\nimport org.tango.server.annotation.Device;\nimport org.tango.server.annotation.DeviceProperty;\nimport org.tango.server.annotation.DynamicManagement;\nimport org.tango.server.annotation.Init;\nimport org.tango.server.annotation.State;\nimport org.tango.server.annotation.StateMachine;\nimport org.tango.server.annotation.Status;\nimport org.tango.server.annotation.DeviceManagement;\nimport org.tango.server.annotation.Pipe;\nimport org.tango.server.attribute.ForwardedAttribute;import org.tango.server.pipe.PipeValue;\nimport org.tango.server.dynamic.DynamicManager;\nimport org.tango.server.device.DeviceManager;\nimport org.tango.server.dynamic.DynamicManager;\nimport org.tango.server.events.EventManager;\nimport org.tango.server.events.EventType;\nimport org.tango.utils.DevFailedUtils;\n\n//\tImport Tango IDL types\nimport fr.esrf.Tango.*;\nimport fr.esrf.TangoDs.Except;\nimport fr.esrf.TangoApi.PipeBlob;\nimport fr.esrf.TangoApi.PipeDataElement;" + _inheritancePackage;
        String _protectedArea = this._protectedArea.protectedArea(cls, "imports", _plus_7, false);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence addClassProperties(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Property> _classProperties = cls.getClassProperties();
        for (Property property : _classProperties) {
            boolean _isConcreteHere = this._javaUtils.isConcreteHere(property);
            if (!_isConcreteHere) continue;
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Class Property ");
            String _name = property.getName();
            _builder.append((Object)_name, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* ");
            String _description = property.getDescription();
            String _comments = StringUtils.comments(_description, "* ");
            _builder.append((Object)_comments, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("@ClassProperty(name=\"");
            String _name_1 = property.getName();
            _builder.append((Object)_name_1, "");
            _builder.append("\", description=\"");
            String _description_1 = property.getDescription();
            String _oneLineString = this._javaUtils.oneLineString(_description_1);
            _builder.append((Object)_oneLineString, "");
            _builder.append("\" ");
            String _defaultValue = this._javaUtils.defaultValue(property);
            _builder.append((Object)_defaultValue, "");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("private ");
            String _strJavaType = this._javaUtils.strJavaType(property);
            _builder.append((Object)_strJavaType, "");
            _builder.append(" ");
            String _name_2 = property.getName();
            String _dataMemberName = this._javaUtils.dataMemberName(_name_2);
            _builder.append((Object)_dataMemberName, "");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* set property ");
            String _name_3 = property.getName();
            _builder.append((Object)_name_3, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* @param  ");
            String _name_4 = property.getName();
            String _dataMemberName_1 = this._javaUtils.dataMemberName(_name_4);
            _builder.append((Object)_dataMemberName_1, " ");
            _builder.append("  see description above.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("public void set");
            String _name_5 = property.getName();
            _builder.append((Object)_name_5, "");
            _builder.append("(");
            String _strJavaType_1 = this._javaUtils.strJavaType(property);
            _builder.append((Object)_strJavaType_1, "");
            _builder.append(" ");
            String _name_6 = property.getName();
            String _dataMemberName_2 = this._javaUtils.dataMemberName(_name_6);
            _builder.append((Object)_dataMemberName_2, "");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this.");
            String _name_7 = property.getName();
            String _dataMemberName_3 = this._javaUtils.dataMemberName(_name_7);
            _builder.append((Object)_dataMemberName_3, "\t");
            _builder.append(" = ");
            String _name_8 = property.getName();
            String _dataMemberName_4 = this._javaUtils.dataMemberName(_name_8);
            _builder.append((Object)_dataMemberName_4, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name_9 = property.getName();
            String _plus = "set" + _name_9;
            String _protectedArea = this._protectedArea.protectedArea(cls, _plus, "Check property value here", true);
            _builder.append((Object)_protectedArea, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence addDeviceProperties(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        for (Property property : _deviceProperties) {
            boolean _isConcreteHere = this._javaUtils.isConcreteHere(property);
            if (!_isConcreteHere) continue;
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Device Property ");
            String _name = property.getName();
            _builder.append((Object)_name, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* ");
            String _description = property.getDescription();
            String _comments = StringUtils.comments(_description, "* ");
            _builder.append((Object)_comments, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("@DeviceProperty(name=\"");
            String _name_1 = property.getName();
            _builder.append((Object)_name_1, "");
            _builder.append("\", description=\"");
            String _description_1 = property.getDescription();
            String _oneLineString = this._javaUtils.oneLineString(_description_1);
            _builder.append((Object)_oneLineString, "");
            _builder.append("\" ");
            String _defaultValue = this._javaUtils.defaultValue(property);
            _builder.append((Object)_defaultValue, "");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("private ");
            String _strJavaType = this._javaUtils.strJavaType(property);
            _builder.append((Object)_strJavaType, "");
            _builder.append(" ");
            String _name_2 = property.getName();
            String _dataMemberName = this._javaUtils.dataMemberName(_name_2);
            _builder.append((Object)_dataMemberName, "");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* set property ");
            String _name_3 = property.getName();
            _builder.append((Object)_name_3, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* @param  ");
            String _name_4 = property.getName();
            String _dataMemberName_1 = this._javaUtils.dataMemberName(_name_4);
            _builder.append((Object)_dataMemberName_1, " ");
            _builder.append("  see description above.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("public void set");
            String _name_5 = property.getName();
            _builder.append((Object)_name_5, "");
            _builder.append("(");
            String _strJavaType_1 = this._javaUtils.strJavaType(property);
            _builder.append((Object)_strJavaType_1, "");
            _builder.append(" ");
            String _name_6 = property.getName();
            String _dataMemberName_2 = this._javaUtils.dataMemberName(_name_6);
            _builder.append((Object)_dataMemberName_2, "");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this.");
            String _name_7 = property.getName();
            String _dataMemberName_3 = this._javaUtils.dataMemberName(_name_7);
            _builder.append((Object)_dataMemberName_3, "\t");
            _builder.append(" = ");
            String _name_8 = property.getName();
            String _dataMemberName_4 = this._javaUtils.dataMemberName(_name_8);
            _builder.append((Object)_dataMemberName_4, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _name_9 = property.getName();
            String _plus = "set" + _name_9;
            String _protectedArea = this._protectedArea.protectedArea(cls, _plus, "Check property value here", true);
            _builder.append((Object)_protectedArea, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence initDeviceMethod(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Initialize the device.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if something fails during the device initialization.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Init(lazyLoading = false)");
        _builder.newLine();
        _builder.append("public void initDevice() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("xlogger.entry();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("logger.debug(\"init device \" + deviceManager.getName());");
        _builder.newLine();
        _builder.append("\t");
        boolean _hasInheritanceClass = this._javaUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            _builder.append("super.initDevice();");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "initDevice", "Put your device initialization code here", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        EList<ForwardedAttribute> _forwardedAttributes = cls.getForwardedAttributes();
        int _size = _forwardedAttributes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("addForwardedAttributes();");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("xlogger.exit();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence deleteDeviceMethod(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* all resources may be closed here. Collections may be also cleared.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if something fails during the device object delation.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@Delete");
        _builder.newLine();
        _builder.append("public void deleteDevice() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("xlogger.entry();");
        _builder.newLine();
        _builder.append("\t");
        boolean _hasInheritanceClass = this._javaUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            _builder.append("super.deleteDevice();");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "deleteDevice", "Put your device clearing code here", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("xlogger.exit();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence aroundInvokeMethod(PogoDeviceClass cls) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasInheritanceClass = this._javaUtils.hasInheritanceClass(cls);
        boolean bl = _equals = !_hasInheritanceClass;
        if (_equals) {
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Method called before and after command and attribute calls.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param ctx the invocation context");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @throws DevFailed if something fails during this method execution.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("@AroundInvoke");
            _builder.newLine();
            _builder.append("public void aroundInvoke(final InvocationContext ctx) throws DevFailed {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("xlogger.entry();");
            _builder.newLine();
            boolean _hasInheritanceClass_1 = this._javaUtils.hasInheritanceClass(cls);
            if (_hasInheritanceClass_1) {
                _builder.append("\t");
                String _protectedArea = this._protectedArea.protectedArea(cls, "aroundInvoke", "super.aroundInvoke(ctx);", false);
                _builder.append((Object)_protectedArea, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("\t");
                String _protectedArea_1 = this._protectedArea.protectedArea(cls, "aroundInvoke", "Put aroundInvoke code here", true);
                _builder.append((Object)_protectedArea_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("xlogger.exit();");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence dynamicManagerMethod(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* dynamic command and attribute management. Will be injected by the framework.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@DynamicManagement");
        _builder.newLine();
        _builder.append("protected DynamicManager dynamicManager;");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param dynamicManager the DynamicManager instance ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if something fails during this method execution.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public void setDynamicManager(final DynamicManager dynamicManager) throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.dynamicManager = dynamicManager;");
        _builder.newLine();
        _builder.append("\t");
        boolean _hasInheritanceClass = this._javaUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            _builder.append("super.setDynamicManager(dynamicManager);");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "setDynamicManager", "Put your code here", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Device management. Will be injected by the framework.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("@DeviceManagement");
        _builder.newLine();
        _builder.append("DeviceManager deviceManager;");
        _builder.newLine();
        _builder.append("public void setDeviceManager(DeviceManager deviceManager){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.deviceManager= deviceManager ;");
        _builder.newLine();
        _builder.append("\t");
        boolean _hasInheritanceClass_1 = this._javaUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass_1) {
            _builder.append("super.setDeviceManager(deviceManager);");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence mainMethod(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Starts the server.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param args program arguments (instance_name [-v[trace level]]  [-nodb [-dlist <device name list>] [-file=fileName]])");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public static void main(final String[] args) {");
        _builder.newLine();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "main");
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ServerManager.getInstance().start(args, ");
        String _name = cls.getName();
        _builder.append((Object)_name, "\t");
        _builder.append(".class);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("System.out.println(\"------- Started -------------\");");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

