/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.html;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.html.HtmlUtils;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class HtmlCommands
implements IGenerator {
    @Inject
    @Extension
    private HtmlUtils _htmlUtils;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description = cls.getDescription();
            String _filestogenerate = _description.getFilestogenerate();
            boolean _contains = _filestogenerate.contains("html");
            if (!_contains) continue;
            StringUtils.printTrace("Generating doc_html/Commands.html");
            CharSequence _generateHtmlCommandsFile = this.generateHtmlCommandsFile(cls, true);
            fsa.generateFile("doc_html/Commands.html", _generateHtmlCommandsFile);
            EList<Command> _commands = cls.getCommands();
            for (Command command : _commands) {
                String _name = command.getName();
                String _plus = "Generating doc_html/Cmd" + _name;
                String _plus_1 = String.valueOf(_plus) + ".html";
                StringUtils.printTrace(_plus_1);
                String _name_1 = command.getName();
                String _plus_2 = "doc_html/Cmd" + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + ".html";
                CharSequence _generateHtmlOneCommandFile = this.generateHtmlOneCommandFile(cls, command, true);
                fsa.generateFile(_plus_3, _generateHtmlOneCommandFile);
            }
        }
    }

    public CharSequence generateHtmlCommandsFile(PogoDeviceClass cls, boolean withHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (withHeader) {
            String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls, "Commands");
            _builder.append((Object)_htmlFileHeader, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br><br>");
        _builder.newLine();
        EList<Command> _commands = cls.getCommands();
        String _name = cls.getName();
        String _htmlCommandsTable = this._htmlUtils.htmlCommandsTable(_commands, _name);
        _builder.append((Object)_htmlCommandsTable, "");
        _builder.newLineIfNotEmpty();
        if (withHeader) {
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateHtmlOneCommandFile(PogoDeviceClass cls, Command command, boolean withHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (withHeader) {
            String _name = command.getName();
            String _plus = "Command " + _name;
            String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls, _plus);
            _builder.append((Object)_htmlFileHeader, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br>");
        _builder.newLine();
        String _name_1 = command.getName();
        String _plus_1 = "Command " + _name_1;
        String _plus_2 = String.valueOf(_plus_1) + " :";
        String _htmlTitle = this._htmlUtils.htmlTitle(_plus_2);
        _builder.append((Object)_htmlTitle, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<ul>");
        _builder.newLine();
        _builder.append("\t");
        String _description = command.getDescription();
        String _checkSpecialChars = HtmlUtils.checkSpecialChars(_description);
        String _htmlStringWithBreak = this._htmlUtils.htmlStringWithBreak(_checkSpecialChars);
        _builder.append((Object)_htmlStringWithBreak, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</ul>");
        _builder.newLine();
        _builder.append("<br><br><br>");
        _builder.newLine();
        String _htmlOneCommandTable = this._htmlUtils.htmlOneCommandTable(command);
        _builder.append((Object)_htmlOneCommandTable, "");
        _builder.newLineIfNotEmpty();
        if (withHeader) {
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
        }
        return _builder;
    }
}

