/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.utils;

import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppTypeDefinitions;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

public class CppStringUtils
extends StringUtils {
    public String strType(Attribute attribute) {
        return CppTypeDefinitions.cppType(attribute.getDataType());
    }

    public String addDynamicAttributeHeaderComment(Attribute attribute) {
        String comment = " *  parameter attname: attribute name to be cretated and added.\n";
        if (!this.isScalar(attribute)) {
            comment = String.valueOf(comment) + " *  parameter ptr:     memory buffer used to set attribute value.\n *                     If NULL or not specified, buffer will be allocated.";
        }
        return comment;
    }

    public String removeDynamicAttributeHeaderComment(Attribute attribute) {
        String comment = " *  parameter attname: attribute name to be removed.\n";
        if (!this.isScalar(attribute)) {
            comment = String.valueOf(comment) + " *  parameter free_it: memory buffer will be freed if true or not specified.";
        }
        return comment;
    }

    public String addDynamicAttributeSignature(PogoDeviceClass cls, Attribute attribute, boolean prototype) {
        String signature = "void ";
        if (!prototype) {
            signature = String.valueOf(signature) + cls.getName() + "::";
        }
        signature = String.valueOf(signature) + "add_" + attribute.getName() + "_dynamic_attribute(string attname";
        if (!this.isScalar(attribute)) {
            signature = String.valueOf(signature) + ", " + this.strType(attribute) + " *ptr";
            if (prototype) {
                signature = String.valueOf(signature) + "=NULL";
            }
        }
        signature = String.valueOf(signature) + ")";
        if (prototype) {
            signature = String.valueOf(signature) + ";";
        }
        return signature;
    }

    public String removeDynamicAttributeSignature(PogoDeviceClass cls, Attribute attribute, boolean prototype) {
        String signature = "void ";
        if (!prototype) {
            signature = String.valueOf(signature) + cls.getName() + "::";
        }
        signature = String.valueOf(signature) + "remove_" + attribute.getName() + "_dynamic_attribute(string attname";
        if (!this.isScalar(attribute)) {
            signature = String.valueOf(signature) + ", bool free_it";
            if (prototype) {
                signature = String.valueOf(signature) + "=true";
            }
        }
        signature = String.valueOf(signature) + ")";
        if (prototype) {
            signature = String.valueOf(signature) + ";";
        }
        return signature;
    }

    public String addDynamicCommandHeaderComment(Command command) {
        String comment = " *  parameter cmdname: command name to be cretated and added.\n *  parameter device:  Set this flag to true if the command must be added for only this device.\n";
        return comment;
    }

    public String removeDynamicCommandHeaderComment(Command command) {
        String comment = " *  parameter cmdname: command name to be removed.\n";
        return comment;
    }

    public String addDynamicCommandSignature(PogoDeviceClass cls, Command command, boolean prototype) {
        String signature = "void ";
        if (!prototype) {
            signature = String.valueOf(signature) + cls.getName() + "::";
        }
        signature = String.valueOf(signature) + "add_" + command.getName() + "_dynamic_command(string cmdname, bool device)";
        if (prototype) {
            signature = String.valueOf(signature) + ";";
        }
        return signature;
    }

    public String removeDynamicCommandSignature(PogoDeviceClass cls, Command command, boolean prototype) {
        String signature = "void ";
        if (!prototype) {
            signature = String.valueOf(signature) + cls.getName() + "::";
        }
        signature = String.valueOf(signature) + "remove_" + command.getName() + "_dynamic_command(string cmdname)";
        if (prototype) {
            signature = String.valueOf(signature) + ";";
        }
        return signature;
    }

    public static String statesTable(EList<State> states) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{"================================================================"});
        list.add(new String[]{"States", "Description"});
        list.add(new String[]{"================================================================"});
        for (State state : states) {
            list.add(new String[]{state.getName(), state.getDescription()});
        }
        return CppStringUtils.buildTable(list);
    }

    public String commandsTable(EList<Command> commands) {
        InheritanceUtils inher = new InheritanceUtils();
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{"================================================================"});
        list.add(new String[]{"  The following table gives the correspondence"});
        list.add(new String[]{"  between command and method names."});
        list.add(new String[]{""});
        list.add(new String[]{"Command name", "Method name"});
        list.add(new String[]{"================================================================"});
        for (Command command : commands) {
            if (inher.isConcreteHere(command)) {
                list.add(new String[]{command.getName(), command.getExecMethod()});
                continue;
            }
            list.add(new String[]{command.getName(), "Inherited (no method)"});
        }
        list.add(new String[]{"================================================================"});
        return CppStringUtils.buildTable(list);
    }

    public String attributesTable(EList<Attribute> attributes) {
        String title = "  Attributes managed ";
        title = attributes.size() > 1 ? String.valueOf(title) + "are:" : String.valueOf(title) + "is:";
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{"================================================================"});
        list.add(new String[]{title});
        list.add(new String[]{"================================================================"});
        for (Attribute attribute : attributes) {
            String desc = String.valueOf(CppTypeDefinitions.cppType(attribute.getDataType())) + "\t" + attribute.getAttType();
            if (!attribute.getAttType().equals("Scalar")) {
                desc = String.valueOf(desc) + "  (" + this.attTypeDimentions(attribute) + ")";
            }
            list.add(new String[]{attribute.getName(), desc});
        }
        list.add(new String[]{"================================================================"});
        return CppStringUtils.buildTable(list);
    }

    private static String buildTable(ArrayList<String[]> list) {
        StringBuffer sb = new StringBuffer();
        int length = 0;
        for (String[] array : list) {
            if (array.length <= 1 || array[0].length() <= length) continue;
            length = array[0].length();
        }
        String emptyTab = "//  ";
        int i = 0;
        while (i < length) {
            emptyTab = String.valueOf(emptyTab) + " ";
            ++i;
        }
        for (String[] array : list) {
            if (array.length > 1) {
                String comments = CppStringUtils.comments(array[1], String.valueOf(emptyTab) + "  |  ");
                sb.append("//  ").append(CppStringUtils.buildTab(array[0], length)).append("  |  ").append(comments);
            } else {
                sb.append("//").append(array[0]);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String buildTab(String str, int nbChar) {
        StringBuffer sb = new StringBuffer(str);
        int i = str.length();
        while (i < nbChar) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static String readWithWrite(Attribute attribute) {
        if (attribute.getRwType().contains("WITH_WRITE")) {
            return ", \"" + attribute.getAssociatedAttr() + "\"";
        }
        return "";
    }

    public static boolean hasWritableAttribute(PogoDeviceClass cls) {
        EList<Attribute> attributes = cls.getAttributes();
        for (Attribute attribute : attributes) {
            String str = attribute.getRwType();
            if (!CppStringUtils.isSet(str) || !str.contains("WRITE")) continue;
            return true;
        }
        return false;
    }

    public static String commandParameterHeader(Command command) {
        String str = "";
        if (!CppTypeDefinitions.cppType(command.getArgin().getType()).equals("void")) {
            str = String.valueOf(str) + " *\t@param argin " + StringUtils.comments(command.getArgin().getDescription(), " *               ") + "\n";
        }
        if (!CppTypeDefinitions.cppType(command.getArgout().getType()).equals("void")) {
            str = String.valueOf(str) + " *\t@returns " + StringUtils.comments(command.getArgout().getDescription(), " *           ") + "\n";
        }
        return str;
    }

    public String manageEnumForMethodHeader(Attribute attribute) {
        String returnStr = "";
        if (this.strType(attribute).contains("DevEnum")) {
            returnStr = " (" + attribute.getName() + "Enum)";
        }
        return returnStr;
    }

    public String buildEnum(Attribute attribute) {
        if (this.strType(attribute).contains("DevEnum")) {
            StringBuilder sb = new StringBuilder("enum _" + attribute.getName() + "Enum {\n");
            for (String label : attribute.getEnumLabels()) {
                sb.append("\t").append(CppStringUtils.label2enum(label)).append(",\n");
            }
            sb.append("} ").append(";\n");
            sb.append("typedef _").append(attribute.getName()).append("Enum ").append(attribute.getName()).append("Enum;\n\n");
            return sb.toString();
        }
        return "";
    }

    public String buildEnums(PogoDeviceClass pogoClass) {
        StringBuilder sb = new StringBuilder();
        for (Attribute attribute : pogoClass.getAttributes()) {
            sb.append(this.buildEnum(attribute));
        }
        for (Attribute attribute : pogoClass.getDynamicAttributes()) {
            sb.append(this.buildEnum(attribute));
        }
        return sb.toString();
    }
}

