/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.EclipseProjects;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.ClassFactory;
import fr.esrf.tango.pogo.generator.cpp.DeviceClassInclude;
import fr.esrf.tango.pogo.generator.cpp.DeviceClassSource;
import fr.esrf.tango.pogo.generator.cpp.DeviceInclude;
import fr.esrf.tango.pogo.generator.cpp.DeviceSource;
import fr.esrf.tango.pogo.generator.cpp.DeviceStateMachine;
import fr.esrf.tango.pogo.generator.cpp.DynamicAttributeUtils;
import fr.esrf.tango.pogo.generator.cpp.Main;
import fr.esrf.tango.pogo.generator.cpp.projects.LinuxMakefile;
import fr.esrf.tango.pogo.generator.cpp.projects.VC10.VC10_Project;
import fr.esrf.tango.pogo.generator.cpp.projects.VC12.VC12_Project;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class CppGenerator
implements IGenerator {
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private DeviceInclude _deviceInclude;
    @Inject
    @Extension
    private DeviceSource _deviceSource;
    @Inject
    @Extension
    private DeviceClassInclude _deviceClassInclude;
    @Inject
    @Extension
    private DeviceClassSource _deviceClassSource;
    @Inject
    @Extension
    private DeviceStateMachine _deviceStateMachine;
    @Inject
    @Extension
    private DynamicAttributeUtils _dynamicAttributeUtils;
    @Inject
    @Extension
    private ClassFactory _classFactory;
    @Inject
    @Extension
    private Main _main;
    @Inject
    @Extension
    private LinuxMakefile _linuxMakefile;
    @Inject
    @Extension
    private VC10_Project _vC10_Project;
    @Inject
    @Extension
    private VC12_Project _vC12_Project;
    @Inject
    @Extension
    private EclipseProjects _eclipseProjects;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description_5;
            String _filestogenerate_4;
            boolean _contains_4;
            ClassDescription _description_4;
            String _filestogenerate_3;
            boolean _contains_3;
            ClassDescription _description_3;
            String _filestogenerate_2;
            String _lowerCase_1;
            boolean _contains_2;
            ClassDescription _description_2;
            String _filestogenerate_1;
            boolean _contains_1;
            ClassDescription _description = cls.getDescription();
            String _language = _description.getLanguage();
            String _lowerCase = _language.toLowerCase();
            boolean _equals = _lowerCase.equals("cpp");
            if (!_equals) continue;
            ClassDescription _description_1 = cls.getDescription();
            String _filestogenerate = _description_1.getFilestogenerate();
            boolean _contains = _filestogenerate.contains("Code files");
            if (_contains) {
                EList<Command> _dynamicCommands;
                int _size_1;
                boolean _greaterThan_1;
                boolean _greaterThan;
                String _deviceIncludeFileName = this._headers.deviceIncludeFileName(cls);
                String _plus = "Generating " + _deviceIncludeFileName;
                StringUtils.printTrace(_plus);
                String _deviceIncludeFileName_1 = this._headers.deviceIncludeFileName(cls);
                CharSequence _generateDeviceIncludeFile = this._deviceInclude.generateDeviceIncludeFile(cls);
                fsa.generateFile(_deviceIncludeFileName_1, _generateDeviceIncludeFile);
                String _deviceSourceFileName = this._headers.deviceSourceFileName(cls);
                String _plus_1 = "Generating " + _deviceSourceFileName;
                StringUtils.printTrace(_plus_1);
                String _deviceSourceFileName_1 = this._headers.deviceSourceFileName(cls);
                CharSequence _generateDeviceSourceFile = this._deviceSource.generateDeviceSourceFile(cls);
                fsa.generateFile(_deviceSourceFileName_1, _generateDeviceSourceFile);
                String _deviceClassIncludeFileName = this._headers.deviceClassIncludeFileName(cls);
                String _plus_2 = "Generating " + _deviceClassIncludeFileName;
                StringUtils.printTrace(_plus_2);
                String _deviceClassIncludeFileName_1 = this._headers.deviceClassIncludeFileName(cls);
                CharSequence _generateDeviceClassIncludeFile = this._deviceClassInclude.generateDeviceClassIncludeFile(cls);
                fsa.generateFile(_deviceClassIncludeFileName_1, _generateDeviceClassIncludeFile);
                String _deviceClassSourceFileName = this._headers.deviceClassSourceFileName(cls);
                String _plus_3 = "Generating " + _deviceClassSourceFileName;
                StringUtils.printTrace(_plus_3);
                String _deviceClassSourceFileName_1 = this._headers.deviceClassSourceFileName(cls);
                CharSequence _generateDeviceClassSourceFile = this._deviceClassSource.generateDeviceClassSourceFile(cls);
                fsa.generateFile(_deviceClassSourceFileName_1, _generateDeviceClassSourceFile);
                String _stateMachineFileName = this._headers.stateMachineFileName(cls);
                String _plus_4 = "Generating " + _stateMachineFileName;
                StringUtils.printTrace(_plus_4);
                String _stateMachineFileName_1 = this._headers.stateMachineFileName(cls);
                CharSequence _generateStateMachineSourceFile = this._deviceStateMachine.generateStateMachineSourceFile(cls);
                fsa.generateFile(_stateMachineFileName_1, _generateStateMachineSourceFile);
                StringUtils.printTrace("Generating ClassFactory.cpp");
                CharSequence _generateClassFactoryFile = this._classFactory.generateClassFactoryFile(cls);
                fsa.generateFile("ClassFactory.cpp", _generateClassFactoryFile);
                StringUtils.printTrace("Generating main.cpp");
                CharSequence _generateMainFile = this._main.generateMainFile(cls);
                fsa.generateFile("main.cpp", _generateMainFile);
                boolean _or = false;
                EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
                int _size = _dynamicAttributes.size();
                boolean bl = _greaterThan = _size > 0;
                _or = _greaterThan ? true : (_greaterThan_1 = (_size_1 = (_dynamicCommands = cls.getDynamicCommands()).size()) > 0);
                if (_or) {
                    String _dynamicAttrUtilsFileName = this._headers.dynamicAttrUtilsFileName(cls);
                    String _plus_5 = "Generating " + _dynamicAttrUtilsFileName;
                    StringUtils.printTrace(_plus_5);
                    String _dynamicAttrUtilsFileName_1 = this._headers.dynamicAttrUtilsFileName(cls);
                    CharSequence _generateDynamicAttrUtilsFile = this._dynamicAttributeUtils.generateDynamicAttrUtilsFile(cls);
                    fsa.generateFile(_dynamicAttrUtilsFileName_1, _generateDynamicAttrUtilsFile);
                }
            }
            if (_contains_1 = (_filestogenerate_1 = (_description_2 = cls.getDescription()).getFilestogenerate()).contains("Makefile")) {
                StringUtils.printTrace("Generating Makefile");
                CharSequence _generateLinuxMakefile = this._linuxMakefile.generateLinuxMakefile(cls);
                fsa.generateFile("Makefile", _generateLinuxMakefile);
            }
            if (_contains_2 = (_lowerCase_1 = (_filestogenerate_2 = (_description_3 = cls.getDescription()).getFilestogenerate()).toLowerCase()).contains("eclipse")) {
                StringUtils.printTrace("Generating Eclipse project");
                CharSequence _generateEclipseProject = this._eclipseProjects.generateEclipseProject(cls);
                fsa.generateFile(".project", _generateEclipseProject);
                CharSequence _generateCppEclipseProject = this._eclipseProjects.generateCppEclipseProject(cls);
                fsa.generateFile(".cproject", _generateCppEclipseProject);
            }
            if (_contains_3 = (_filestogenerate_3 = (_description_4 = cls.getDescription()).getFilestogenerate()).contains("VC10")) {
                StringUtils.printTrace("Generating VC10 project in vc10_proj");
                String _name = cls.getName();
                String _plus_6 = "vc10_proj/" + _name;
                String _plus_7 = String.valueOf(_plus_6) + ".sln";
                CharSequence _generateVC10_Project = this._vC10_Project.generateVC10_Project(cls);
                fsa.generateFile(_plus_7, _generateVC10_Project);
                CharSequence _generateVC10_ClassLib = this._vC10_Project.generateVC10_ClassLib(cls);
                fsa.generateFile("vc10_proj/Class_lib.vcxproj", _generateVC10_ClassLib);
                CharSequence _generateVC10_ServerStatic = this._vC10_Project.generateVC10_ServerStatic(cls);
                fsa.generateFile("vc10_proj/Server_static.vcxproj", _generateVC10_ServerStatic);
                CharSequence _generateVC10_ClassDll = this._vC10_Project.generateVC10_ClassDll(cls);
                fsa.generateFile("vc10_proj/Class_dll.vcxproj", _generateVC10_ClassDll);
                CharSequence _generateVC10_ServerShared = this._vC10_Project.generateVC10_ServerShared(cls);
                fsa.generateFile("vc10_proj/Server_shared.vcxproj", _generateVC10_ServerShared);
                CharSequence _generateVC10_Filters = this._vC10_Project.generateVC10_Filters(cls);
                fsa.generateFile("vc10_proj/Class_lib.vcxproj.filters", _generateVC10_Filters);
                CharSequence _generateVC10_Filters_1 = this._vC10_Project.generateVC10_Filters(cls);
                fsa.generateFile("vc10_proj/Class_dll.vcxproj.filters", _generateVC10_Filters_1);
            }
            if (!(_contains_4 = (_filestogenerate_4 = (_description_5 = cls.getDescription()).getFilestogenerate()).contains("VC12"))) continue;
            StringUtils.printTrace("Generating VC12 project in vc12_proj");
            String _name_1 = cls.getName();
            String _plus_8 = "vc12_proj/" + _name_1;
            String _plus_9 = String.valueOf(_plus_8) + ".sln";
            CharSequence _generateVC12_Project = this._vC12_Project.generateVC12_Project(cls);
            fsa.generateFile(_plus_9, _generateVC12_Project);
            CharSequence _generateVC12_ClassLib = this._vC12_Project.generateVC12_ClassLib(cls);
            fsa.generateFile("vc12_proj/Class_lib.vcxproj", _generateVC12_ClassLib);
            CharSequence _generateVC12_ServerStatic = this._vC12_Project.generateVC12_ServerStatic(cls);
            fsa.generateFile("vc12_proj/Server_static.vcxproj", _generateVC12_ServerStatic);
            CharSequence _generateVC12_ClassDll = this._vC12_Project.generateVC12_ClassDll(cls);
            fsa.generateFile("vc12_proj/Class_dll.vcxproj", _generateVC12_ClassDll);
            CharSequence _generateVC12_ServerShared = this._vC12_Project.generateVC12_ServerShared(cls);
            fsa.generateFile("vc12_proj/Server_shared.vcxproj", _generateVC12_ServerShared);
            CharSequence _generateVC12_Filters = this._vC12_Project.generateVC12_Filters(cls);
            fsa.generateFile("vc12_proj/Class_lib.vcxproj.filters", _generateVC12_Filters);
            CharSequence _generateVC12_Filters_1 = this._vC12_Project.generateVC12_Filters(cls);
            fsa.generateFile("vc12_proj/Class_dll.vcxproj.filters", _generateVC12_Filters_1);
        }
        TreeIterator<EObject> _allContents_1 = resource.getAllContents();
        Iterable<EObject> _iterable_1 = IteratorExtensions.toIterable(_allContents_1);
        Iterable<PogoMultiClasses> _filter_1 = Iterables.filter(_iterable_1, PogoMultiClasses.class);
        for (PogoMultiClasses multi : _filter_1) {
            String _filestogenerate_6;
            boolean _contains_6;
            String _filestogenerate_5 = multi.getFilestogenerate();
            boolean _contains_5 = _filestogenerate_5.contains("Code files");
            if (_contains_5) {
                boolean _equals_1;
                StringUtils.printTrace("Generating MultiClassesFactory.cpp");
                CharSequence _generateMultiClassesFactoryFile = this._classFactory.generateMultiClassesFactoryFile(multi);
                fsa.generateFile("MultiClassesFactory.cpp", _generateMultiClassesFactoryFile);
                String _sourcePath = multi.getSourcePath();
                String _plus_10 = String.valueOf(_sourcePath) + "/main.cpp";
                boolean _fileExists = StringUtils.fileExists(_plus_10);
                boolean bl = _equals_1 = !_fileExists;
                if (_equals_1) {
                    StringUtils.printTrace("Generating main.cpp");
                    CharSequence _generateMainFile_1 = this._main.generateMainFile(multi);
                    fsa.generateFile("main.cpp", _generateMainFile_1);
                }
            }
            if (!(_contains_6 = (_filestogenerate_6 = multi.getFilestogenerate()).contains("Makefile"))) continue;
            StringUtils.printTrace("Generating Makefile.multi");
            CharSequence _generateLinuxMakefileMultiClasses = this._linuxMakefile.generateLinuxMakefileMultiClasses(multi);
            fsa.generateFile("Makefile.multi", _generateLinuxMakefileMultiClasses);
        }
    }
}

