/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class ClassFactory {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;

    public CharSequence generateClassFactoryFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _openProtectedArea = this._protectedArea.openProtectedArea(cls, "ClassFactory.cpp");
        _builder.append((Object)_openProtectedArea, "");
        _builder.newLineIfNotEmpty();
        String _ClassFactoryFileHeader = this._headers.ClassFactoryFileHeader(cls);
        _builder.append((Object)_ClassFactoryFileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <tango.h>");
        _builder.newLine();
        _builder.append("#include <");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class.h>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//\tAdd class header files if needed");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tCreate ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append(" Class singleton and store it in DServer object.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void Tango::DServer::class_factory()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tAdd method class init if needed");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("add_class(");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("_ns::");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append("Class::init(\"");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append("\"));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        String _closeProtectedArea = this._protectedArea.closeProtectedArea(cls, "ClassFactory.cpp");
        _builder.append((Object)_closeProtectedArea, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateMultiClassesFactoryFile(PogoMultiClasses cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _ClassFactoryFileHeader = this._headers.ClassFactoryFileHeader(cls);
        _builder.append((Object)_ClassFactoryFileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <tango.h>");
        _builder.newLine();
        EList<OneClassSimpleDef> _classes = cls.getClasses();
        for (OneClassSimpleDef clazz : _classes) {
            _builder.append("#include <");
            String _classname = clazz.getClassname();
            _builder.append((Object)_classname, "");
            _builder.append("Class.h>");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tCreate Class singletons and store them in DServer object.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void Tango::DServer::class_factory()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        EList<OneClassSimpleDef> _classes_1 = cls.getClasses();
        for (OneClassSimpleDef clazz_1 : _classes_1) {
            _builder.append("\t");
            _builder.append("add_class(");
            String _classname_1 = clazz_1.getClassname();
            _builder.append((Object)_classname_1, "\t");
            _builder.append("_ns::");
            String _classname_2 = clazz_1.getClassname();
            _builder.append((Object)_classname_2, "\t");
            _builder.append("Class::init(\"");
            String _classname_3 = clazz_1.getClassname();
            _builder.append((Object)_classname_3, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

