/*
 * Decompiled with CFR 0.152.
 */
package zmq;

public class YQueue<T> {
    private Chunk<T> begin_chunk;
    private int begin_pos;
    private Chunk<T> back_chunk;
    private int back_pos;
    private Chunk<T> end_chunk;
    private int end_pos;
    private volatile Chunk<T> spare_chunk;
    private final int size;
    private int memory_ptr;

    public YQueue(int size) {
        this.size = size;
        this.memory_ptr = 0;
        this.begin_chunk = new Chunk(size, this.memory_ptr);
        this.memory_ptr += size;
        this.begin_pos = 0;
        this.back_pos = 0;
        this.back_chunk = this.begin_chunk;
        this.spare_chunk = this.begin_chunk;
        this.end_chunk = this.begin_chunk;
        this.end_pos = 1;
    }

    public final int front_pos() {
        return this.begin_chunk.pos[this.begin_pos];
    }

    public final T front() {
        return this.begin_chunk.values[this.begin_pos];
    }

    public final int back_pos() {
        return this.back_chunk.pos[this.back_pos];
    }

    public final T back() {
        return this.back_chunk.values[this.back_pos];
    }

    public final T pop() {
        Object val = this.begin_chunk.values[this.begin_pos];
        this.begin_chunk.values[this.begin_pos] = null;
        ++this.begin_pos;
        if (this.begin_pos == this.size) {
            this.begin_chunk = this.begin_chunk.next;
            this.begin_chunk.prev = null;
            this.begin_pos = 0;
        }
        return val;
    }

    public final void push(T val) {
        this.back_chunk.values[this.back_pos] = val;
        this.back_chunk = this.end_chunk;
        this.back_pos = this.end_pos++;
        if (this.end_pos != this.size) {
            return;
        }
        Chunk<T> sc = this.spare_chunk;
        if (sc != this.begin_chunk) {
            this.spare_chunk = this.spare_chunk.next;
            this.end_chunk.next = sc;
            sc.prev = this.end_chunk;
        } else {
            this.end_chunk.next = new Chunk(this.size, this.memory_ptr);
            this.memory_ptr += this.size;
            this.end_chunk.next.prev = this.end_chunk;
        }
        this.end_chunk = this.end_chunk.next;
        this.end_pos = 0;
    }

    public final void unpush() {
        if (this.back_pos > 0) {
            --this.back_pos;
        } else {
            this.back_pos = this.size - 1;
            this.back_chunk = this.back_chunk.prev;
        }
        if (this.end_pos > 0) {
            --this.end_pos;
        } else {
            this.end_pos = this.size - 1;
            this.end_chunk = this.end_chunk.prev;
            this.end_chunk.next = null;
        }
    }

    private class Chunk<T> {
        final T[] values;
        final int[] pos;
        Chunk prev;
        Chunk next;

        protected Chunk(int size, int memory_ptr) {
            this.values = new Object[size];
            this.pos = new int[size];
            for (int i = 0; i != this.values.length; ++i) {
                this.pos[i] = memory_ptr++;
            }
        }
    }
}

