/*
 * Decompiled with CFR 0.152.
 */
package org.tango.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReflectionScanner {
    private final Class<?> classToScan;
    final Map<Class<?>, Set<Method>> methods = new HashMap();
    final Map<Class<?>, Set<Field>> fields = new HashMap();

    public ReflectionScanner(Class<?> classToScan) {
        this.classToScan = classToScan;
        this.scanAnnotatedFields();
        this.scanAnnotatedMethods();
    }

    public Set<Method> getMethodsAnnotatedWith(Class<?> annototation) {
        return this.methods.get(annototation);
    }

    public Set<Field> getFieldsAnnotatedWith(Class<?> annototation) {
        return this.fields.get(annototation);
    }

    private void scanAnnotatedMethods() {
        for (Method method : this.classToScan.getDeclaredMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                if (this.methods.containsKey(annotation.annotationType())) {
                    this.methods.get(annotation.annotationType()).add(method);
                    continue;
                }
                HashSet<Method> list = new HashSet<Method>();
                list.add(method);
                this.methods.put(annotation.annotationType(), list);
            }
        }
    }

    private void scanAnnotatedFields() {
        for (Field field : this.classToScan.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (this.fields.containsKey(annotation.annotationType())) {
                    this.fields.get(annotation.annotationType()).add(field);
                    continue;
                }
                HashSet<Field> list = new HashSet<Field>();
                list.add(field);
                this.fields.put(annotation.annotationType(), list);
            }
        }
    }
}

