/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.properties;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.properties.PropertiesUtils;
import org.tango.utils.DevFailedUtils;

public final class DevicePropertiesImpl {
    private final XLogger xlogger = XLoggerFactory.getXLogger(DevicePropertiesImpl.class);
    private final Method propertyMethod;
    private final Object businessObject;
    private final String deviceName;

    public DevicePropertiesImpl(Method propertyField, Object businessObject, String deviceName) {
        this.propertyMethod = propertyField;
        this.businessObject = businessObject;
        this.deviceName = deviceName;
    }

    public void update() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        Map<String, String[]> property = PropertiesUtils.getDeviceProperties(this.deviceName);
        if (property != null && property.size() != 0) {
            try {
                this.propertyMethod.invoke(this.businessObject, property);
            }
            catch (IllegalArgumentException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (IllegalAccessException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (SecurityException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (InvocationTargetException e) {
                DevFailedUtils.throwDevFailed(e);
            }
        }
        this.xlogger.exit();
    }
}

