/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevVarLongStringArray;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.orb.ORBManager;
import org.tango.orb.ServerRequestInterceptor;
import org.tango.server.ServerManager;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.events.ArchiveEventTrigger;
import org.tango.server.events.ChangeEventTrigger;
import org.tango.server.events.EventConstants;
import org.tango.server.events.EventImpl;
import org.tango.server.events.EventType;
import org.tango.server.events.EventUtilities;
import org.tango.server.idl.TangoIDLUtil;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.pipe.PipeValue;
import org.tango.utils.DevFailedUtils;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public final class EventManager {
    private static ZContext context;
    private static final EventManager INSTANCE;
    public static final int MINIMUM_IDL_VERSION = 4;
    public static final String IDL_REGEX = "idl[0-9]_[a-z]*";
    public static final String IDL_LATEST = "idl5_";
    private static ZMQ.Socket heartbeatSocket;
    private static ZMQ.Socket eventSocket;
    private static boolean isInitialized;
    private static String heartbeatEndpoint;
    private static String eventEndpoint;
    private final Logger logger = LoggerFactory.getLogger(EventManager.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(EventManager.class);
    private final Map<String, EventImpl> eventImplMap = new HashMap<String, EventImpl>();
    private static ScheduledExecutorService heartBeatExecutor;
    private static int serverHWM;
    private static int clientHWN;

    public static EventManager getInstance() {
        return INSTANCE;
    }

    private EventManager() {
        serverHWM = 1000;
        String env = System.getenv("TANGO_DS_EVENT_BUFFER_HWM");
        try {
            if (env != null) {
                serverHWM = Integer.parseInt(env);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("system env TANGO_DS_EVENT_BUFFER_HWM is not a number: {} ", (Object)env);
        }
        clientHWN = 1000;
        String value = "";
        try {
            value = DatabaseFactory.getDatabase().getFreeProperty("CtrlSystem", "EventBufferHwm");
            clientHWN = Integer.parseInt(value);
        }
        catch (DevFailed e) {
            DevFailedUtils.logDevFailed(e, this.logger);
        }
        catch (NumberFormatException e) {
            this.logger.error("ControlSystem/EventBufferHwm property is not a number: {} ", (Object)value);
        }
        isInitialized = false;
    }

    private void initialize() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.logger.debug("client IP address is {}", (Object)ServerRequestInterceptor.getInstance().getClientIPAddress());
        try {
            context = new ZContext();
            this.logger.info("ZMQ ({}) SERVER event system started", (Object)EventUtilities.getZmqVersion());
        }
        catch (Throwable e) {
            DevFailedUtils.throwDevFailed("API_EventNotAvailable", "ZMQ classes not found. Event system is not available: " + e.getMessage());
        }
        String adminDeviceName = ServerManager.getInstance().getAdminDeviceName();
        this.setEndpoints(SocketType.HEARTBEAT);
        this.setEndpoints(SocketType.EVENTS);
        heartBeatExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Event HeartBeat");
            }
        });
        String heartbeatName = EventUtilities.buildHeartBeatEventName(adminDeviceName);
        heartBeatExecutor.scheduleAtFixedRate(new HeartbeatThread(heartbeatName), 0L, 9000L, TimeUnit.MILLISECONDS);
        isInitialized = true;
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextAvailablePort() throws DevFailed {
        ServerSocket ss1 = null;
        int port = 0;
        try {
            ss1 = new ServerSocket(0);
            ss1.setReuseAddress(true);
            port = ss1.getLocalPort();
        }
        catch (SocketException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        catch (IOException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        finally {
            if (ss1 != null) {
                try {
                    ss1.close();
                }
                catch (IOException e) {
                    DevFailedUtils.throwDevFailed(e);
                }
            }
        }
        return port;
    }

    private void setEndpoints(SocketType socketType) throws DevFailed {
        String ipAddress;
        this.xlogger.entry(new Object[0]);
        if (ORBManager.OAI_ADDR != null && !ORBManager.OAI_ADDR.isEmpty()) {
            ipAddress = ORBManager.OAI_ADDR;
        } else {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                throw DevFailedUtils.newDevFailed(e1);
            }
        }
        String endpoint = "tcp://" + ipAddress + ":" + this.getNextAvailablePort();
        ZMQ.Socket socket = context.createSocket(1);
        socket.setLinger(0L);
        socket.setReconnectIVL(-1L);
        this.logger.debug("bind ZMQ socket {} for {}", (Object)endpoint, (Object)socketType);
        socket.bind(endpoint);
        switch (socketType) {
            case HEARTBEAT: {
                heartbeatSocket = socket;
                heartbeatEndpoint = endpoint;
                break;
            }
            case EVENTS: {
                socket.setSndHWM(serverHWM);
                eventSocket = socket;
                eventEndpoint = endpoint;
                this.logger.debug("HWM has been set to {}", (Object)socket.getSndHWM());
            }
        }
        this.xlogger.exit();
    }

    private EventImpl getEventImpl(String fullName) {
        if (!isInitialized) {
            return null;
        }
        EventImpl eventImpl = this.eventImplMap.get(fullName);
        if (eventImpl != null && !eventImpl.isStillSubscribed()) {
            this.logger.debug("{} not subscribed any more", (Object)fullName);
            this.eventImplMap.remove(fullName);
            if (this.eventImplMap.isEmpty()) {
                this.logger.debug("no subscribers on server, closing resources");
                this.close();
            }
            eventImpl = null;
        }
        return eventImpl;
    }

    public boolean hasSubscriber(String deviceName) {
        boolean hasSubscriber = false;
        for (String eventName : this.eventImplMap.keySet()) {
            if (!eventName.toLowerCase(Locale.ENGLISH).contains(deviceName.toLowerCase(Locale.ENGLISH))) continue;
            hasSubscriber = true;
            break;
        }
        return hasSubscriber;
    }

    public void close() {
        this.xlogger.entry(new Object[0]);
        this.logger.debug("closing all event resources");
        if (heartBeatExecutor != null) {
            heartBeatExecutor.shutdown();
            try {
                heartBeatExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.error("could not stop event hearbeat");
            }
        }
        if (context != null) {
            context.destroy();
        }
        this.eventImplMap.clear();
        isInitialized = false;
        this.logger.debug("all event resources closed");
        this.xlogger.exit();
    }

    public DevVarLongStringArray getInfo() {
        DevVarLongStringArray longStringArray = new DevVarLongStringArray();
        longStringArray.lvalue = new int[]{900, 5, clientHWN, 0, 0, EventConstants.ZMQ_RELEASE};
        longStringArray.svalue = heartbeatEndpoint == null || eventEndpoint == null ? new String[]{"No ZMQ event yet !"} : new String[]{heartbeatEndpoint, eventEndpoint};
        return longStringArray;
    }

    public DevVarLongStringArray subcribe(String deviceName, PipeImpl pipe) throws DevFailed {
        String fullName;
        EventImpl eventImpl;
        this.xlogger.entry(new Object[0]);
        if (!isInitialized) {
            this.initialize();
        }
        if ((eventImpl = this.eventImplMap.get(fullName = EventUtilities.buildPipeEventName(deviceName, pipe.getName()))) == null) {
            eventImpl = new EventImpl(pipe, 5);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        return this.buildConnectionParameters(fullName);
    }

    public DevVarLongStringArray subcribe(String deviceName, AttributeImpl attribute, EventType eventType, int idlVersion) throws DevFailed {
        String fullName;
        EventImpl eventImpl;
        this.xlogger.entry(new Object[0]);
        if (!isInitialized) {
            this.initialize();
        }
        if ((eventImpl = this.eventImplMap.get(fullName = EventUtilities.buildEventName(deviceName, attribute.getName(), eventType, idlVersion))) == null) {
            if (attribute.getBehavior() instanceof ForwardedAttribute) {
                ForwardedAttribute fwdAttr = (ForwardedAttribute)attribute.getBehavior();
                fwdAttr.subscribe(eventType);
            }
            eventImpl = new EventImpl(attribute, eventType, idlVersion);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        this.logger.debug("starting event {}", (Object)fullName);
        return this.buildConnectionParameters(fullName);
    }

    public DevVarLongStringArray subcribe(String deviceName) throws DevFailed {
        String fullName;
        EventImpl eventImpl;
        this.xlogger.entry(new Object[0]);
        if (!isInitialized) {
            this.initialize();
        }
        if ((eventImpl = this.eventImplMap.get(fullName = EventUtilities.buildDeviceEventName(deviceName, EventType.INTERFACE_CHANGE_EVENT))) == null) {
            eventImpl = new EventImpl(5);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        return this.buildConnectionParameters(fullName);
    }

    private DevVarLongStringArray buildConnectionParameters(String fullName) {
        DevVarLongStringArray longStringArray = new DevVarLongStringArray();
        longStringArray.lvalue = new int[]{900, 5, clientHWN, 0, 0, EventConstants.ZMQ_RELEASE};
        longStringArray.svalue = new String[]{heartbeatEndpoint, eventEndpoint};
        this.logger.debug("event registered for {}", (Object)fullName);
        return longStringArray;
    }

    public void pushAttributeEvent(String deviceName, String attributeName, DevFailed devFailed) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (EventType eventType : EventType.values()) {
            String fullName5 = EventUtilities.buildEventName(deviceName, attributeName, eventType);
            EventImpl eventImpl5 = this.getEventImpl(fullName5);
            if (eventImpl5 == null) continue;
            eventImpl5.pushEvent(eventSocket, fullName5, devFailed);
        }
        this.xlogger.exit();
    }

    public void pushAttributeEvent(String deviceName, String attributeName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (EventType eventType : EventType.values()) {
            for (int idl = 4; idl <= 5; ++idl) {
                String fullName = EventUtilities.buildEventName(deviceName, attributeName, eventType, idl);
                EventImpl eventImpl = this.getEventImpl(fullName);
                if (eventImpl == null) continue;
                eventImpl.pushAttributeEvent(eventSocket, fullName);
            }
        }
        this.xlogger.exit();
    }

    public void pushAttributeEvent(String deviceName, String attributeName, EventType eventType) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (int idl = 4; idl <= 5; ++idl) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, eventType, idl);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            eventImpl.pushAttributeEvent(eventSocket, fullName);
        }
        this.xlogger.exit();
    }

    public void forceAttributePushEvent(String deviceName, String attributeName, EventType eventType) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, eventType);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.forcePushEvent(eventSocket, fullName);
        }
        this.xlogger.exit();
    }

    public void pushAttributeDataReadyEvent(String deviceName, String attributeName, int counter) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.DATA_READY_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushAttributeDataReadyEvent(eventSocket, fullName, counter);
        }
        this.xlogger.exit();
    }

    public void pushAttributeConfigEvent(String deviceName, String attributeName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (int idl = 4; idl <= 5; ++idl) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.ATT_CONF_EVENT, idl);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            eventImpl.pushAttributeConfigEvent(eventSocket, fullName);
        }
        this.xlogger.exit();
    }

    public void pushInterfaceChangedEvent(String deviceName, DevIntrChange deviceInterface) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildDeviceEventName(deviceName, EventType.INTERFACE_CHANGE_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushInterfaceChangeEvent(eventSocket, fullName, deviceInterface);
        }
        this.xlogger.exit();
    }

    public void pushPipeEvent(String deviceName, String pipeName, PipeValue blob) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildPipeEventName(deviceName, pipeName);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushPipeEvent(eventSocket, fullName, new DevPipeData(pipeName, TangoIDLUtil.getTime(blob.getTime()), blob.getValue().getDevPipeBlobObject()));
        }
        this.xlogger.exit();
    }

    public void pushPipeEvent(String deviceName, String pipeName, DevFailed devFailed) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildPipeEventName(deviceName, pipeName);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushEvent(eventSocket, fullName, devFailed);
        }
        this.xlogger.exit();
    }

    public static void checkEventCriteria(AttributeImpl attribute, EventType eventType) throws DevFailed {
        switch (eventType) {
            case CHANGE_EVENT: {
                ChangeEventTrigger.checkEventCriteria(attribute);
                break;
            }
            case ARCHIVE_EVENT: {
                ArchiveEventTrigger.checkEventCriteria(attribute);
                break;
            }
        }
    }

    static {
        INSTANCE = new EventManager();
        isInitialized = false;
        heartbeatEndpoint = null;
        eventEndpoint = null;
    }

    class HeartbeatThread
    implements Runnable {
        private final String heartbeatName;

        HeartbeatThread(String heartbeatName) {
            this.heartbeatName = heartbeatName;
        }

        @Override
        public void run() {
            EventManager.this.xlogger.entry(new Object[0]);
            if (!EventManager.this.eventImplMap.isEmpty()) {
                try {
                    heartbeatSocket.sendMore(this.heartbeatName);
                    heartbeatSocket.send(EventConstants.LITTLE_ENDIAN, 2);
                    heartbeatSocket.send(EventUtilities.marshall(0, false), 0);
                }
                catch (DevFailed e) {
                    DevFailedUtils.logDevFailed(e, EventManager.this.logger);
                }
                EventManager.this.logger.debug("Heartbeat sent for {}", (Object)this.heartbeatName);
            }
            EventManager.this.xlogger.exit();
        }
    }

    private static enum SocketType {
        HEARTBEAT,
        EVENTS;

    }
}

